/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.Configuration;
import org.apache.hudi.client.FlinkTaskContextSupplier;
import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.configuration.HadoopConfigurations;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.table.HoodieFlinkTable;
import org.apache.hudi.util.CommonClientUtils;
import org.apache.hudi.util.FlinkWriteClients;

public class FlinkTables {
    private FlinkTables() {
    }

    private static HoodieFlinkTable<?> createTableInternal(HoodieWriteConfig writeConfig, HoodieEngineContext context) {
        HoodieFlinkTable table = HoodieFlinkTable.create((HoodieWriteConfig)writeConfig, (HoodieEngineContext)context);
        CommonClientUtils.validateTableVersion((HoodieTableConfig)table.getMetaClient().getTableConfig(), (HoodieWriteConfig)writeConfig);
        return table;
    }

    public static HoodieFlinkTable<?> createTable(Configuration conf, RuntimeContext runtimeContext) {
        HoodieFlinkEngineContext context = new HoodieFlinkEngineContext(HadoopFSUtils.getStorageConf((org.apache.hadoop.conf.Configuration)HadoopConfigurations.getHadoopConf(conf)), (TaskContextSupplier)new FlinkTaskContextSupplier(runtimeContext));
        HoodieWriteConfig writeConfig = FlinkWriteClients.getHoodieClientConfig(conf, true);
        return FlinkTables.createTableInternal(writeConfig, (HoodieEngineContext)context);
    }

    public static HoodieFlinkTable<?> createTable(HoodieWriteConfig writeConfig, org.apache.hadoop.conf.Configuration hadoopConf, RuntimeContext runtimeContext) {
        HoodieFlinkEngineContext context = new HoodieFlinkEngineContext(HadoopFSUtils.getStorageConfWithCopy((org.apache.hadoop.conf.Configuration)hadoopConf), (TaskContextSupplier)new FlinkTaskContextSupplier(runtimeContext));
        return FlinkTables.createTableInternal(writeConfig, (HoodieEngineContext)context);
    }

    public static HoodieFlinkTable<?> createTable(Configuration conf) {
        HoodieWriteConfig writeConfig = FlinkWriteClients.getHoodieClientConfig(conf, true, false);
        return FlinkTables.createTableInternal(writeConfig, (HoodieEngineContext)HoodieFlinkEngineContext.DEFAULT);
    }
}

