/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet.vector.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.formats.parquet.vector.reader.AbstractColumnReader;
import org.apache.flink.table.data.vector.writable.WritableFloatVector;
import org.apache.flink.table.data.vector.writable.WritableIntVector;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.schema.PrimitiveType;

public class FloatColumnReader
extends AbstractColumnReader<WritableFloatVector> {
    public FloatColumnReader(ColumnDescriptor descriptor, PageReader pageReader) throws IOException {
        super(descriptor, pageReader);
        this.checkTypeName(PrimitiveType.PrimitiveTypeName.FLOAT);
    }

    @Override
    protected void readBatch(int rowId, int num, WritableFloatVector column) {
        int left = num;
        while (left > 0) {
            if (this.runLenDecoder.currentCount == 0) {
                this.runLenDecoder.readNextGroup();
            }
            int n = Math.min(left, this.runLenDecoder.currentCount);
            switch (this.runLenDecoder.mode) {
                case RLE: {
                    if (this.runLenDecoder.currentValue == this.maxDefLevel) {
                        this.readFloats(n, column, rowId);
                        break;
                    }
                    column.setNulls(rowId, n);
                    break;
                }
                case PACKED: {
                    for (int i = 0; i < n; ++i) {
                        if (this.runLenDecoder.currentBuffer[this.runLenDecoder.currentBufferIdx++] == this.maxDefLevel) {
                            column.setFloat(rowId + i, this.readFloat());
                            continue;
                        }
                        column.setNullAt(rowId + i);
                    }
                    break;
                }
            }
            rowId += n;
            left -= n;
            this.runLenDecoder.currentCount -= n;
        }
    }

    @Override
    protected void readBatchFromDictionaryIds(int rowId, int num, WritableFloatVector column, WritableIntVector dictionaryIds) {
        for (int i = rowId; i < rowId + num; ++i) {
            if (column.isNullAt(i)) continue;
            column.setFloat(i, this.dictionary.decodeToFloat(dictionaryIds.getInt(i)));
        }
    }

    private float readFloat() {
        return this.readDataBuffer(4).getFloat();
    }

    private void readFloats(int total, WritableFloatVector c, int rowId) {
        int requiredBytes = total * 4;
        ByteBuffer buffer = this.readDataBuffer(requiredBytes);
        if (buffer.hasArray()) {
            int offset = buffer.arrayOffset() + buffer.position();
            c.setFloatsFromBinary(rowId, total, buffer.array(), offset);
        } else {
            for (int i = 0; i < total; ++i) {
                c.setFloat(rowId + i, buffer.getFloat());
            }
        }
    }
}

