/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master.normalizer;

import java.io.IOException;
import org.apache.hudi.org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hudi.org.apache.hadoop.hbase.client.NormalizeTableFilterParams;
import org.apache.hudi.org.apache.hadoop.hbase.master.MasterServices;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class RegionNormalizerChore
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(RegionNormalizerChore.class);
    private final MasterServices master;

    public RegionNormalizerChore(MasterServices master) {
        super(master.getServerName() + "-RegionNormalizerChore", master, master.getConfiguration().getInt("hbase.normalizer.period", 300000));
        this.master = master;
    }

    @Override
    protected void chore() {
        try {
            this.master.normalizeRegions(new NormalizeTableFilterParams.Builder().build(), false);
        }
        catch (IOException e) {
            LOG.error("Failed to normalize regions.", (Throwable)e);
        }
    }
}

