/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.RpcChannel;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import com.google.protobuf.TextFormat;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hudi.org.apache.hadoop.hbase.CellScanner;
import org.apache.hudi.org.apache.hadoop.hbase.CellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.CompareOperator;
import org.apache.hudi.org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hudi.org.apache.hadoop.hbase.ExtendedCellBuilder;
import org.apache.hudi.org.apache.hadoop.hbase.ExtendedCellBuilderFactory;
import org.apache.hudi.org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hudi.org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValue;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.client.Append;
import org.apache.hudi.org.apache.hadoop.hbase.client.Consistency;
import org.apache.hudi.org.apache.hadoop.hbase.client.Delete;
import org.apache.hudi.org.apache.hadoop.hbase.client.Durability;
import org.apache.hudi.org.apache.hadoop.hbase.client.Get;
import org.apache.hudi.org.apache.hadoop.hbase.client.Increment;
import org.apache.hudi.org.apache.hadoop.hbase.client.Mutation;
import org.apache.hudi.org.apache.hadoop.hbase.client.PackagePrivateFieldAccessor;
import org.apache.hudi.org.apache.hadoop.hbase.client.Put;
import org.apache.hudi.org.apache.hadoop.hbase.client.Result;
import org.apache.hudi.org.apache.hadoop.hbase.client.Scan;
import org.apache.hudi.org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hudi.org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hudi.org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hudi.org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hudi.org.apache.hadoop.hbase.filter.Filter;
import org.apache.hudi.org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hudi.org.apache.hadoop.hbase.net.Address;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.ProtobufMagic;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.CellProtos;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.ComparatorProtos;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.FilterProtos;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.MapReduceProtos;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.RSGroupProtos;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.TableProtos;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hudi.org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hudi.org.apache.hadoop.hbase.util.Addressing;
import org.apache.hudi.org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.DynamicClassLoader;
import org.apache.hudi.org.apache.hadoop.hbase.util.ExceptionUtil;
import org.apache.hudi.org.apache.hadoop.hbase.util.Methods;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class ProtobufUtil {
    private static final Cell[] EMPTY_CELL_ARRAY = new Cell[0];
    private static final Result EMPTY_RESULT = Result.create(EMPTY_CELL_ARRAY);
    static final Result EMPTY_RESULT_EXISTS_TRUE = Result.create(null, true);
    static final Result EMPTY_RESULT_EXISTS_FALSE = Result.create(null, false);
    private static final Result EMPTY_RESULT_STALE = Result.create(EMPTY_CELL_ARRAY, null, true);
    private static final Result EMPTY_RESULT_EXISTS_TRUE_STALE = Result.create((Cell[])null, (Boolean)true, true);
    private static final Result EMPTY_RESULT_EXISTS_FALSE_STALE = Result.create((Cell[])null, (Boolean)false, true);
    private static final ClientProtos.Result EMPTY_RESULT_PB;
    private static final ClientProtos.Result EMPTY_RESULT_PB_EXISTS_TRUE;
    private static final ClientProtos.Result EMPTY_RESULT_PB_EXISTS_FALSE;
    private static final ClientProtos.Result EMPTY_RESULT_PB_STALE;
    private static final ClientProtos.Result EMPTY_RESULT_PB_EXISTS_TRUE_STALE;
    private static final ClientProtos.Result EMPTY_RESULT_PB_EXISTS_FALSE_STALE;
    private static AdminProtos.GetServerInfoRequest GET_SERVER_INFO_REQUEST;

    private ProtobufUtil() {
    }

    public static byte[] prependPBMagic(byte[] bytes) {
        return Bytes.add(ProtobufMagic.PB_MAGIC, bytes);
    }

    public static boolean isPBMagicPrefix(byte[] bytes) {
        return ProtobufMagic.isPBMagicPrefix(bytes);
    }

    public static boolean isPBMagicPrefix(byte[] bytes, int offset, int len) {
        return ProtobufMagic.isPBMagicPrefix(bytes, offset, len);
    }

    public static void expectPBMagicPrefix(byte[] bytes) throws DeserializationException {
        if (!ProtobufUtil.isPBMagicPrefix(bytes)) {
            String bytesPrefix = bytes == null ? "null" : Bytes.toStringBinary(bytes, 0, ProtobufMagic.PB_MAGIC.length);
            throw new DeserializationException("Missing pb magic " + Bytes.toString(ProtobufMagic.PB_MAGIC) + " prefix, bytes: " + bytesPrefix);
        }
    }

    public static int lengthOfPBMagic() {
        return ProtobufMagic.lengthOfPBMagic();
    }

    public static IOException getRemoteException(com.google.protobuf.ServiceException se) {
        return ProtobufUtil.makeIOExceptionOfException((Exception)se);
    }

    public static IOException getServiceException(ServiceException e) {
        Throwable t = e.getCause();
        if (ExceptionUtil.isInterrupt(t)) {
            return ExceptionUtil.asInterrupt(t);
        }
        return t instanceof IOException ? (IOException)t : new HBaseIOException(t);
    }

    public static IOException handleRemoteException(Exception e) {
        return ProtobufUtil.makeIOExceptionOfException(e);
    }

    private static IOException makeIOExceptionOfException(Exception e) {
        Throwable t = e;
        if (e instanceof com.google.protobuf.ServiceException || e instanceof ServiceException) {
            t = e.getCause();
        }
        if (ExceptionUtil.isInterrupt(t)) {
            return ExceptionUtil.asInterrupt(t);
        }
        if (t instanceof RemoteException) {
            t = ((RemoteException)t).unwrapRemoteException();
        }
        return t instanceof IOException ? (IOException)t : new HBaseIOException(t);
    }

    public static HBaseProtos.ServerName toServerName(ServerName serverName) {
        if (serverName == null) {
            return null;
        }
        HBaseProtos.ServerName.Builder builder = HBaseProtos.ServerName.newBuilder();
        builder.setHostName(serverName.getHostname());
        if (serverName.getPort() >= 0) {
            builder.setPort(serverName.getPort());
        }
        if (serverName.getStartcode() >= 0L) {
            builder.setStartCode(serverName.getStartcode());
        }
        return builder.build();
    }

    public static ServerName toServerName(HBaseProtos.ServerName proto) {
        if (proto == null) {
            return null;
        }
        String hostName = proto.getHostName();
        long startCode = -1L;
        int port = -1;
        if (proto.hasPort()) {
            port = proto.getPort();
        }
        if (proto.hasStartCode()) {
            startCode = proto.getStartCode();
        }
        return ServerName.valueOf(hostName, port, startCode);
    }

    public static Durability toDurability(ClientProtos.MutationProto.Durability proto) {
        switch (proto) {
            case USE_DEFAULT: {
                return Durability.USE_DEFAULT;
            }
            case SKIP_WAL: {
                return Durability.SKIP_WAL;
            }
            case ASYNC_WAL: {
                return Durability.ASYNC_WAL;
            }
            case SYNC_WAL: {
                return Durability.SYNC_WAL;
            }
            case FSYNC_WAL: {
                return Durability.FSYNC_WAL;
            }
        }
        return Durability.USE_DEFAULT;
    }

    public static ClientProtos.MutationProto.Durability toDurability(Durability d) {
        switch (d) {
            case USE_DEFAULT: {
                return ClientProtos.MutationProto.Durability.USE_DEFAULT;
            }
            case SKIP_WAL: {
                return ClientProtos.MutationProto.Durability.SKIP_WAL;
            }
            case ASYNC_WAL: {
                return ClientProtos.MutationProto.Durability.ASYNC_WAL;
            }
            case SYNC_WAL: {
                return ClientProtos.MutationProto.Durability.SYNC_WAL;
            }
            case FSYNC_WAL: {
                return ClientProtos.MutationProto.Durability.FSYNC_WAL;
            }
        }
        return ClientProtos.MutationProto.Durability.USE_DEFAULT;
    }

    public static Get toGet(ClientProtos.Get proto) throws IOException {
        if (proto == null) {
            return null;
        }
        byte[] row = proto.getRow().toByteArray();
        Get get2 = new Get(row);
        if (proto.hasCacheBlocks()) {
            get2.setCacheBlocks(proto.getCacheBlocks());
        }
        if (proto.hasMaxVersions()) {
            get2.setMaxVersions(proto.getMaxVersions());
        }
        if (proto.hasStoreLimit()) {
            get2.setMaxResultsPerColumnFamily(proto.getStoreLimit());
        }
        if (proto.hasStoreOffset()) {
            get2.setRowOffsetPerColumnFamily(proto.getStoreOffset());
        }
        if (proto.getCfTimeRangeCount() > 0) {
            for (HBaseProtos.ColumnFamilyTimeRange cftr : proto.getCfTimeRangeList()) {
                TimeRange timeRange = ProtobufUtil.protoToTimeRange(cftr.getTimeRange());
                get2.setColumnFamilyTimeRange(cftr.getColumnFamily().toByteArray(), timeRange.getMin(), timeRange.getMax());
            }
        }
        if (proto.hasTimeRange()) {
            TimeRange timeRange = ProtobufUtil.protoToTimeRange(proto.getTimeRange());
            get2.setTimeRange(timeRange.getMin(), timeRange.getMax());
        }
        if (proto.hasFilter()) {
            FilterProtos.Filter filter = proto.getFilter();
            get2.setFilter(ProtobufUtil.toFilter(filter));
        }
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            get2.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        if (proto.getColumnCount() > 0) {
            for (ClientProtos.Column column : proto.getColumnList()) {
                byte[] family = column.getFamily().toByteArray();
                if (column.getQualifierCount() > 0) {
                    for (ByteString qualifier : column.getQualifierList()) {
                        get2.addColumn(family, qualifier.toByteArray());
                    }
                    continue;
                }
                get2.addFamily(family);
            }
        }
        if (proto.hasExistenceOnly() && proto.getExistenceOnly()) {
            get2.setCheckExistenceOnly(true);
        }
        if (proto.hasConsistency()) {
            get2.setConsistency(ProtobufUtil.toConsistency(proto.getConsistency()));
        }
        if (proto.hasLoadColumnFamiliesOnDemand()) {
            get2.setLoadColumnFamiliesOnDemand(proto.getLoadColumnFamiliesOnDemand());
        }
        return get2;
    }

    public static Consistency toConsistency(ClientProtos.Consistency consistency) {
        switch (consistency) {
            case STRONG: {
                return Consistency.STRONG;
            }
            case TIMELINE: {
                return Consistency.TIMELINE;
            }
        }
        return Consistency.STRONG;
    }

    public static ClientProtos.Consistency toConsistency(Consistency consistency) {
        switch (consistency) {
            case STRONG: {
                return ClientProtos.Consistency.STRONG;
            }
            case TIMELINE: {
                return ClientProtos.Consistency.TIMELINE;
            }
        }
        return ClientProtos.Consistency.STRONG;
    }

    public static Put toPut(ClientProtos.MutationProto proto) throws IOException {
        return ProtobufUtil.toPut(proto, null);
    }

    public static Put toPut(ClientProtos.MutationProto proto, CellScanner cellScanner) throws IOException {
        int cellCount;
        ClientProtos.MutationProto.MutationType type = proto.getMutateType();
        assert (type == ClientProtos.MutationProto.MutationType.PUT) : type.name();
        long timestamp = proto.hasTimestamp() ? proto.getTimestamp() : Long.MAX_VALUE;
        Put put = proto.hasRow() ? new Put(proto.getRow().toByteArray(), timestamp) : null;
        int n = cellCount = proto.hasAssociatedCellCount() ? proto.getAssociatedCellCount() : 0;
        if (cellCount > 0) {
            if (cellScanner == null) {
                throw new DoNotRetryIOException("Cell count of " + cellCount + " but no cellScanner: " + ProtobufUtil.toShortString(proto));
            }
            for (int i = 0; i < cellCount; ++i) {
                if (!cellScanner.advance()) {
                    throw new DoNotRetryIOException("Cell count of " + cellCount + " but at index " + i + " no cell returned: " + ProtobufUtil.toShortString(proto));
                }
                Cell cell = cellScanner.current();
                if (put == null) {
                    put = new Put(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), timestamp);
                }
                put.add(cell);
            }
        } else {
            if (put == null) {
                throw new IllegalArgumentException("row cannot be null");
            }
            ExtendedCellBuilder cellBuilder = ExtendedCellBuilderFactory.create(CellBuilderType.SHALLOW_COPY);
            for (ClientProtos.MutationProto.ColumnValue column : proto.getColumnValueList()) {
                byte[] family = column.getFamily().toByteArray();
                for (ClientProtos.MutationProto.ColumnValue.QualifierValue qv : column.getQualifierValueList()) {
                    if (!qv.hasValue()) {
                        throw new DoNotRetryIOException("Missing required field: qualifier value");
                    }
                    long ts = timestamp;
                    if (qv.hasTimestamp()) {
                        ts = qv.getTimestamp();
                    }
                    if (qv.hasTags()) {
                        byte[] allTagsBytes = qv.getTags().toByteArray();
                        if (qv.hasDeleteType()) {
                            put.add(cellBuilder.clear().setRow(put.getRow()).setFamily(family).setQualifier(qv.hasQualifier() ? qv.getQualifier().toByteArray() : null).setTimestamp(ts).setType(ProtobufUtil.fromDeleteType(qv.getDeleteType()).getCode()).setTags(allTagsBytes).build());
                            continue;
                        }
                        put.add(cellBuilder.clear().setRow(put.getRow()).setFamily(family).setQualifier(qv.hasQualifier() ? qv.getQualifier().toByteArray() : null).setTimestamp(ts).setType(Cell.Type.Put).setValue(qv.hasValue() ? qv.getValue().toByteArray() : null).setTags(allTagsBytes).build());
                        continue;
                    }
                    if (qv.hasDeleteType()) {
                        put.add(cellBuilder.clear().setRow(put.getRow()).setFamily(family).setQualifier(qv.hasQualifier() ? qv.getQualifier().toByteArray() : null).setTimestamp(ts).setType(ProtobufUtil.fromDeleteType(qv.getDeleteType()).getCode()).build());
                        continue;
                    }
                    put.add(cellBuilder.clear().setRow(put.getRow()).setFamily(family).setQualifier(qv.hasQualifier() ? qv.getQualifier().toByteArray() : null).setTimestamp(ts).setType(Cell.Type.Put).setValue(qv.hasValue() ? qv.getValue().toByteArray() : null).build());
                }
            }
        }
        put.setDurability(ProtobufUtil.toDurability(proto.getDurability()));
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            put.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        return put;
    }

    public static Delete toDelete(ClientProtos.MutationProto proto) throws IOException {
        return ProtobufUtil.toDelete(proto, null);
    }

    public static Delete toDelete(ClientProtos.MutationProto proto, CellScanner cellScanner) throws IOException {
        int cellCount;
        ClientProtos.MutationProto.MutationType type = proto.getMutateType();
        assert (type == ClientProtos.MutationProto.MutationType.DELETE) : type.name();
        long timestamp = proto.hasTimestamp() ? proto.getTimestamp() : Long.MAX_VALUE;
        Delete delete = proto.hasRow() ? new Delete(proto.getRow().toByteArray(), timestamp) : null;
        int n = cellCount = proto.hasAssociatedCellCount() ? proto.getAssociatedCellCount() : 0;
        if (cellCount > 0) {
            if (cellScanner == null) {
                throw new DoNotRetryIOException("Cell count of " + cellCount + " but no cellScanner: " + TextFormat.shortDebugString((MessageOrBuilder)proto));
            }
            for (int i = 0; i < cellCount; ++i) {
                if (!cellScanner.advance()) {
                    throw new DoNotRetryIOException("Cell count of " + cellCount + " but at index " + i + " no cell returned: " + TextFormat.shortDebugString((MessageOrBuilder)proto));
                }
                Cell cell = cellScanner.current();
                if (delete == null) {
                    delete = new Delete(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), timestamp);
                }
                delete.add(cell);
            }
        } else {
            if (delete == null) {
                throw new IllegalArgumentException("row cannot be null");
            }
            for (ClientProtos.MutationProto.ColumnValue column : proto.getColumnValueList()) {
                byte[] family = column.getFamily().toByteArray();
                for (ClientProtos.MutationProto.ColumnValue.QualifierValue qv : column.getQualifierValueList()) {
                    ClientProtos.MutationProto.DeleteType deleteType = qv.getDeleteType();
                    byte[] qualifier = null;
                    if (qv.hasQualifier()) {
                        qualifier = qv.getQualifier().toByteArray();
                    }
                    long ts = Long.MAX_VALUE;
                    if (qv.hasTimestamp()) {
                        ts = qv.getTimestamp();
                    }
                    if (deleteType == ClientProtos.MutationProto.DeleteType.DELETE_ONE_VERSION) {
                        delete.addColumn(family, qualifier, ts);
                        continue;
                    }
                    if (deleteType == ClientProtos.MutationProto.DeleteType.DELETE_MULTIPLE_VERSIONS) {
                        delete.addColumns(family, qualifier, ts);
                        continue;
                    }
                    if (deleteType == ClientProtos.MutationProto.DeleteType.DELETE_FAMILY_VERSION) {
                        delete.addFamilyVersion(family, ts);
                        continue;
                    }
                    delete.addFamily(family, ts);
                }
            }
        }
        delete.setDurability(ProtobufUtil.toDurability(proto.getDurability()));
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            delete.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        return delete;
    }

    private static <T extends Mutation> T toDelta(Function<Bytes, T> supplier, ConsumerWithException<T, Cell> consumer, ClientProtos.MutationProto proto, CellScanner cellScanner) throws IOException {
        int cellCount;
        byte[] row = proto.hasRow() ? proto.getRow().toByteArray() : null;
        Mutation mutation = row == null ? null : (Mutation)supplier.apply(new Bytes(row));
        int n = cellCount = proto.hasAssociatedCellCount() ? proto.getAssociatedCellCount() : 0;
        if (cellCount > 0) {
            if (cellScanner == null) {
                throw new DoNotRetryIOException("Cell count of " + cellCount + " but no cellScanner: " + ProtobufUtil.toShortString(proto));
            }
            for (int i = 0; i < cellCount; ++i) {
                if (!cellScanner.advance()) {
                    throw new DoNotRetryIOException("Cell count of " + cellCount + " but at index " + i + " no cell returned: " + ProtobufUtil.toShortString(proto));
                }
                Cell cell = cellScanner.current();
                if (mutation == null) {
                    mutation = (Mutation)supplier.apply(new Bytes(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength()));
                }
                consumer.accept(mutation, cell);
            }
        } else {
            if (mutation == null) {
                throw new IllegalArgumentException("row cannot be null");
            }
            for (ClientProtos.MutationProto.ColumnValue column : proto.getColumnValueList()) {
                byte[] family = column.getFamily().toByteArray();
                for (ClientProtos.MutationProto.ColumnValue.QualifierValue qv : column.getQualifierValueList()) {
                    byte[] qualifier = qv.getQualifier().toByteArray();
                    if (!qv.hasValue()) {
                        throw new DoNotRetryIOException("Missing required field: qualifier value");
                    }
                    byte[] value = qv.getValue().toByteArray();
                    byte[] tags = null;
                    if (qv.hasTags()) {
                        tags = qv.getTags().toByteArray();
                    }
                    consumer.accept(mutation, CellUtil.createCell(mutation.getRow(), family, qualifier, qv.getTimestamp(), KeyValue.Type.Put, value, tags));
                }
            }
        }
        mutation.setDurability(ProtobufUtil.toDurability(proto.getDurability()));
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            mutation.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        return (T)mutation;
    }

    public static Append toAppend(ClientProtos.MutationProto proto, CellScanner cellScanner) throws IOException {
        ClientProtos.MutationProto.MutationType type = proto.getMutateType();
        assert (type == ClientProtos.MutationProto.MutationType.APPEND) : type.name();
        Append append = ProtobufUtil.toDelta(row -> new Append(row.get(), row.getOffset(), row.getLength()), Append::add, proto, cellScanner);
        if (proto.hasTimeRange()) {
            TimeRange timeRange = ProtobufUtil.protoToTimeRange(proto.getTimeRange());
            append.setTimeRange(timeRange.getMin(), timeRange.getMax());
        }
        return append;
    }

    public static Increment toIncrement(ClientProtos.MutationProto proto, CellScanner cellScanner) throws IOException {
        ClientProtos.MutationProto.MutationType type = proto.getMutateType();
        assert (type == ClientProtos.MutationProto.MutationType.INCREMENT) : type.name();
        Increment increment = ProtobufUtil.toDelta(row -> new Increment(row.get(), row.getOffset(), row.getLength()), Increment::add, proto, cellScanner);
        if (proto.hasTimeRange()) {
            TimeRange timeRange = ProtobufUtil.protoToTimeRange(proto.getTimeRange());
            increment.setTimeRange(timeRange.getMin(), timeRange.getMax());
        }
        return increment;
    }

    public static Mutation toMutation(ClientProtos.MutationProto proto) throws IOException {
        ClientProtos.MutationProto.MutationType type = proto.getMutateType();
        if (type == ClientProtos.MutationProto.MutationType.INCREMENT) {
            return ProtobufUtil.toIncrement(proto, null);
        }
        if (type == ClientProtos.MutationProto.MutationType.APPEND) {
            return ProtobufUtil.toAppend(proto, null);
        }
        if (type == ClientProtos.MutationProto.MutationType.DELETE) {
            return ProtobufUtil.toDelete(proto, null);
        }
        if (type == ClientProtos.MutationProto.MutationType.PUT) {
            return ProtobufUtil.toPut(proto, null);
        }
        throw new IOException("Unknown mutation type " + (Object)((Object)type));
    }

    public static Get toGet(ClientProtos.MutationProto proto, CellScanner cellScanner) throws IOException {
        int cellCount;
        ClientProtos.MutationProto.MutationType type = proto.getMutateType();
        assert (type == ClientProtos.MutationProto.MutationType.INCREMENT || type == ClientProtos.MutationProto.MutationType.APPEND) : type.name();
        byte[] row = proto.hasRow() ? proto.getRow().toByteArray() : null;
        Get get2 = null;
        int n = cellCount = proto.hasAssociatedCellCount() ? proto.getAssociatedCellCount() : 0;
        if (cellCount > 0) {
            if (cellScanner == null) {
                throw new DoNotRetryIOException("Cell count of " + cellCount + " but no cellScanner: " + TextFormat.shortDebugString((MessageOrBuilder)proto));
            }
            for (int i = 0; i < cellCount; ++i) {
                if (!cellScanner.advance()) {
                    throw new DoNotRetryIOException("Cell count of " + cellCount + " but at index " + i + " no cell returned: " + TextFormat.shortDebugString((MessageOrBuilder)proto));
                }
                Cell cell = cellScanner.current();
                if (get2 == null) {
                    get2 = new Get(Bytes.copy(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength()));
                }
                get2.addColumn(Bytes.copy(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength()), Bytes.copy(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()));
            }
        } else {
            get2 = new Get(row);
            for (ClientProtos.MutationProto.ColumnValue column : proto.getColumnValueList()) {
                byte[] family = column.getFamily().toByteArray();
                for (ClientProtos.MutationProto.ColumnValue.QualifierValue qv : column.getQualifierValueList()) {
                    byte[] qualifier = qv.getQualifier().toByteArray();
                    if (!qv.hasValue()) {
                        throw new DoNotRetryIOException("Missing required field: qualifier value");
                    }
                    get2.addColumn(family, qualifier);
                }
            }
        }
        if (proto.hasTimeRange()) {
            TimeRange timeRange = ProtobufUtil.protoToTimeRange(proto.getTimeRange());
            get2.setTimeRange(timeRange.getMin(), timeRange.getMax());
        }
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            get2.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        return get2;
    }

    public static ClientProtos.Scan.ReadType toReadType(Scan.ReadType readType) {
        switch (readType) {
            case DEFAULT: {
                return ClientProtos.Scan.ReadType.DEFAULT;
            }
            case STREAM: {
                return ClientProtos.Scan.ReadType.STREAM;
            }
            case PREAD: {
                return ClientProtos.Scan.ReadType.PREAD;
            }
        }
        throw new IllegalArgumentException("Unknown ReadType: " + (Object)((Object)readType));
    }

    public static Scan.ReadType toReadType(ClientProtos.Scan.ReadType readType) {
        switch (readType) {
            case DEFAULT: {
                return Scan.ReadType.DEFAULT;
            }
            case STREAM: {
                return Scan.ReadType.STREAM;
            }
            case PREAD: {
                return Scan.ReadType.PREAD;
            }
        }
        throw new IllegalArgumentException("Unknown ReadType: " + (Object)((Object)readType));
    }

    public static ClientProtos.Scan toScan(Scan scan) throws IOException {
        long mvccReadPoint;
        byte[] stopRow;
        byte[] startRow;
        Boolean loadColumnFamiliesOnDemand;
        ClientProtos.Scan.Builder scanBuilder = ClientProtos.Scan.newBuilder();
        scanBuilder.setCacheBlocks(scan.getCacheBlocks());
        if (scan.getBatch() > 0) {
            scanBuilder.setBatchSize(scan.getBatch());
        }
        if (scan.getMaxResultSize() > 0L) {
            scanBuilder.setMaxResultSize(scan.getMaxResultSize());
        }
        if (scan.isSmall()) {
            scanBuilder.setSmall(scan.isSmall());
        }
        if (scan.getAllowPartialResults()) {
            scanBuilder.setAllowPartialResults(scan.getAllowPartialResults());
        }
        if ((loadColumnFamiliesOnDemand = scan.getLoadColumnFamiliesOnDemandValue()) != null) {
            scanBuilder.setLoadColumnFamiliesOnDemand(loadColumnFamiliesOnDemand);
        }
        scanBuilder.setMaxVersions(scan.getMaxVersions());
        scan.getColumnFamilyTimeRange().forEach((cf, timeRange) -> scanBuilder.addCfTimeRange(HBaseProtos.ColumnFamilyTimeRange.newBuilder().setColumnFamily(ByteStringer.wrap(cf)).setTimeRange(ProtobufUtil.toTimeRange(timeRange)).build()));
        scanBuilder.setTimeRange(ProtobufUtil.toTimeRange(scan.getTimeRange()));
        Map<String, byte[]> attributes = scan.getAttributesMap();
        if (!attributes.isEmpty()) {
            HBaseProtos.NameBytesPair.Builder attributeBuilder = HBaseProtos.NameBytesPair.newBuilder();
            for (Map.Entry<String, byte[]> attribute : attributes.entrySet()) {
                attributeBuilder.setName(attribute.getKey());
                attributeBuilder.setValue(ByteStringer.wrap(attribute.getValue()));
                scanBuilder.addAttribute(attributeBuilder.build());
            }
        }
        if ((startRow = scan.getStartRow()) != null && startRow.length > 0) {
            scanBuilder.setStartRow(ByteStringer.wrap(startRow));
        }
        if ((stopRow = scan.getStopRow()) != null && stopRow.length > 0) {
            scanBuilder.setStopRow(ByteStringer.wrap(stopRow));
        }
        if (scan.hasFilter()) {
            scanBuilder.setFilter(ProtobufUtil.toFilter(scan.getFilter()));
        }
        if (scan.hasFamilies()) {
            ClientProtos.Column.Builder columnBuilder = ClientProtos.Column.newBuilder();
            for (Map.Entry<byte[], NavigableSet<byte[]>> family : scan.getFamilyMap().entrySet()) {
                columnBuilder.setFamily(ByteStringer.wrap(family.getKey()));
                NavigableSet<byte[]> qualifiers = family.getValue();
                columnBuilder.clearQualifier();
                if (qualifiers != null && qualifiers.size() > 0) {
                    for (byte[] qualifier : qualifiers) {
                        columnBuilder.addQualifier(ByteStringer.wrap(qualifier));
                    }
                }
                scanBuilder.addColumn(columnBuilder.build());
            }
        }
        if (scan.getMaxResultsPerColumnFamily() >= 0) {
            scanBuilder.setStoreLimit(scan.getMaxResultsPerColumnFamily());
        }
        if (scan.getRowOffsetPerColumnFamily() > 0) {
            scanBuilder.setStoreOffset(scan.getRowOffsetPerColumnFamily());
        }
        if (scan.isReversed()) {
            scanBuilder.setReversed(scan.isReversed());
        }
        if (scan.getConsistency() == Consistency.TIMELINE) {
            scanBuilder.setConsistency(ProtobufUtil.toConsistency(scan.getConsistency()));
        }
        if (scan.getCaching() > 0) {
            scanBuilder.setCaching(scan.getCaching());
        }
        if ((mvccReadPoint = PackagePrivateFieldAccessor.getMvccReadPoint(scan)) > 0L) {
            scanBuilder.setMvccReadPoint(mvccReadPoint);
        }
        if (!scan.includeStartRow()) {
            scanBuilder.setIncludeStartRow(false);
        }
        scanBuilder.setIncludeStopRow(scan.includeStopRow());
        if (scan.getReadType() != Scan.ReadType.DEFAULT) {
            scanBuilder.setReadType(ProtobufUtil.toReadType(scan.getReadType()));
        }
        return scanBuilder.build();
    }

    public static Scan toScan(ClientProtos.Scan proto) throws IOException {
        byte[] startRow = HConstants.EMPTY_START_ROW;
        byte[] stopRow = HConstants.EMPTY_END_ROW;
        boolean includeStartRow = true;
        boolean includeStopRow = false;
        if (proto.hasStartRow()) {
            startRow = proto.getStartRow().toByteArray();
        }
        if (proto.hasStopRow()) {
            stopRow = proto.getStopRow().toByteArray();
        }
        if (proto.hasIncludeStartRow()) {
            includeStartRow = proto.getIncludeStartRow();
        }
        if (proto.hasIncludeStopRow()) {
            includeStopRow = proto.getIncludeStopRow();
        }
        Scan scan = new Scan().withStartRow(startRow, includeStartRow).withStopRow(stopRow, includeStopRow);
        if (proto.hasCacheBlocks()) {
            scan.setCacheBlocks(proto.getCacheBlocks());
        }
        if (proto.hasMaxVersions()) {
            scan.setMaxVersions(proto.getMaxVersions());
        }
        if (proto.hasStoreLimit()) {
            scan.setMaxResultsPerColumnFamily(proto.getStoreLimit());
        }
        if (proto.hasStoreOffset()) {
            scan.setRowOffsetPerColumnFamily(proto.getStoreOffset());
        }
        if (proto.hasLoadColumnFamiliesOnDemand()) {
            scan.setLoadColumnFamiliesOnDemand(proto.getLoadColumnFamiliesOnDemand());
        }
        if (proto.getCfTimeRangeCount() > 0) {
            for (HBaseProtos.ColumnFamilyTimeRange cftr : proto.getCfTimeRangeList()) {
                TimeRange timeRange = ProtobufUtil.protoToTimeRange(cftr.getTimeRange());
                scan.setColumnFamilyTimeRange(cftr.getColumnFamily().toByteArray(), timeRange.getMin(), timeRange.getMax());
            }
        }
        if (proto.hasTimeRange()) {
            TimeRange timeRange = ProtobufUtil.protoToTimeRange(proto.getTimeRange());
            scan.setTimeRange(timeRange.getMin(), timeRange.getMax());
        }
        if (proto.hasFilter()) {
            FilterProtos.Filter filter = proto.getFilter();
            scan.setFilter(ProtobufUtil.toFilter(filter));
        }
        if (proto.hasBatchSize()) {
            scan.setBatch(proto.getBatchSize());
        }
        if (proto.hasMaxResultSize()) {
            scan.setMaxResultSize(proto.getMaxResultSize());
        }
        if (proto.hasSmall()) {
            scan.setSmall(proto.getSmall());
        }
        if (proto.hasAllowPartialResults()) {
            scan.setAllowPartialResults(proto.getAllowPartialResults());
        }
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            scan.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        if (proto.getColumnCount() > 0) {
            for (ClientProtos.Column column : proto.getColumnList()) {
                byte[] family = column.getFamily().toByteArray();
                if (column.getQualifierCount() > 0) {
                    for (ByteString qualifier : column.getQualifierList()) {
                        scan.addColumn(family, qualifier.toByteArray());
                    }
                    continue;
                }
                scan.addFamily(family);
            }
        }
        if (proto.hasReversed()) {
            scan.setReversed(proto.getReversed());
        }
        if (proto.hasConsistency()) {
            scan.setConsistency(ProtobufUtil.toConsistency(proto.getConsistency()));
        }
        if (proto.hasCaching()) {
            scan.setCaching(proto.getCaching());
        }
        if (proto.hasMvccReadPoint()) {
            PackagePrivateFieldAccessor.setMvccReadPoint(scan, proto.getMvccReadPoint());
        }
        if (scan.isSmall()) {
            scan.setReadType(Scan.ReadType.PREAD);
        } else if (proto.hasReadType()) {
            scan.setReadType(ProtobufUtil.toReadType(proto.getReadType()));
        }
        return scan;
    }

    public static ClientProtos.Get toGet(Get get2) throws IOException {
        Boolean loadColumnFamiliesOnDemand;
        ClientProtos.Get.Builder builder = ClientProtos.Get.newBuilder();
        builder.setRow(ByteStringer.wrap(get2.getRow()));
        builder.setCacheBlocks(get2.getCacheBlocks());
        builder.setMaxVersions(get2.getMaxVersions());
        if (get2.getFilter() != null) {
            builder.setFilter(ProtobufUtil.toFilter(get2.getFilter()));
        }
        get2.getColumnFamilyTimeRange().forEach((cf, timeRange) -> builder.addCfTimeRange(HBaseProtos.ColumnFamilyTimeRange.newBuilder().setColumnFamily(ByteStringer.wrap(cf)).setTimeRange(ProtobufUtil.toTimeRange(timeRange)).build()));
        builder.setTimeRange(ProtobufUtil.toTimeRange(get2.getTimeRange()));
        Map<String, byte[]> attributes = get2.getAttributesMap();
        if (!attributes.isEmpty()) {
            HBaseProtos.NameBytesPair.Builder attributeBuilder = HBaseProtos.NameBytesPair.newBuilder();
            for (Map.Entry<String, byte[]> attribute : attributes.entrySet()) {
                attributeBuilder.setName(attribute.getKey());
                attributeBuilder.setValue(ByteStringer.wrap(attribute.getValue()));
                builder.addAttribute(attributeBuilder.build());
            }
        }
        if (get2.hasFamilies()) {
            ClientProtos.Column.Builder columnBuilder = ClientProtos.Column.newBuilder();
            Map<byte[], NavigableSet<byte[]>> families = get2.getFamilyMap();
            for (Map.Entry<byte[], NavigableSet<byte[]>> family : families.entrySet()) {
                NavigableSet<byte[]> qualifiers = family.getValue();
                columnBuilder.setFamily(ByteStringer.wrap(family.getKey()));
                columnBuilder.clearQualifier();
                if (qualifiers != null && qualifiers.size() > 0) {
                    for (byte[] qualifier : qualifiers) {
                        columnBuilder.addQualifier(ByteStringer.wrap(qualifier));
                    }
                }
                builder.addColumn(columnBuilder.build());
            }
        }
        if (get2.getMaxResultsPerColumnFamily() >= 0) {
            builder.setStoreLimit(get2.getMaxResultsPerColumnFamily());
        }
        if (get2.getRowOffsetPerColumnFamily() > 0) {
            builder.setStoreOffset(get2.getRowOffsetPerColumnFamily());
        }
        if (get2.isCheckExistenceOnly()) {
            builder.setExistenceOnly(true);
        }
        if (get2.getConsistency() != null && get2.getConsistency() != Consistency.STRONG) {
            builder.setConsistency(ProtobufUtil.toConsistency(get2.getConsistency()));
        }
        if ((loadColumnFamiliesOnDemand = get2.getLoadColumnFamiliesOnDemandValue()) != null) {
            builder.setLoadColumnFamiliesOnDemand(loadColumnFamiliesOnDemand);
        }
        return builder.build();
    }

    public static ClientProtos.MutationProto toMutation(ClientProtos.MutationProto.MutationType type, Mutation mutation) throws IOException {
        return ProtobufUtil.toMutation(type, mutation, 0L);
    }

    public static ClientProtos.MutationProto toMutation(ClientProtos.MutationProto.MutationType type, Mutation mutation, long nonce) throws IOException {
        return ProtobufUtil.toMutation(type, mutation, ClientProtos.MutationProto.newBuilder(), nonce);
    }

    public static ClientProtos.MutationProto toMutation(ClientProtos.MutationProto.MutationType type, Mutation mutation, ClientProtos.MutationProto.Builder builder) throws IOException {
        return ProtobufUtil.toMutation(type, mutation, builder, 0L);
    }

    public static ClientProtos.MutationProto toMutation(ClientProtos.MutationProto.MutationType type, Mutation mutation, ClientProtos.MutationProto.Builder builder, long nonce) throws IOException {
        builder = ProtobufUtil.getMutationBuilderAndSetCommonFields(type, mutation, builder);
        if (nonce != 0L) {
            builder.setNonce(nonce);
        }
        if (type == ClientProtos.MutationProto.MutationType.INCREMENT) {
            builder.setTimeRange(ProtobufUtil.toTimeRange(((Increment)mutation).getTimeRange()));
        }
        if (type == ClientProtos.MutationProto.MutationType.APPEND) {
            builder.setTimeRange(ProtobufUtil.toTimeRange(((Append)mutation).getTimeRange()));
        }
        ClientProtos.MutationProto.ColumnValue.Builder columnBuilder = ClientProtos.MutationProto.ColumnValue.newBuilder();
        ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder valueBuilder = ClientProtos.MutationProto.ColumnValue.QualifierValue.newBuilder();
        for (Map.Entry family : mutation.getFamilyCellMap().entrySet()) {
            columnBuilder.clear();
            columnBuilder.setFamily(ByteStringer.wrap((byte[])family.getKey()));
            for (Cell cell : (List)family.getValue()) {
                valueBuilder.clear();
                valueBuilder.setQualifier(ByteStringer.wrap(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()));
                valueBuilder.setValue(ByteStringer.wrap(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()));
                valueBuilder.setTimestamp(cell.getTimestamp());
                if (type == ClientProtos.MutationProto.MutationType.DELETE || type == ClientProtos.MutationProto.MutationType.PUT && CellUtil.isDelete(cell)) {
                    KeyValue.Type keyValueType = KeyValue.Type.codeToType(cell.getTypeByte());
                    valueBuilder.setDeleteType(ProtobufUtil.toDeleteType(keyValueType));
                }
                columnBuilder.addQualifierValue(valueBuilder.build());
            }
            builder.addColumnValue(columnBuilder.build());
        }
        return builder.build();
    }

    public static ClientProtos.MutationProto toMutationNoData(ClientProtos.MutationProto.MutationType type, Mutation mutation, ClientProtos.MutationProto.Builder builder) throws IOException {
        return ProtobufUtil.toMutationNoData(type, mutation, builder, 0L);
    }

    public static ClientProtos.MutationProto toMutationNoData(ClientProtos.MutationProto.MutationType type, Mutation mutation) throws IOException {
        ClientProtos.MutationProto.Builder builder = ClientProtos.MutationProto.newBuilder();
        return ProtobufUtil.toMutationNoData(type, mutation, builder);
    }

    public static ClientProtos.MutationProto toMutationNoData(ClientProtos.MutationProto.MutationType type, Mutation mutation, ClientProtos.MutationProto.Builder builder, long nonce) throws IOException {
        ProtobufUtil.getMutationBuilderAndSetCommonFields(type, mutation, builder);
        builder.setAssociatedCellCount(mutation.size());
        if (mutation instanceof Increment) {
            builder.setTimeRange(ProtobufUtil.toTimeRange(((Increment)mutation).getTimeRange()));
        }
        if (mutation instanceof Append) {
            builder.setTimeRange(ProtobufUtil.toTimeRange(((Append)mutation).getTimeRange()));
        }
        if (nonce != 0L) {
            builder.setNonce(nonce);
        }
        return builder.build();
    }

    private static ClientProtos.MutationProto.Builder getMutationBuilderAndSetCommonFields(ClientProtos.MutationProto.MutationType type, Mutation mutation, ClientProtos.MutationProto.Builder builder) {
        builder.setRow(ByteStringer.wrap(mutation.getRow()));
        builder.setMutateType(type);
        builder.setDurability(ProtobufUtil.toDurability(mutation.getDurability()));
        builder.setTimestamp(mutation.getTimestamp());
        Map<String, byte[]> attributes = mutation.getAttributesMap();
        if (!attributes.isEmpty()) {
            HBaseProtos.NameBytesPair.Builder attributeBuilder = HBaseProtos.NameBytesPair.newBuilder();
            for (Map.Entry<String, byte[]> attribute : attributes.entrySet()) {
                attributeBuilder.setName(attribute.getKey());
                attributeBuilder.setValue(ByteStringer.wrap(attribute.getValue()));
                builder.addAttribute(attributeBuilder.build());
            }
        }
        return builder;
    }

    public static ClientProtos.Result toResult(Result result) {
        if (result.getExists() != null) {
            return ProtobufUtil.toResult(result.getExists(), result.isStale());
        }
        Cell[] cells = result.rawCells();
        if (cells == null || cells.length == 0) {
            return result.isStale() ? EMPTY_RESULT_PB_STALE : EMPTY_RESULT_PB;
        }
        ClientProtos.Result.Builder builder = ClientProtos.Result.newBuilder();
        for (Cell c : cells) {
            builder.addCell(ProtobufUtil.toCell(c));
        }
        builder.setStale(result.isStale());
        builder.setPartial(result.mayHaveMoreCellsInRow());
        return builder.build();
    }

    public static ClientProtos.Result toResult(boolean existence, boolean stale) {
        if (stale) {
            return existence ? EMPTY_RESULT_PB_EXISTS_TRUE_STALE : EMPTY_RESULT_PB_EXISTS_FALSE_STALE;
        }
        return existence ? EMPTY_RESULT_PB_EXISTS_TRUE : EMPTY_RESULT_PB_EXISTS_FALSE;
    }

    public static ClientProtos.Result toResultNoData(Result result) {
        if (result.getExists() != null) {
            return ProtobufUtil.toResult(result.getExists(), result.isStale());
        }
        int size = result.size();
        if (size == 0) {
            return result.isStale() ? EMPTY_RESULT_PB_STALE : EMPTY_RESULT_PB;
        }
        ClientProtos.Result.Builder builder = ClientProtos.Result.newBuilder();
        builder.setAssociatedCellCount(size);
        builder.setStale(result.isStale());
        return builder.build();
    }

    public static Result toResult(ClientProtos.Result proto) {
        if (proto.hasExists()) {
            if (proto.getStale()) {
                return proto.getExists() ? EMPTY_RESULT_EXISTS_TRUE_STALE : EMPTY_RESULT_EXISTS_FALSE_STALE;
            }
            return proto.getExists() ? EMPTY_RESULT_EXISTS_TRUE : EMPTY_RESULT_EXISTS_FALSE;
        }
        List<CellProtos.Cell> values2 = proto.getCellList();
        if (values2.isEmpty()) {
            return proto.getStale() ? EMPTY_RESULT_STALE : EMPTY_RESULT;
        }
        ArrayList<Cell> cells = new ArrayList<Cell>(values2.size());
        ExtendedCellBuilder builder = ExtendedCellBuilderFactory.create(CellBuilderType.SHALLOW_COPY);
        for (CellProtos.Cell c : values2) {
            cells.add(ProtobufUtil.toCell(builder, c));
        }
        return Result.create(cells, null, proto.getStale(), proto.getPartial());
    }

    public static Result toResult(ClientProtos.Result proto, CellScanner scanner) throws IOException {
        List<CellProtos.Cell> values2 = proto.getCellList();
        if (proto.hasExists()) {
            if (!values2.isEmpty() || proto.hasAssociatedCellCount() && proto.getAssociatedCellCount() > 0) {
                throw new IllegalArgumentException("bad proto: exists with cells is no allowed " + proto);
            }
            if (proto.getStale()) {
                return proto.getExists() ? EMPTY_RESULT_EXISTS_TRUE_STALE : EMPTY_RESULT_EXISTS_FALSE_STALE;
            }
            return proto.getExists() ? EMPTY_RESULT_EXISTS_TRUE : EMPTY_RESULT_EXISTS_FALSE;
        }
        ArrayList<Cell> cells = null;
        if (proto.hasAssociatedCellCount()) {
            int count = proto.getAssociatedCellCount();
            cells = new ArrayList<Cell>(count + values2.size());
            for (int i = 0; i < count; ++i) {
                if (!scanner.advance()) {
                    throw new IOException("Failed get " + i + " of " + count);
                }
                cells.add(scanner.current());
            }
        }
        if (!values2.isEmpty()) {
            if (cells == null) {
                cells = new ArrayList(values2.size());
            }
            ExtendedCellBuilder builder = ExtendedCellBuilderFactory.create(CellBuilderType.SHALLOW_COPY);
            for (CellProtos.Cell c : values2) {
                cells.add(ProtobufUtil.toCell(builder, c));
            }
        }
        return cells == null || cells.isEmpty() ? (proto.getStale() ? EMPTY_RESULT_STALE : EMPTY_RESULT) : Result.create(cells, null, proto.getStale());
    }

    public static ComparatorProtos.Comparator toComparator(ByteArrayComparable comparator) {
        ComparatorProtos.Comparator.Builder builder = ComparatorProtos.Comparator.newBuilder();
        builder.setName(comparator.getClass().getName());
        builder.setSerializedComparator(ByteStringer.wrap(comparator.toByteArray()));
        return builder.build();
    }

    public static ByteArrayComparable toComparator(ComparatorProtos.Comparator proto) throws IOException {
        String type = proto.getName();
        String funcName = "parseFrom";
        byte[] value = proto.getSerializedComparator().toByteArray();
        try {
            Class<?> c = Class.forName(type, true, ClassLoaderHolder.CLASS_LOADER);
            Method parseFrom = c.getMethod(funcName, byte[].class);
            if (parseFrom == null) {
                throw new IOException("Unable to locate function: " + funcName + " in type: " + type);
            }
            return (ByteArrayComparable)parseFrom.invoke(null, new Object[]{value});
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static Filter toFilter(FilterProtos.Filter proto) throws IOException {
        String type = proto.getName();
        byte[] value = proto.getSerializedFilter().toByteArray();
        String funcName = "parseFrom";
        try {
            Class<?> c = Class.forName(type, true, ClassLoaderHolder.CLASS_LOADER);
            Method parseFrom = c.getMethod(funcName, byte[].class);
            if (parseFrom == null) {
                throw new IOException("Unable to locate function: " + funcName + " in type: " + type);
            }
            return (Filter)parseFrom.invoke(c, new Object[]{value});
        }
        catch (Exception e) {
            throw new DoNotRetryIOException(e);
        }
    }

    public static FilterProtos.Filter toFilter(Filter filter) throws IOException {
        FilterProtos.Filter.Builder builder = FilterProtos.Filter.newBuilder();
        builder.setName(filter.getClass().getName());
        builder.setSerializedFilter(ByteStringer.wrap(filter.toByteArray()));
        return builder.build();
    }

    public static ClientProtos.MutationProto.DeleteType toDeleteType(KeyValue.Type type) throws IOException {
        switch (type) {
            case Delete: {
                return ClientProtos.MutationProto.DeleteType.DELETE_ONE_VERSION;
            }
            case DeleteColumn: {
                return ClientProtos.MutationProto.DeleteType.DELETE_MULTIPLE_VERSIONS;
            }
            case DeleteFamily: {
                return ClientProtos.MutationProto.DeleteType.DELETE_FAMILY;
            }
            case DeleteFamilyVersion: {
                return ClientProtos.MutationProto.DeleteType.DELETE_FAMILY_VERSION;
            }
        }
        throw new IOException("Unknown delete type: " + (Object)((Object)type));
    }

    public static KeyValue.Type fromDeleteType(ClientProtos.MutationProto.DeleteType type) throws IOException {
        switch (type) {
            case DELETE_ONE_VERSION: {
                return KeyValue.Type.Delete;
            }
            case DELETE_MULTIPLE_VERSIONS: {
                return KeyValue.Type.DeleteColumn;
            }
            case DELETE_FAMILY: {
                return KeyValue.Type.DeleteFamily;
            }
            case DELETE_FAMILY_VERSION: {
                return KeyValue.Type.DeleteFamilyVersion;
            }
        }
        throw new IOException("Unknown delete type: " + (Object)((Object)type));
    }

    public static Throwable toException(HBaseProtos.NameBytesPair parameter) throws IOException {
        if (parameter == null || !parameter.hasValue()) {
            return null;
        }
        String desc = parameter.getValue().toStringUtf8();
        String type = parameter.getName();
        try {
            Class<?> c = Class.forName(type, true, ClassLoaderHolder.CLASS_LOADER);
            Constructor<?> cn = null;
            try {
                cn = c.getDeclaredConstructor(String.class);
                return (Throwable)cn.newInstance(desc);
            }
            catch (NoSuchMethodException e) {
                cn = c.getDeclaredConstructor(String.class, String.class);
                return (Throwable)cn.newInstance(type, desc);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static <T extends Service> T newServiceStub(Class<T> service, RpcChannel channel) throws Exception {
        return (T)((Service)Methods.call(service, null, "newStub", new Class[]{RpcChannel.class}, new Object[]{channel}));
    }

    public static AdminProtos.ServerInfo getServerInfo(RpcController controller, AdminProtos.AdminService.BlockingInterface admin) throws IOException {
        AdminProtos.GetServerInfoRequest request = ProtobufUtil.buildGetServerInfoRequest();
        try {
            AdminProtos.GetServerInfoResponse response = admin.getServerInfo(controller, request);
            return response.getServerInfo();
        }
        catch (com.google.protobuf.ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public static AdminProtos.GetServerInfoRequest buildGetServerInfoRequest() {
        return GET_SERVER_INFO_REQUEST;
    }

    public static ScanMetrics toScanMetrics(byte[] bytes) {
        Parser<MapReduceProtos.ScanMetrics> parser = MapReduceProtos.ScanMetrics.PARSER;
        MapReduceProtos.ScanMetrics pScanMetrics = null;
        try {
            pScanMetrics = (MapReduceProtos.ScanMetrics)parser.parseFrom(bytes);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            // empty catch block
        }
        ScanMetrics scanMetrics = new ScanMetrics();
        if (pScanMetrics != null) {
            for (HBaseProtos.NameInt64Pair pair : pScanMetrics.getMetricsList()) {
                if (!pair.hasName() || !pair.hasValue()) continue;
                scanMetrics.setCounter(pair.getName(), pair.getValue());
            }
        }
        return scanMetrics;
    }

    public static void toIOException(com.google.protobuf.ServiceException se) throws IOException {
        if (se == null) {
            throw new NullPointerException("Null service exception passed!");
        }
        Throwable cause = se.getCause();
        if (cause != null && cause instanceof IOException) {
            throw (IOException)cause;
        }
        throw new IOException(se);
    }

    public static CellProtos.Cell toCell(Cell kv) {
        CellProtos.Cell.Builder kvbuilder = CellProtos.Cell.newBuilder();
        kvbuilder.setRow(ByteStringer.wrap(kv.getRowArray(), kv.getRowOffset(), kv.getRowLength()));
        kvbuilder.setFamily(ByteStringer.wrap(kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength()));
        kvbuilder.setQualifier(ByteStringer.wrap(kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength()));
        kvbuilder.setCellType(CellProtos.CellType.valueOf(kv.getTypeByte()));
        kvbuilder.setTimestamp(kv.getTimestamp());
        kvbuilder.setValue(ByteStringer.wrap(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength()));
        return kvbuilder.build();
    }

    public static Cell toCell(ExtendedCellBuilder cellBuilder, CellProtos.Cell cell) {
        return cellBuilder.clear().setRow(cell.getRow().toByteArray()).setFamily(cell.getFamily().toByteArray()).setQualifier(cell.getQualifier().toByteArray()).setTimestamp(cell.getTimestamp()).setType((byte)cell.getCellType().getNumber()).setValue(cell.getValue().toByteArray()).build();
    }

    static String toShortString(ClientProtos.MutationProto proto) {
        return "row=" + Bytes.toString(proto.getRow().toByteArray()) + ", type=" + proto.getMutateType().toString();
    }

    public static TableName toTableName(TableProtos.TableName tableNamePB) {
        return TableName.valueOf(tableNamePB.getNamespace().asReadOnlyByteBuffer(), tableNamePB.getQualifier().asReadOnlyByteBuffer());
    }

    public static TableProtos.TableName toProtoTableName(TableName tableName) {
        return TableProtos.TableName.newBuilder().setNamespace(ByteStringer.wrap(tableName.getNamespace())).setQualifier(ByteStringer.wrap(tableName.getQualifier())).build();
    }

    public static void mergeFrom(Message.Builder builder, byte[] b) throws IOException {
        CodedInputStream codedInput = CodedInputStream.newInstance((byte[])b);
        codedInput.setSizeLimit(b.length);
        builder.mergeFrom(codedInput);
        codedInput.checkLastTagWas(0);
    }

    public static void mergeFrom(Message.Builder builder, byte[] b, int offset, int length) throws IOException {
        CodedInputStream codedInput = CodedInputStream.newInstance((byte[])b, (int)offset, (int)length);
        codedInput.setSizeLimit(length);
        builder.mergeFrom(codedInput);
        codedInput.checkLastTagWas(0);
    }

    private static TimeRange protoToTimeRange(HBaseProtos.TimeRange timeRange) throws IOException {
        long minStamp = 0L;
        long maxStamp = Long.MAX_VALUE;
        if (timeRange.hasFrom()) {
            minStamp = timeRange.getFrom();
        }
        if (timeRange.hasTo()) {
            maxStamp = timeRange.getTo();
        }
        return new TimeRange(minStamp, maxStamp);
    }

    public static HBaseProtos.SnapshotDescription.Type createProtosSnapShotDescType(SnapshotType type) {
        return HBaseProtos.SnapshotDescription.Type.valueOf(type.name());
    }

    public static HBaseProtos.RegionSpecifier buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType type, byte[] value) {
        HBaseProtos.RegionSpecifier.Builder regionBuilder = HBaseProtos.RegionSpecifier.newBuilder();
        regionBuilder.setValue(ByteStringer.wrap(value));
        regionBuilder.setType(type);
        return regionBuilder.build();
    }

    public static ServerName toServerName(byte[] data) throws DeserializationException {
        if (data == null || data.length <= 0) {
            return null;
        }
        if (ProtobufMagic.isPBMagicPrefix(data)) {
            int prefixLen = ProtobufMagic.lengthOfPBMagic();
            try {
                ZooKeeperProtos.Master rss = (ZooKeeperProtos.Master)ZooKeeperProtos.Master.PARSER.parseFrom(data, prefixLen, data.length - prefixLen);
                HBaseProtos.ServerName sn = rss.getMaster();
                return ServerName.valueOf(sn.getHostName(), sn.getPort(), sn.getStartCode());
            }
            catch (IOException e) {
                throw new DeserializationException(e);
            }
        }
        String str = Bytes.toString(data);
        int index = str.indexOf(",");
        if (index != -1) {
            return ServerName.parseVersionedServerName(data);
        }
        String hostname = Addressing.parseHostname(str);
        int port = Addressing.parsePort(str);
        return ServerName.valueOf(hostname, port, -1L);
    }

    public static RSGroupInfo toGroupInfo(RSGroupProtos.RSGroupInfo proto) {
        RSGroupInfo RSGroupInfo2 = new RSGroupInfo(proto.getName());
        for (HBaseProtos.ServerName el : proto.getServersList()) {
            RSGroupInfo2.addServer(Address.fromParts(el.getHostName(), el.getPort()));
        }
        for (TableProtos.TableName pTableName : proto.getTablesList()) {
            RSGroupInfo2.addTable(ProtobufUtil.toTableName(pTableName));
        }
        return RSGroupInfo2;
    }

    public static HBaseProtos.TimeRange toTimeRange(TimeRange timeRange) {
        if (timeRange == null) {
            timeRange = TimeRange.allTime();
        }
        return HBaseProtos.TimeRange.newBuilder().setFrom(timeRange.getMin()).setTo(timeRange.getMax()).build();
    }

    public static TimeRange toTimeRange(HBaseProtos.TimeRange timeRange) {
        if (timeRange == null) {
            return TimeRange.allTime();
        }
        if (timeRange.hasFrom()) {
            if (timeRange.hasTo()) {
                return TimeRange.between(timeRange.getFrom(), timeRange.getTo());
            }
            return TimeRange.from(timeRange.getFrom());
        }
        return TimeRange.until(timeRange.getTo());
    }

    public static ClientProtos.Condition toCondition(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, Filter filter, TimeRange timeRange) throws IOException {
        ClientProtos.Condition.Builder builder = ClientProtos.Condition.newBuilder().setRow(ByteStringer.wrap(row));
        if (filter != null) {
            builder.setFilter(ProtobufUtil.toFilter(filter));
        } else {
            builder.setFamily(ByteStringer.wrap(family)).setQualifier(ByteStringer.wrap(qualifier == null ? HConstants.EMPTY_BYTE_ARRAY : qualifier)).setComparator(ProtobufUtil.toComparator(new BinaryComparator(value))).setCompareType(HBaseProtos.CompareType.valueOf(op.name()));
        }
        return builder.setTimeRange(ProtobufUtil.toTimeRange(timeRange)).build();
    }

    public static ClientProtos.Condition toCondition(byte[] row, Filter filter, TimeRange timeRange) throws IOException {
        return ProtobufUtil.toCondition(row, null, null, null, null, filter, timeRange);
    }

    public static ClientProtos.Condition toCondition(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, TimeRange timeRange) throws IOException {
        return ProtobufUtil.toCondition(row, family, qualifier, op, value, null, timeRange);
    }

    static {
        ClientProtos.Result.Builder builder = ClientProtos.Result.newBuilder();
        builder.setExists(true);
        builder.setAssociatedCellCount(0);
        EMPTY_RESULT_PB_EXISTS_TRUE = builder.build();
        builder.setStale(true);
        EMPTY_RESULT_PB_EXISTS_TRUE_STALE = builder.build();
        builder.clear();
        builder.setExists(false);
        builder.setAssociatedCellCount(0);
        EMPTY_RESULT_PB_EXISTS_FALSE = builder.build();
        builder.setStale(true);
        EMPTY_RESULT_PB_EXISTS_FALSE_STALE = builder.build();
        builder.clear();
        builder.setAssociatedCellCount(0);
        EMPTY_RESULT_PB = builder.build();
        builder.setStale(true);
        EMPTY_RESULT_PB_STALE = builder.build();
        GET_SERVER_INFO_REQUEST = AdminProtos.GetServerInfoRequest.newBuilder().build();
    }

    @FunctionalInterface
    private static interface ConsumerWithException<T, U> {
        public void accept(T var1, U var2) throws IOException;
    }

    private static final class ClassLoaderHolder {
        private static final ClassLoader CLASS_LOADER;

        private ClassLoaderHolder() {
        }

        static {
            ClassLoader parent = ProtobufUtil.class.getClassLoader();
            Configuration conf = HBaseConfiguration.create();
            CLASS_LOADER = AccessController.doPrivileged(() -> new DynamicClassLoader(conf, parent));
        }
    }
}

