/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.security.token;

import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.web.WebHdfsConstants;
import org.apache.hadoop.security.token.Token;
import org.apache.hudi.org.apache.hadoop.hbase.security.UserProvider;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FsDelegationToken {
    private static final Logger LOG = LoggerFactory.getLogger(FsDelegationToken.class);
    private final UserProvider userProvider;
    private final String renewer;
    private boolean hasForwardedToken = false;
    private Token<?> userToken = null;
    private FileSystem fs = null;

    public FsDelegationToken(UserProvider userProvider, String renewer) {
        this.userProvider = userProvider;
        this.renewer = renewer;
    }

    public void acquireDelegationToken(FileSystem fs) throws IOException {
        String tokenKind;
        String scheme2 = fs.getUri().getScheme();
        if ("swebhdfs".equalsIgnoreCase(scheme2)) {
            tokenKind = WebHdfsConstants.SWEBHDFS_TOKEN_KIND.toString();
        } else if ("webhdfs".equalsIgnoreCase(scheme2)) {
            tokenKind = WebHdfsConstants.WEBHDFS_TOKEN_KIND.toString();
        } else if ("hdfs".equalsIgnoreCase(scheme2)) {
            tokenKind = DelegationTokenIdentifier.HDFS_DELEGATION_KIND.toString();
        } else {
            LOG.warn("Unknown FS URI scheme: " + scheme2);
            tokenKind = DelegationTokenIdentifier.HDFS_DELEGATION_KIND.toString();
        }
        this.acquireDelegationToken(tokenKind, fs);
    }

    public void acquireDelegationToken(String tokenKind, FileSystem fs) throws IOException {
        Objects.requireNonNull(tokenKind, "tokenKind:null");
        if (this.userProvider.isHadoopSecurityEnabled()) {
            this.fs = fs;
            this.userToken = this.userProvider.getCurrent().getToken(tokenKind, fs.getCanonicalServiceName());
            if (this.userToken == null) {
                this.hasForwardedToken = false;
                try {
                    this.userToken = fs.getDelegationToken(this.renewer);
                }
                catch (NullPointerException npe) {
                    LOG.error("Failed to get token for " + this.renewer);
                }
            } else {
                this.hasForwardedToken = true;
                LOG.info("Use the existing token: " + this.userToken);
            }
        }
    }

    public void releaseDelegationToken() {
        if (this.userProvider.isHadoopSecurityEnabled()) {
            if (this.userToken != null && !this.hasForwardedToken) {
                try {
                    this.userToken.cancel(this.fs.getConf());
                }
                catch (Exception e) {
                    LOG.warn("Failed to cancel HDFS delegation token: " + this.userToken, (Throwable)e);
                }
            }
            this.userToken = null;
            this.fs = null;
        }
    }

    public UserProvider getUserProvider() {
        return this.userProvider;
    }

    public String getRenewer() {
        return this.renewer;
    }

    public Token<?> getUserToken() {
        return this.userToken;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }
}

