/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.format;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.PrimitiveIterator;
import java.util.function.Function;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.RowKind;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.table.log.HoodieUnMergedLogRecordScanner;
import org.apache.hudi.common.util.DefaultSizeEstimator;
import org.apache.hudi.common.util.Functions;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.queue.BoundedInMemoryExecutor;
import org.apache.hudi.common.util.queue.BoundedInMemoryQueueProducer;
import org.apache.hudi.common.util.queue.FunctionBasedQueueProducer;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.org.apache.avro.generic.GenericRecordBuilder;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.table.format.mor.MergeOnReadInputSplit;
import org.apache.hudi.util.FlinkWriteClients;
import org.apache.hudi.util.StreamerUtil;

public class FormatUtils {
    private FormatUtils() {
    }

    public static void setRowKind(RowData rowData, IndexedRecord record, int index) {
        if (index == -1) {
            return;
        }
        rowData.setRowKind(FormatUtils.getRowKind(record, index));
    }

    private static RowKind getRowKind(IndexedRecord record, int index) {
        Object val = record.get(index);
        if (val == null) {
            return RowKind.INSERT;
        }
        HoodieOperation operation = HoodieOperation.fromName(val.toString());
        if (HoodieOperation.isInsert(operation)) {
            return RowKind.INSERT;
        }
        if (HoodieOperation.isUpdateBefore(operation)) {
            return RowKind.UPDATE_BEFORE;
        }
        if (HoodieOperation.isUpdateAfter(operation)) {
            return RowKind.UPDATE_AFTER;
        }
        if (HoodieOperation.isDelete(operation)) {
            return RowKind.DELETE;
        }
        throw new AssertionError();
    }

    public static RowKind getRowKindSafely(IndexedRecord record, int index) {
        if (index == -1) {
            return RowKind.INSERT;
        }
        return FormatUtils.getRowKind(record, index);
    }

    public static GenericRecord buildAvroRecordBySchema(IndexedRecord record, Schema requiredSchema, int[] requiredPos, GenericRecordBuilder recordBuilder) {
        List<Schema.Field> requiredFields = requiredSchema.getFields();
        assert (requiredFields.size() == requiredPos.length);
        PrimitiveIterator.OfInt positionIterator = Arrays.stream(requiredPos).iterator();
        requiredFields.forEach(f -> recordBuilder.set((Schema.Field)f, FormatUtils.getVal(record, (Integer)positionIterator.next())));
        return recordBuilder.build();
    }

    private static Object getVal(IndexedRecord record, int pos) {
        return pos == -1 ? null : record.get(pos);
    }

    public static HoodieMergedLogRecordScanner logScanner(MergeOnReadInputSplit split, Schema logSchema, Configuration flinkConf, org.apache.hadoop.conf.Configuration hadoopConf) {
        HoodieWriteConfig writeConfig = FlinkWriteClients.getHoodieClientConfig(flinkConf);
        FileSystem fs = FSUtils.getFs(split.getTablePath(), hadoopConf);
        return ((HoodieMergedLogRecordScanner.Builder)((HoodieMergedLogRecordScanner.Builder)HoodieMergedLogRecordScanner.newBuilder().withFileSystem(fs).withBasePath(split.getTablePath()).withLogFilePaths((List)split.getLogPaths().get())).withReaderSchema(logSchema).withLatestInstantTime(split.getLatestCommit()).withReadBlocksLazily(writeConfig.getCompactionLazyBlockReadEnabled()).withReverseReader(false).withBufferSize(writeConfig.getMaxDFSStreamBufferSize()).withMaxMemorySizeInBytes(split.getMaxCompactionMemoryInBytes()).withDiskMapType(writeConfig.getCommonConfig().getSpillableDiskMapType()).withBitCaskDiskMapCompressionEnabled(writeConfig.getCommonConfig().isBitCaskDiskMapCompressionEnabled()).withSpillableMapBasePath(writeConfig.getSpillableMapBasePath()).withInstantRange((Option)split.getInstantRange())).withOperationField(flinkConf.getBoolean(FlinkOptions.CHANGELOG_ENABLED)).build();
    }

    private static HoodieUnMergedLogRecordScanner unMergedLogScanner(MergeOnReadInputSplit split, Schema logSchema, Configuration flinkConf, org.apache.hadoop.conf.Configuration hadoopConf, HoodieUnMergedLogRecordScanner.LogRecordScannerCallback callback) {
        FileSystem fs = FSUtils.getFs(split.getTablePath(), hadoopConf);
        return ((HoodieUnMergedLogRecordScanner.Builder)((HoodieUnMergedLogRecordScanner.Builder)HoodieUnMergedLogRecordScanner.newBuilder().withFileSystem(fs).withBasePath(split.getTablePath()).withLogFilePaths((List)split.getLogPaths().get())).withReaderSchema(logSchema).withLatestInstantTime(split.getLatestCommit()).withReadBlocksLazily(FormatUtils.string2Boolean(flinkConf.getString("compaction.lazy.block.read.enabled", "true"))).withReverseReader(false).withBufferSize(flinkConf.getInteger("hoodie.memory.dfs.buffer.max.size", 0x100000)).withInstantRange((Option)split.getInstantRange())).withLogRecordScannerCallback(callback).build();
    }

    public static HoodieMergedLogRecordScanner logScanner(List<String> logPaths, Schema logSchema, String latestInstantTime, HoodieWriteConfig writeConfig, org.apache.hadoop.conf.Configuration hadoopConf) {
        String basePath = writeConfig.getBasePath();
        return ((HoodieMergedLogRecordScanner.Builder)HoodieMergedLogRecordScanner.newBuilder().withFileSystem(FSUtils.getFs(basePath, hadoopConf)).withBasePath(basePath).withLogFilePaths((List)logPaths)).withReaderSchema(logSchema).withLatestInstantTime(latestInstantTime).withReadBlocksLazily(writeConfig.getCompactionLazyBlockReadEnabled()).withReverseReader(false).withBufferSize(writeConfig.getMaxDFSStreamBufferSize()).withMaxMemorySizeInBytes(writeConfig.getMaxMemoryPerPartitionMerge()).withSpillableMapBasePath(writeConfig.getSpillableMapBasePath()).withDiskMapType(writeConfig.getCommonConfig().getSpillableDiskMapType()).withBitCaskDiskMapCompressionEnabled(writeConfig.getCommonConfig().isBitCaskDiskMapCompressionEnabled()).build();
    }

    private static Boolean string2Boolean(String s) {
        return "true".equals(s.toLowerCase(Locale.ROOT));
    }

    public static class BoundedMemoryRecords {
        private final HoodieUnMergedLogRecordScanner scanner;
        private final BoundedInMemoryExecutor<HoodieRecord<?>, HoodieRecord<?>, ?> executor;
        private final Iterator<HoodieRecord<?>> iterator;

        public BoundedMemoryRecords(MergeOnReadInputSplit split, Schema logSchema, org.apache.hadoop.conf.Configuration hadoopConf, Configuration flinkConf) {
            this.executor = new BoundedInMemoryExecutor(StreamerUtil.getMaxCompactionMemoryInBytes(flinkConf), this.getParallelProducers(), Option.empty(), Function.identity(), new DefaultSizeEstimator(), Functions.noop());
            this.iterator = this.executor.getQueue().iterator();
            this.scanner = FormatUtils.unMergedLogScanner(split, logSchema, flinkConf, hadoopConf, record -> this.executor.getQueue().insertRecord(record));
            this.executor.startProducers();
        }

        public Iterator<HoodieRecord<?>> getRecordsIterator() {
            return this.iterator;
        }

        private List<BoundedInMemoryQueueProducer<HoodieRecord<?>>> getParallelProducers() {
            ArrayList producers = new ArrayList();
            producers.add(new FunctionBasedQueueProducer(buffer -> {
                this.scanner.scan();
                return null;
            }));
            return producers;
        }

        public void close() {
            this.executor.shutdownNow();
        }
    }
}

