/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.format.cow.vector.reader;

import java.io.IOException;
import org.apache.flink.formats.parquet.vector.reader.ColumnReader;
import org.apache.flink.table.data.vector.ColumnVector;
import org.apache.flink.table.data.vector.writable.WritableColumnVector;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.hudi.table.format.cow.vector.HeapArrayVector;
import org.apache.hudi.table.format.cow.vector.HeapMapColumnVector;
import org.apache.hudi.table.format.cow.vector.reader.ArrayColumnReader;

public class MapColumnReader
implements ColumnReader<WritableColumnVector> {
    private final LogicalType logicalType;
    private final ArrayColumnReader keyReader;
    private final ArrayColumnReader valueReader;

    public MapColumnReader(ArrayColumnReader keyReader, ArrayColumnReader valueReader, LogicalType logicalType) {
        this.keyReader = keyReader;
        this.valueReader = valueReader;
        this.logicalType = logicalType;
    }

    public void readBatch(int total, ColumnVector column) throws IOException {
        HeapMapColumnVector mapColumnVector = (HeapMapColumnVector)column;
        MapType mapType = (MapType)this.logicalType;
        HeapArrayVector keyArrayColumnVector = new HeapArrayVector(total);
        HeapArrayVector valueArrayColumnVector = new HeapArrayVector(total);
        this.keyReader.readToVector(total, keyArrayColumnVector);
        this.valueReader.readToVector(total, valueArrayColumnVector);
        mapColumnVector.setKeys(keyArrayColumnVector.child);
        mapColumnVector.setValues(valueArrayColumnVector.child);
        mapColumnVector.setOffsets(keyArrayColumnVector.offsets);
        mapColumnVector.setLengths(keyArrayColumnVector.lengths);
        mapColumnVector.setSize(keyArrayColumnVector.getSize());
        for (int i = 0; i < keyArrayColumnVector.getLen(); ++i) {
            if (!keyArrayColumnVector.isNullAt(i)) continue;
            mapColumnVector.setNullAt(i);
        }
    }

    @Override
    public void readToVector(int readNumber, WritableColumnVector vector) throws IOException {
        this.readBatch(readNumber, (ColumnVector)vector);
    }
}

