/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.common.util.ValidationUtils;

public class RowDataProjection
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final RowData.FieldGetter[] fieldGetters;

    private RowDataProjection(LogicalType[] types, int[] positions) {
        ValidationUtils.checkArgument(types.length == positions.length, "types and positions should have the equal number");
        this.fieldGetters = new RowData.FieldGetter[types.length];
        for (int i = 0; i < types.length; ++i) {
            LogicalType type = types[i];
            int pos = positions[i];
            this.fieldGetters[i] = RowData.createFieldGetter((LogicalType)type, (int)pos);
        }
    }

    public static RowDataProjection instance(RowType rowType, int[] positions) {
        LogicalType[] types = rowType.getChildren().toArray(new LogicalType[0]);
        return new RowDataProjection(types, positions);
    }

    public static RowDataProjection instanceV2(RowType rowType, int[] positions) {
        List fieldTypes = rowType.getChildren();
        LogicalType[] types = (LogicalType[])Arrays.stream(positions).mapToObj(fieldTypes::get).toArray(LogicalType[]::new);
        return new RowDataProjection(types, positions);
    }

    public static RowDataProjection instance(LogicalType[] types, int[] positions) {
        return new RowDataProjection(types, positions);
    }

    public RowData project(RowData rowData) {
        GenericRowData genericRowData = new GenericRowData(this.fieldGetters.length);
        for (int i = 0; i < this.fieldGetters.length; ++i) {
            Object val = this.fieldGetters[i].getFieldOrNull(rowData);
            genericRowData.setField(i, val);
        }
        return genericRowData;
    }

    public Object[] projectAsValues(RowData rowData) {
        Object[] values2 = new Object[this.fieldGetters.length];
        for (int i = 0; i < this.fieldGetters.length; ++i) {
            Object val;
            values2[i] = val = this.fieldGetters[i].getFieldOrNull(rowData);
        }
        return values2;
    }
}

