/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.util.collection.Pair;

public class HoodieInternalWriteStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final long RANDOM_SEED = 9038412832L;
    private String fileId;
    private String partitionPath;
    private List<String> successRecordKeys = new ArrayList<String>();
    private List<Pair<String, Throwable>> failedRecordKeys = new ArrayList<Pair<String, Throwable>>();
    private HoodieWriteStat stat;
    private long totalRecords = 0L;
    private long totalErrorRecords = 0L;
    private Throwable globalError = null;
    private final double failureFraction;
    private final boolean trackSuccessRecords;
    private final transient Random random;

    public HoodieInternalWriteStatus(Boolean trackSuccessRecords, Double failureFraction) {
        this.trackSuccessRecords = trackSuccessRecords;
        this.failureFraction = failureFraction;
        this.random = new Random(9038412832L);
    }

    public boolean isTrackingSuccessfulWrites() {
        return this.trackSuccessRecords;
    }

    public void markSuccess(String recordKey) {
        if (this.trackSuccessRecords) {
            this.successRecordKeys.add(recordKey);
        }
        ++this.totalRecords;
    }

    public void markSuccess() {
        ++this.totalRecords;
    }

    public void markFailure(String recordKey, Throwable t) {
        if (this.failedRecordKeys.isEmpty() || this.random.nextDouble() <= this.failureFraction) {
            this.failedRecordKeys.add(Pair.of(recordKey, t));
        }
        ++this.totalRecords;
    }

    public boolean hasErrors() {
        return this.failedRecordKeys.size() != 0;
    }

    public HoodieWriteStat getStat() {
        return this.stat;
    }

    public void setStat(HoodieWriteStat stat) {
        this.stat = stat;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public void setPartitionPath(String partitionPath) {
        this.partitionPath = partitionPath;
    }

    public List<String> getSuccessRecordKeys() {
        return this.successRecordKeys;
    }

    public long getFailedRowsSize() {
        return this.failedRecordKeys.size();
    }

    public List<Pair<String, Throwable>> getFailedRecordKeys() {
        return this.failedRecordKeys;
    }

    public void setFailedRecordKeys(List<Pair<String, Throwable>> failedRecordKeys) {
        this.failedRecordKeys = failedRecordKeys;
    }

    public long getTotalRecords() {
        return this.totalRecords;
    }

    public void setTotalRecords(long totalRecords) {
        this.totalRecords = totalRecords;
    }

    public long getTotalErrorRecords() {
        return this.totalErrorRecords;
    }

    public void setTotalErrorRecords(long totalErrorRecords) {
        this.totalErrorRecords = totalErrorRecords;
    }

    public Throwable getGlobalError() {
        return this.globalError;
    }

    public void setGlobalError(Throwable globalError) {
        this.globalError = globalError;
    }

    public void setSuccessRecordKeys(List<String> successRecordKeys) {
        this.successRecordKeys = successRecordKeys;
    }

    public String toString() {
        return "PartitionPath " + this.partitionPath + ", FileID " + this.fileId + ", Success records " + this.totalRecords + ", errored Rows " + this.totalErrorRecords + ", global error " + (this.globalError != null);
    }
}

