/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.model;

import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.types.RowKind;
import org.apache.hudi.common.model.HoodieOperation;

public class HoodieRowData
implements RowData {
    private final String[] metaColumns;
    private final RowData row;
    private final int metaColumnsNum;

    public HoodieRowData(String commitTime, String commitSeqNumber, String recordKey, String partitionPath, String fileName, RowData row, boolean withOperation) {
        this.metaColumnsNum = withOperation ? 6 : 5;
        this.metaColumns = new String[this.metaColumnsNum];
        this.metaColumns[0] = commitTime;
        this.metaColumns[1] = commitSeqNumber;
        this.metaColumns[2] = recordKey;
        this.metaColumns[3] = partitionPath;
        this.metaColumns[4] = fileName;
        if (withOperation) {
            this.metaColumns[5] = HoodieOperation.fromValue(row.getRowKind().toByteValue()).getName();
        }
        this.row = row;
    }

    public int getArity() {
        return this.metaColumnsNum + this.row.getArity();
    }

    public RowKind getRowKind() {
        return this.row.getRowKind();
    }

    public void setRowKind(RowKind kind) {
        this.row.setRowKind(kind);
    }

    public boolean isNullAt(int ordinal) {
        if (ordinal < this.metaColumnsNum) {
            return null == this.getMetaColumnVal(ordinal);
        }
        return this.row.isNullAt(ordinal - this.metaColumnsNum);
    }

    public boolean getBoolean(int ordinal) {
        return this.row.getBoolean(ordinal - this.metaColumnsNum);
    }

    public byte getByte(int ordinal) {
        return this.row.getByte(ordinal - this.metaColumnsNum);
    }

    public short getShort(int ordinal) {
        return this.row.getShort(ordinal - this.metaColumnsNum);
    }

    public int getInt(int ordinal) {
        return this.row.getInt(ordinal - this.metaColumnsNum);
    }

    public long getLong(int ordinal) {
        return this.row.getLong(ordinal - this.metaColumnsNum);
    }

    public float getFloat(int ordinal) {
        return this.row.getFloat(ordinal - this.metaColumnsNum);
    }

    public double getDouble(int ordinal) {
        return this.row.getDouble(ordinal - this.metaColumnsNum);
    }

    public DecimalData getDecimal(int ordinal, int precision, int scale) {
        return this.row.getDecimal(ordinal - this.metaColumnsNum, precision, scale);
    }

    public TimestampData getTimestamp(int pos, int precision) {
        return this.row.getTimestamp(pos - this.metaColumnsNum, precision);
    }

    public <T> RawValueData<T> getRawValue(int pos) {
        return this.row.getRawValue(pos - this.metaColumnsNum);
    }

    public StringData getString(int ordinal) {
        if (ordinal < this.metaColumnsNum) {
            return StringData.fromString((String)this.getMetaColumnVal(ordinal));
        }
        return this.row.getString(ordinal - this.metaColumnsNum);
    }

    public byte[] getBinary(int ordinal) {
        return this.row.getBinary(ordinal - this.metaColumnsNum);
    }

    public RowData getRow(int ordinal, int numFields) {
        return this.row.getRow(ordinal - this.metaColumnsNum, numFields);
    }

    public ArrayData getArray(int ordinal) {
        return this.row.getArray(ordinal - this.metaColumnsNum);
    }

    public MapData getMap(int ordinal) {
        return this.row.getMap(ordinal - this.metaColumnsNum);
    }

    private String getMetaColumnVal(int ordinal) {
        return this.metaColumns[ordinal];
    }
}

