/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.dto;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.hudi.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.dto.FileSliceDTO;
import org.apache.hudi.common.table.timeline.dto.TimelineDTO;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FileGroupDTO {
    @JsonProperty(value="partition")
    String partition;
    @JsonProperty(value="fileId")
    String id;
    @JsonProperty(value="slices")
    List<FileSliceDTO> slices;
    @JsonProperty(value="timeline")
    TimelineDTO timeline;

    public static FileGroupDTO fromFileGroup(HoodieFileGroup fileGroup) {
        FileGroupDTO dto = new FileGroupDTO();
        dto.partition = fileGroup.getPartitionPath();
        dto.id = fileGroup.getFileGroupId().getFileId();
        dto.slices = fileGroup.getAllRawFileSlices().map(FileSliceDTO::fromFileSlice).collect(Collectors.toList());
        dto.timeline = TimelineDTO.fromTimeline(fileGroup.getTimeline());
        return dto;
    }

    public static HoodieFileGroup toFileGroup(FileGroupDTO dto, HoodieTableMetaClient metaClient) {
        HoodieFileGroup fileGroup = new HoodieFileGroup(dto.partition, dto.id, TimelineDTO.toTimeline(dto.timeline, metaClient));
        dto.slices.stream().map(FileSliceDTO::toFileSlice).forEach(fileSlice -> fileGroup.addFileSlice((FileSlice)fileSlice));
        return fileGroup;
    }
}

