/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config.metrics;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.metrics.HoodieMetricsCloudWatchConfig;
import org.apache.hudi.config.metrics.HoodieMetricsDatadogConfig;
import org.apache.hudi.config.metrics.HoodieMetricsGraphiteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsJmxConfig;
import org.apache.hudi.config.metrics.HoodieMetricsPrometheusConfig;
import org.apache.hudi.metrics.MetricsReporterType;

@ConfigClassProperty(name="Metrics Configurations", groupName=ConfigGroups.Names.METRICS, description="Enables reporting on Hudi metrics. Hudi publishes metrics on every commit, clean, rollback etc. The following sections list the supported reporters.")
@Immutable
public class HoodieMetricsConfig
extends HoodieConfig {
    public static final String METRIC_PREFIX = "hoodie.metrics";
    public static final ConfigProperty<Boolean> TURN_METRICS_ON = ConfigProperty.key("hoodie.metrics.on").defaultValue(false).sinceVersion("0.5.0").withDocumentation("Turn on/off metrics reporting. off by default.");
    public static final ConfigProperty<MetricsReporterType> METRICS_REPORTER_TYPE_VALUE = ConfigProperty.key("hoodie.metrics.reporter.type").defaultValue(MetricsReporterType.GRAPHITE).sinceVersion("0.5.0").withDocumentation("Type of metrics reporter.");
    public static final ConfigProperty<String> METRICS_REPORTER_CLASS_NAME = ConfigProperty.key("hoodie.metrics.reporter.class").defaultValue("").sinceVersion("0.6.0").withDocumentation("");
    public static final ConfigProperty<String> METRICS_REPORTER_PREFIX = ConfigProperty.key("hoodie.metrics.reporter.metricsname.prefix").defaultValue("").sinceVersion("0.11.0").withInferFunction(cfg -> {
        if (cfg.contains(HoodieTableConfig.NAME)) {
            return Option.of(cfg.getString(HoodieTableConfig.NAME));
        }
        return Option.empty();
    }).withDocumentation("The prefix given to the metrics names.");
    public static final ConfigProperty<String> EXECUTOR_METRICS_ENABLE = ConfigProperty.key("hoodie.metrics.executor.enable").noDefaultValue().sinceVersion("0.7.0").withDocumentation("");
    @Deprecated
    public static final String METRICS_ON = TURN_METRICS_ON.key();
    @Deprecated
    public static final boolean DEFAULT_METRICS_ON = TURN_METRICS_ON.defaultValue();
    @Deprecated
    public static final String METRICS_REPORTER_TYPE = METRICS_REPORTER_TYPE_VALUE.key();
    @Deprecated
    public static final MetricsReporterType DEFAULT_METRICS_REPORTER_TYPE = METRICS_REPORTER_TYPE_VALUE.defaultValue();
    @Deprecated
    public static final String METRICS_REPORTER_CLASS = METRICS_REPORTER_CLASS_NAME.key();
    @Deprecated
    public static final String DEFAULT_METRICS_REPORTER_CLASS = METRICS_REPORTER_CLASS_NAME.defaultValue();
    @Deprecated
    public static final String ENABLE_EXECUTOR_METRICS = EXECUTOR_METRICS_ENABLE.key();

    private HoodieMetricsConfig() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final HoodieMetricsConfig hoodieMetricsConfig = new HoodieMetricsConfig();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.hoodieMetricsConfig.getProps().load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.hoodieMetricsConfig.getProps().putAll((Map<?, ?>)props);
            return this;
        }

        public Builder on(boolean metricsOn) {
            this.hoodieMetricsConfig.setValue(TURN_METRICS_ON, String.valueOf(metricsOn));
            return this;
        }

        public Builder withReporterType(String reporterType) {
            this.hoodieMetricsConfig.setValue(METRICS_REPORTER_TYPE_VALUE, reporterType);
            return this;
        }

        public Builder withReporterClass(String className) {
            this.hoodieMetricsConfig.setValue(METRICS_REPORTER_CLASS_NAME, className);
            return this;
        }

        public Builder withExecutorMetrics(boolean enable) {
            this.hoodieMetricsConfig.setValue(EXECUTOR_METRICS_ENABLE, String.valueOf(enable));
            return this;
        }

        public HoodieMetricsConfig build() {
            this.hoodieMetricsConfig.setDefaults(HoodieMetricsConfig.class.getName());
            MetricsReporterType reporterType = MetricsReporterType.valueOf(this.hoodieMetricsConfig.getString(METRICS_REPORTER_TYPE_VALUE));
            this.hoodieMetricsConfig.setDefaultOnCondition(reporterType == MetricsReporterType.DATADOG, HoodieMetricsDatadogConfig.newBuilder().fromProperties(this.hoodieMetricsConfig.getProps()).build());
            this.hoodieMetricsConfig.setDefaultOnCondition(reporterType == MetricsReporterType.PROMETHEUS_PUSHGATEWAY, HoodieMetricsPrometheusConfig.newBuilder().fromProperties(this.hoodieMetricsConfig.getProps()).build());
            this.hoodieMetricsConfig.setDefaultOnCondition(reporterType == MetricsReporterType.PROMETHEUS, HoodieMetricsPrometheusConfig.newBuilder().fromProperties(this.hoodieMetricsConfig.getProps()).build());
            this.hoodieMetricsConfig.setDefaultOnCondition(reporterType == MetricsReporterType.JMX, HoodieMetricsJmxConfig.newBuilder().fromProperties(this.hoodieMetricsConfig.getProps()).build());
            this.hoodieMetricsConfig.setDefaultOnCondition(reporterType == MetricsReporterType.GRAPHITE, HoodieMetricsGraphiteConfig.newBuilder().fromProperties(this.hoodieMetricsConfig.getProps()).build());
            this.hoodieMetricsConfig.setDefaultOnCondition(reporterType == MetricsReporterType.CLOUDWATCH, HoodieMetricsCloudWatchConfig.newBuilder().fromProperties(this.hoodieMetricsConfig.getProps()).build());
            return this.hoodieMetricsConfig;
        }
    }
}

