/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.configuration;

import java.util.Locale;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.format.FilePathUtils;

public class OptionsResolver {
    public static boolean insertClustering(Configuration conf) {
        return OptionsResolver.isCowTable(conf) && OptionsResolver.isInsertOperation(conf) && conf.getBoolean(FlinkOptions.INSERT_CLUSTER);
    }

    public static boolean isAppendMode(Configuration conf) {
        return OptionsResolver.isCowTable(conf) && OptionsResolver.isInsertOperation(conf) && !conf.getBoolean(FlinkOptions.INSERT_CLUSTER) || OptionsResolver.needsScheduleClustering(conf);
    }

    public static boolean isInsertOperation(Configuration conf) {
        WriteOperationType operationType = WriteOperationType.fromValue(conf.getString(FlinkOptions.OPERATION));
        return operationType == WriteOperationType.INSERT;
    }

    public static boolean isMorTable(Configuration conf) {
        return conf.getString(FlinkOptions.TABLE_TYPE).toUpperCase(Locale.ROOT).equals(FlinkOptions.TABLE_TYPE_MERGE_ON_READ);
    }

    public static boolean isMorTable(Map<String, String> options) {
        return options.getOrDefault(FlinkOptions.TABLE_TYPE.key(), (String)FlinkOptions.TABLE_TYPE.defaultValue()).equalsIgnoreCase(FlinkOptions.TABLE_TYPE_MERGE_ON_READ);
    }

    public static boolean isCowTable(Configuration conf) {
        return conf.getString(FlinkOptions.TABLE_TYPE).toUpperCase(Locale.ROOT).equals(FlinkOptions.TABLE_TYPE_COPY_ON_WRITE);
    }

    public static boolean isDefaultHoodieRecordPayloadClazz(Configuration conf) {
        return conf.getString(FlinkOptions.PAYLOAD_CLASS_NAME).contains(DefaultHoodieRecordPayload.class.getSimpleName());
    }

    public static String getPreCombineField(Configuration conf) {
        String preCombineField = conf.getString(FlinkOptions.PRECOMBINE_FIELD);
        return preCombineField.equals("no_precombine") ? null : preCombineField;
    }

    public static boolean isDeltaTimeCompaction(Configuration conf) {
        String strategy = conf.getString(FlinkOptions.COMPACTION_TRIGGER_STRATEGY).toLowerCase(Locale.ROOT);
        return "time_elapsed".equals(strategy) || "num_or_time".equals(strategy);
    }

    public static boolean isPartitionedTable(Configuration conf) {
        return FilePathUtils.extractPartitionKeys(conf).length > 0;
    }

    public static boolean isBucketIndexType(Configuration conf) {
        return conf.getString(FlinkOptions.INDEX_TYPE).equals(HoodieIndex.IndexType.BUCKET.name());
    }

    public static boolean emitChangelog(Configuration conf) {
        return conf.getBoolean(FlinkOptions.READ_AS_STREAMING) && conf.getBoolean(FlinkOptions.CHANGELOG_ENABLED);
    }

    public static boolean needsAsyncCompaction(Configuration conf) {
        return OptionsResolver.isMorTable(conf) && conf.getBoolean(FlinkOptions.COMPACTION_ASYNC_ENABLED);
    }

    public static boolean needsScheduleCompaction(Configuration conf) {
        return OptionsResolver.isMorTable(conf) && conf.getBoolean(FlinkOptions.COMPACTION_SCHEDULE_ENABLED);
    }

    public static boolean needsAsyncClustering(Configuration conf) {
        return OptionsResolver.isInsertOperation(conf) && conf.getBoolean(FlinkOptions.CLUSTERING_ASYNC_ENABLED);
    }

    public static boolean needsScheduleClustering(Configuration conf) {
        return OptionsResolver.isInsertOperation(conf) && conf.getBoolean(FlinkOptions.CLUSTERING_SCHEDULE_ENABLED);
    }

    public static boolean sortClusteringEnabled(Configuration conf) {
        return !StringUtils.isNullOrEmpty(conf.getString(FlinkOptions.CLUSTERING_SORT_COLUMNS));
    }

    public static boolean isInsertOverwrite(Configuration conf) {
        return conf.getString(FlinkOptions.OPERATION).equals(WriteOperationType.INSERT_OVERWRITE_TABLE.value()) || conf.getString(FlinkOptions.OPERATION).equals(WriteOperationType.INSERT_OVERWRITE.value());
    }

    public static boolean isSpecificStartCommit(Configuration conf) {
        return conf.getOptional(FlinkOptions.READ_START_COMMIT).isPresent() && !((String)conf.get(FlinkOptions.READ_START_COMMIT)).equalsIgnoreCase("earliest");
    }
}

