/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.hive.HoodieHiveSyncException;
import org.apache.hudi.hive.ddl.DDLExecutor;
import org.apache.hudi.hive.ddl.HMSDDLExecutor;
import org.apache.hudi.hive.ddl.HiveQueryDDLExecutor;
import org.apache.hudi.hive.ddl.HiveSyncMode;
import org.apache.hudi.hive.ddl.JDBCExecutor;
import org.apache.hudi.sync.common.HoodieSyncClient;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.model.FieldSchema;
import org.apache.hudi.sync.common.model.Partition;
import org.apache.hudi.sync.common.util.TableUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.parquet.schema.MessageType;
import org.apache.thrift.TException;

public class HoodieHiveSyncClient
extends HoodieSyncClient {
    private static final Logger LOG = LogManager.getLogger(HoodieHiveSyncClient.class);
    protected final HiveSyncConfig config;
    private final String databaseName;
    DDLExecutor ddlExecutor;
    private IMetaStoreClient client;

    public HoodieHiveSyncClient(HiveSyncConfig config) {
        super(config);
        this.config = config;
        this.databaseName = config.getStringOrDefault(HoodieSyncConfig.META_SYNC_DATABASE_NAME);
        try {
            if (!StringUtils.isNullOrEmpty(config.getString(HiveSyncConfigHolder.HIVE_SYNC_MODE))) {
                HiveSyncMode syncMode = HiveSyncMode.of(config.getString(HiveSyncConfigHolder.HIVE_SYNC_MODE));
                switch (syncMode) {
                    case HMS: {
                        this.ddlExecutor = new HMSDDLExecutor(config);
                        break;
                    }
                    case HIVEQL: {
                        this.ddlExecutor = new HiveQueryDDLExecutor(config);
                        break;
                    }
                    case JDBC: {
                        this.ddlExecutor = new JDBCExecutor(config);
                        break;
                    }
                    default: {
                        throw new HoodieHiveSyncException("Invalid sync mode given " + config.getString(HiveSyncConfigHolder.HIVE_SYNC_MODE));
                    }
                }
            } else {
                this.ddlExecutor = config.getBoolean(HiveSyncConfigHolder.HIVE_USE_JDBC) != false ? new JDBCExecutor(config) : new HiveQueryDDLExecutor(config);
            }
            this.client = Hive.get((HiveConf)config.getHiveConf()).getMSC();
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to create HiveMetaStoreClient", e);
        }
    }

    @Override
    public void addPartitionsToTable(String tableName, List<String> partitionsToAdd) {
        this.ddlExecutor.addPartitionsToTable(tableName, partitionsToAdd);
    }

    @Override
    public void updatePartitionsToTable(String tableName, List<String> changedPartitions) {
        this.ddlExecutor.updatePartitionsToTable(tableName, changedPartitions);
    }

    @Override
    public void dropPartitions(String tableName, List<String> partitionsToDrop) {
        this.ddlExecutor.dropPartitionsToTable(tableName, partitionsToDrop);
    }

    @Override
    public void updateTableProperties(String tableName, Map<String, String> tableProperties) {
        if (tableProperties == null || tableProperties.isEmpty()) {
            return;
        }
        try {
            Table table = this.client.getTable(this.databaseName, tableName);
            for (Map.Entry<String, String> entry : tableProperties.entrySet()) {
                table.putToParameters(entry.getKey(), entry.getValue());
            }
            this.client.alter_table(this.databaseName, tableName, table);
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to update table properties for table: " + tableName, e);
        }
    }

    @Override
    public void updateTableSchema(String tableName, MessageType newSchema) {
        this.ddlExecutor.updateTableDefinition(tableName, newSchema);
    }

    @Override
    public List<Partition> getAllPartitions(String tableName) {
        try {
            return this.client.listPartitions(this.databaseName, tableName, (short)-1).stream().map(p -> new Partition(p.getValues(), p.getSd().getLocation())).collect(Collectors.toList());
        }
        catch (TException e) {
            throw new HoodieHiveSyncException("Failed to get all partitions for table " + TableUtils.tableId(this.databaseName, tableName), e);
        }
    }

    @Override
    public void createTable(String tableName, MessageType storageSchema, String inputFormatClass, String outputFormatClass, String serdeClass, Map<String, String> serdeProperties, Map<String, String> tableProperties) {
        this.ddlExecutor.createTable(tableName, storageSchema, inputFormatClass, outputFormatClass, serdeClass, serdeProperties, tableProperties);
    }

    @Override
    public Map<String, String> getMetastoreSchema(String tableName) {
        if (!this.tableExists(tableName)) {
            throw new IllegalArgumentException("Failed to get schema for table " + tableName + " does not exist");
        }
        return this.ddlExecutor.getTableSchema(tableName);
    }

    @Override
    public boolean tableExists(String tableName) {
        try {
            return this.client.tableExists(this.databaseName, tableName);
        }
        catch (TException e) {
            throw new HoodieHiveSyncException("Failed to check if table exists " + tableName, e);
        }
    }

    @Override
    public boolean databaseExists(String databaseName) {
        try {
            this.client.getDatabase(databaseName);
            return true;
        }
        catch (NoSuchObjectException noSuchObjectException) {
            return false;
        }
        catch (TException e) {
            throw new HoodieHiveSyncException("Failed to check if database exists " + databaseName, e);
        }
    }

    @Override
    public void createDatabase(String databaseName) {
        this.ddlExecutor.createDatabase(databaseName);
    }

    @Override
    public Option<String> getLastCommitTimeSynced(String tableName) {
        try {
            Table table = this.client.getTable(this.databaseName, tableName);
            return Option.ofNullable(table.getParameters().getOrDefault("last_commit_time_sync", null));
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to get the last commit time synced from the table " + tableName, e);
        }
    }

    @Override
    public Option<String> getLastReplicatedTime(String tableName) {
        try {
            Table table = this.client.getTable(this.databaseName, tableName);
            return Option.ofNullable(table.getParameters().getOrDefault("last_replication_timestamp", null));
        }
        catch (NoSuchObjectException e) {
            LOG.warn((Object)("the said table not found in hms " + TableUtils.tableId(this.databaseName, tableName)));
            return Option.empty();
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to get the last replicated time from the table " + tableName, e);
        }
    }

    @Override
    public void updateLastReplicatedTimeStamp(String tableName, String timeStamp) {
        if (this.getActiveTimeline().getInstants().noneMatch(i -> i.getTimestamp().equals(timeStamp))) {
            throw new HoodieHiveSyncException("Not a valid completed timestamp " + timeStamp + " for table " + tableName);
        }
        try {
            Table table = this.client.getTable(this.databaseName, tableName);
            table.putToParameters("last_replication_timestamp", timeStamp);
            this.client.alter_table(this.databaseName, tableName, table);
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to update last replicated time to " + timeStamp + " for " + tableName, e);
        }
    }

    @Override
    public void deleteLastReplicatedTimeStamp(String tableName) {
        try {
            Table table = this.client.getTable(this.databaseName, tableName);
            String timestamp = (String)table.getParameters().remove("last_replication_timestamp");
            this.client.alter_table(this.databaseName, tableName, table);
            if (timestamp != null) {
                LOG.info((Object)("deleted last replicated timestamp " + timestamp + " for table " + tableName));
            }
        }
        catch (NoSuchObjectException table) {
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to delete last replicated timestamp for " + tableName, e);
        }
    }

    @Override
    public void close() {
        try {
            this.ddlExecutor.close();
            if (this.client != null) {
                Hive.closeCurrent();
                this.client = null;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Could not close connection ", (Throwable)e);
        }
    }

    @Override
    public void updateLastCommitTimeSynced(String tableName) {
        Option<String> lastCommitSynced = this.getActiveTimeline().lastInstant().map(HoodieInstant::getTimestamp);
        if (lastCommitSynced.isPresent()) {
            try {
                Table table = this.client.getTable(this.databaseName, tableName);
                table.putToParameters("last_commit_time_sync", lastCommitSynced.get());
                this.client.alter_table(this.databaseName, tableName, table);
            }
            catch (Exception e) {
                throw new HoodieHiveSyncException("Failed to get update last commit time synced to " + lastCommitSynced, e);
            }
        }
    }

    @Override
    public List<FieldSchema> getMetastoreFieldSchemas(String tableName) {
        try {
            return this.client.getSchema(this.databaseName, tableName).stream().map(f -> new FieldSchema(f.getName(), f.getType(), f.getComment())).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to get field schemas from metastore for table : " + tableName, e);
        }
    }

    @Override
    public List<FieldSchema> getStorageFieldSchemas() {
        try {
            return new TableSchemaResolver(this.metaClient).getTableAvroSchema(false).getFields().stream().map(f -> new FieldSchema(f.name(), f.schema().getType().getName(), f.doc())).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to get field schemas from storage : ", e);
        }
    }

    @Override
    public void updateTableComments(String tableName, List<FieldSchema> fromMetastore, List<FieldSchema> fromStorage) {
        Map<String, FieldSchema> metastoreMap = fromMetastore.stream().collect(Collectors.toMap(f -> f.getName().toLowerCase(Locale.ROOT), f -> f));
        Map<String, FieldSchema> storageMap = fromStorage.stream().collect(Collectors.toMap(f -> f.getName().toLowerCase(Locale.ROOT), f -> f));
        HashMap<String, Pair<String, String>> alterComments = new HashMap<String, Pair<String, String>>();
        metastoreMap.forEach((name, metastoreFieldSchema) -> {
            boolean updated;
            if (storageMap.containsKey(name) && (updated = metastoreFieldSchema.updateComment((FieldSchema)storageMap.get(name)))) {
                alterComments.put((String)name, Pair.of(metastoreFieldSchema.getType(), metastoreFieldSchema.getCommentOrEmpty()));
            }
        });
        if (alterComments.isEmpty()) {
            LOG.info((Object)String.format("No comment difference of %s ", tableName));
        } else {
            this.ddlExecutor.updateTableComments(tableName, alterComments);
        }
    }
}

