/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.ddl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.StorageSchemes;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.hive.HoodieHiveSyncException;
import org.apache.hudi.hive.ddl.DDLExecutor;
import org.apache.hudi.hive.util.HivePartitionUtil;
import org.apache.hudi.hive.util.HiveSchemaUtil;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.model.PartitionValueExtractor;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.parquet.schema.MessageType;
import org.apache.thrift.TException;

public class HMSDDLExecutor
implements DDLExecutor {
    private static final Logger LOG = LogManager.getLogger(HMSDDLExecutor.class);
    private final HiveSyncConfig syncConfig;
    private final String databaseName;
    private final IMetaStoreClient client;
    private final PartitionValueExtractor partitionValueExtractor;

    public HMSDDLExecutor(HiveSyncConfig syncConfig) throws HiveException, MetaException {
        this.syncConfig = syncConfig;
        this.databaseName = syncConfig.getStringOrDefault(HoodieSyncConfig.META_SYNC_DATABASE_NAME);
        this.client = Hive.get((HiveConf)syncConfig.getHiveConf()).getMSC();
        try {
            this.partitionValueExtractor = (PartitionValueExtractor)Class.forName(syncConfig.getStringOrDefault(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS)).newInstance();
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to initialize PartitionValueExtractor class " + syncConfig.getStringOrDefault(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS), e);
        }
    }

    @Override
    public void createDatabase(String databaseName) {
        try {
            Database database = new Database(databaseName, "automatically created by hoodie", null, null);
            this.client.createDatabase(database);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to create database " + databaseName), (Throwable)e);
            throw new HoodieHiveSyncException("Failed to create database " + databaseName, e);
        }
    }

    @Override
    public void createTable(String tableName, MessageType storageSchema, String inputFormatClass, String outputFormatClass, String serdeClass, Map<String, String> serdeProperties, Map<String, String> tableProperties) {
        try {
            LinkedHashMap<String, String> mapSchema = HiveSchemaUtil.parquetSchemaToMapSchema(storageSchema, this.syncConfig.getBoolean(HiveSyncConfigHolder.HIVE_SUPPORT_TIMESTAMP_TYPE), false);
            List<FieldSchema> fieldSchema = HiveSchemaUtil.convertMapSchemaToHiveFieldSchema(mapSchema, this.syncConfig);
            List partitionSchema = this.syncConfig.getSplitStrings(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS).stream().map(partitionKey -> {
                String partitionKeyType = HiveSchemaUtil.getPartitionKeyType(mapSchema, partitionKey);
                return new FieldSchema(partitionKey, partitionKeyType.toLowerCase(), "");
            }).collect(Collectors.toList());
            Table newTb = new Table();
            newTb.setDbName(this.databaseName);
            newTb.setTableName(tableName);
            newTb.setOwner(UserGroupInformation.getCurrentUser().getShortUserName());
            newTb.setCreateTime((int)System.currentTimeMillis());
            StorageDescriptor storageDescriptor = new StorageDescriptor();
            storageDescriptor.setCols(fieldSchema);
            storageDescriptor.setInputFormat(inputFormatClass);
            storageDescriptor.setOutputFormat(outputFormatClass);
            storageDescriptor.setLocation(this.syncConfig.getString(HoodieSyncConfig.META_SYNC_BASE_PATH));
            serdeProperties.put("serialization.format", "1");
            storageDescriptor.setSerdeInfo(new SerDeInfo(null, serdeClass, serdeProperties));
            newTb.setSd(storageDescriptor);
            newTb.setPartitionKeys(partitionSchema);
            if (!this.syncConfig.getBoolean(HiveSyncConfigHolder.HIVE_CREATE_MANAGED_TABLE).booleanValue()) {
                newTb.putToParameters("EXTERNAL", "TRUE");
            }
            for (Map.Entry<String, String> entry : tableProperties.entrySet()) {
                newTb.putToParameters(entry.getKey(), entry.getValue());
            }
            newTb.setTableType(TableType.EXTERNAL_TABLE.toString());
            this.client.createTable(newTb);
        }
        catch (Exception e) {
            LOG.error((Object)("failed to create table " + tableName), (Throwable)e);
            throw new HoodieHiveSyncException("failed to create table " + tableName, e);
        }
    }

    @Override
    public void updateTableDefinition(String tableName, MessageType newSchema) {
        try {
            boolean cascade = this.syncConfig.getSplitStrings(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS).size() > 0;
            List<FieldSchema> fieldSchema = HiveSchemaUtil.convertParquetSchemaToHiveFieldSchema(newSchema, this.syncConfig);
            Table table = this.client.getTable(this.databaseName, tableName);
            StorageDescriptor sd = table.getSd();
            sd.setCols(fieldSchema);
            table.setSd(sd);
            EnvironmentContext environmentContext = new EnvironmentContext();
            if (cascade) {
                LOG.info((Object)"partition table,need cascade");
                environmentContext.putToProperties("CASCADE", "true");
            }
            this.client.alter_table_with_environmentContext(this.databaseName, tableName, table, environmentContext);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to update table for " + tableName), (Throwable)e);
            throw new HoodieHiveSyncException("Failed to update table for " + tableName, e);
        }
    }

    @Override
    public Map<String, String> getTableSchema(String tableName) {
        try {
            long start = System.currentTimeMillis();
            Table table = this.client.getTable(this.databaseName, tableName);
            Map<String, String> partitionKeysMap = table.getPartitionKeys().stream().collect(Collectors.toMap(FieldSchema::getName, f -> f.getType().toUpperCase()));
            Map<String, String> columnsMap = table.getSd().getCols().stream().collect(Collectors.toMap(FieldSchema::getName, f -> f.getType().toUpperCase()));
            HashMap<String, String> schema = new HashMap<String, String>();
            schema.putAll(columnsMap);
            schema.putAll(partitionKeysMap);
            long end = System.currentTimeMillis();
            LOG.info((Object)String.format("Time taken to getTableSchema: %s ms", end - start));
            return schema;
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to get table schema for : " + tableName, e);
        }
    }

    @Override
    public void addPartitionsToTable(String tableName, List<String> partitionsToAdd) {
        if (partitionsToAdd.isEmpty()) {
            LOG.info((Object)("No partitions to add for " + tableName));
            return;
        }
        LOG.info((Object)("Adding partitions " + partitionsToAdd.size() + " to table " + tableName));
        try {
            StorageDescriptor sd = this.client.getTable(this.databaseName, tableName).getSd();
            List partitionList = partitionsToAdd.stream().map(partition -> {
                StorageDescriptor partitionSd = new StorageDescriptor();
                partitionSd.setCols(sd.getCols());
                partitionSd.setInputFormat(sd.getInputFormat());
                partitionSd.setOutputFormat(sd.getOutputFormat());
                partitionSd.setSerdeInfo(sd.getSerdeInfo());
                String fullPartitionPath = FSUtils.getPartitionPath(this.syncConfig.getString(HoodieSyncConfig.META_SYNC_BASE_PATH), partition).toString();
                List<String> partitionValues = this.partitionValueExtractor.extractPartitionValuesInPath((String)partition);
                partitionSd.setLocation(fullPartitionPath);
                return new Partition(partitionValues, this.databaseName, tableName, 0, 0, partitionSd, null);
            }).collect(Collectors.toList());
            this.client.add_partitions(partitionList, true, false);
        }
        catch (TException e) {
            LOG.error((Object)(this.databaseName + "." + tableName + " add partition failed"), (Throwable)e);
            throw new HoodieHiveSyncException(this.databaseName + "." + tableName + " add partition failed", e);
        }
    }

    @Override
    public void updatePartitionsToTable(String tableName, List<String> changedPartitions) {
        if (changedPartitions.isEmpty()) {
            LOG.info((Object)("No partitions to change for " + tableName));
            return;
        }
        LOG.info((Object)("Changing partitions " + changedPartitions.size() + " on " + tableName));
        try {
            StorageDescriptor sd = this.client.getTable(this.databaseName, tableName).getSd();
            List partitionList = changedPartitions.stream().map(partition -> {
                Path partitionPath = FSUtils.getPartitionPath(this.syncConfig.getString(HoodieSyncConfig.META_SYNC_BASE_PATH), partition);
                String partitionScheme = partitionPath.toUri().getScheme();
                String fullPartitionPath = StorageSchemes.HDFS.getScheme().equals(partitionScheme) ? FSUtils.getDFSFullPartitionPath(this.syncConfig.getHadoopFileSystem(), partitionPath) : partitionPath.toString();
                List<String> partitionValues = this.partitionValueExtractor.extractPartitionValuesInPath((String)partition);
                StorageDescriptor partitionSd = sd.deepCopy();
                partitionSd.setLocation(fullPartitionPath);
                return new Partition(partitionValues, this.databaseName, tableName, 0, 0, partitionSd, null);
            }).collect(Collectors.toList());
            this.client.alter_partitions(this.databaseName, tableName, partitionList, null);
        }
        catch (TException e) {
            LOG.error((Object)(this.databaseName + "." + tableName + " update partition failed"), (Throwable)e);
            throw new HoodieHiveSyncException(this.databaseName + "." + tableName + " update partition failed", e);
        }
    }

    @Override
    public void dropPartitionsToTable(String tableName, List<String> partitionsToDrop) {
        if (partitionsToDrop.isEmpty()) {
            LOG.info((Object)("No partitions to drop for " + tableName));
            return;
        }
        LOG.info((Object)("Drop partitions " + partitionsToDrop.size() + " on " + tableName));
        try {
            for (String dropPartition : partitionsToDrop) {
                if (HivePartitionUtil.partitionExists(this.client, tableName, dropPartition, this.partitionValueExtractor, this.syncConfig).booleanValue()) {
                    String partitionClause = HivePartitionUtil.getPartitionClauseForDrop(dropPartition, this.partitionValueExtractor, this.syncConfig);
                    this.client.dropPartition(this.databaseName, tableName, partitionClause, false);
                }
                LOG.info((Object)("Drop partition " + dropPartition + " on " + tableName));
            }
        }
        catch (TException e) {
            LOG.error((Object)(this.databaseName + "." + tableName + " drop partition failed"), (Throwable)e);
            throw new HoodieHiveSyncException(this.databaseName + "." + tableName + " drop partition failed", e);
        }
    }

    @Override
    public void updateTableComments(String tableName, Map<String, Pair<String, String>> alterSchema) {
        try {
            Table table = this.client.getTable(this.databaseName, tableName);
            StorageDescriptor sd = new StorageDescriptor(table.getSd());
            for (FieldSchema fieldSchema : sd.getCols()) {
                if (!alterSchema.containsKey(fieldSchema.getName())) continue;
                String comment = alterSchema.get(fieldSchema.getName()).getRight();
                fieldSchema.setComment(comment);
            }
            table.setSd(sd);
            EnvironmentContext environmentContext = new EnvironmentContext();
            this.client.alter_table_with_environmentContext(this.databaseName, tableName, table, environmentContext);
            sd.clear();
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to update table comments for " + tableName), (Throwable)e);
            throw new HoodieHiveSyncException("Failed to update table comments for " + tableName, e);
        }
    }

    @Override
    public void close() {
        if (this.client != null) {
            Hive.closeCurrent();
        }
    }
}

