/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.client.Connection;
import org.apache.hudi.org.apache.hadoop.hbase.client.Put;
import org.apache.hudi.org.apache.hadoop.hbase.client.Table;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshotNotifier;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TableSpaceQuotaSnapshotNotifier
implements SpaceQuotaSnapshotNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(TableSpaceQuotaSnapshotNotifier.class);
    private Connection conn;

    @Override
    public void transitionTable(TableName tableName, SpaceQuotaSnapshot snapshot) throws IOException {
        Put p = QuotaTableUtil.createPutForSpaceSnapshot(tableName, snapshot);
        try (Table quotaTable = this.conn.getTable(QuotaTableUtil.QUOTA_TABLE_NAME);){
            if (LOG.isTraceEnabled()) {
                LOG.trace("Persisting a space quota snapshot " + snapshot + " for " + tableName);
            }
            quotaTable.put(p);
        }
    }

    @Override
    public void initialize(Connection conn) {
        this.conn = conn;
    }
}

