/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.tool;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hudi.org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hudi.org.apache.hadoop.hbase.client.Admin;
import org.apache.hudi.org.apache.hadoop.hbase.client.ClientServiceCallable;
import org.apache.hudi.org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hudi.org.apache.hadoop.hbase.client.Connection;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hudi.org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hudi.org.apache.hadoop.hbase.client.SecureBulkLoadClient;
import org.apache.hudi.org.apache.hadoop.hbase.client.Table;
import org.apache.hudi.org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hudi.org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hudi.org.apache.hadoop.hbase.io.HalfStoreFileReader;
import org.apache.hudi.org.apache.hadoop.hbase.io.Reference;
import org.apache.hudi.org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileInfo;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.ReaderContext;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.ReaderContextBuilder;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hudi.org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hudi.org.apache.hadoop.hbase.security.token.FsDelegationToken;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hudi.org.apache.hadoop.hbase.tool.BulkLoadHFiles;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.FSVisitor;
import org.apache.hudi.org.apache.hadoop.hbase.util.Pair;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.HashMultimap;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Multimap;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Multimaps;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@InterfaceAudience.Public
public class LoadIncrementalHFiles
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(LoadIncrementalHFiles.class);
    @Deprecated
    public static final String NAME = "completebulkload";
    static final String RETRY_ON_IO_EXCEPTION = "hbase.bulkload.retries.retryOnIOException";
    public static final String MAX_FILES_PER_REGION_PER_FAMILY = "hbase.mapreduce.bulkload.max.hfiles.perRegion.perFamily";
    private static final String ASSIGN_SEQ_IDS = "hbase.mapreduce.bulkload.assign.sequenceNumbers";
    public static final String CREATE_TABLE_CONF_KEY = "create.table";
    public static final String IGNORE_UNMATCHED_CF_CONF_KEY = "ignore.unmatched.families";
    public static final String ALWAYS_COPY_FILES = "always.copy.files";
    static final String TMP_DIR = ".tmp";
    private int maxFilesPerRegionPerFamily;
    private boolean assignSeqIds;
    private boolean bulkLoadByFamily;
    private FsDelegationToken fsDelegationToken;
    private UserProvider userProvider;
    private int nrThreads;
    private AtomicInteger numRetries;
    private RpcControllerFactory rpcControllerFactory;
    private String bulkToken;
    private List<String> clusterIds = new ArrayList<String>();
    private boolean replicate = true;

    public LoadIncrementalHFiles(Configuration conf) {
        super(HBaseConfiguration.create(conf));
        this.initialize();
    }

    public void initialize() {
        Configuration conf = this.getConf();
        conf.setFloat("hfile.block.cache.size", 0.0f);
        this.userProvider = UserProvider.instantiate(conf);
        this.fsDelegationToken = new FsDelegationToken(this.userProvider, "renewer");
        this.assignSeqIds = conf.getBoolean(ASSIGN_SEQ_IDS, true);
        this.maxFilesPerRegionPerFamily = conf.getInt(MAX_FILES_PER_REGION_PER_FAMILY, 32);
        this.bulkLoadByFamily = conf.getBoolean("hbase.mapreduce.bulkload.by.family", false);
        this.nrThreads = conf.getInt("hbase.loadincremental.threads.max", Runtime.getRuntime().availableProcessors());
        this.numRetries = new AtomicInteger(0);
        this.rpcControllerFactory = new RpcControllerFactory(conf);
    }

    private void usage() {
        System.err.println("Usage: bin/hbase completebulkload [OPTIONS] </PATH/TO/HFILEOUTPUTFORMAT-OUTPUT> <TABLENAME>\nLoads directory of hfiles -- a region dir or product of HFileOutputFormat -- into an hbase table.\nOPTIONS (for other -D options, see source code):\n -Dcreate.table=no whether to create table; when 'no', target table must exist.\n -Dignore.unmatched.families=yes to ignore unmatched column families.\n -loadTable for when directory of files to load has a depth of 3; target table must exist;\n must be last of the options on command line.\nSee http://hbase.apache.org/book.html#arch.bulk.load.complete.strays for documentation.\n");
    }

    public void prepareHFileQueue(Path hfilesDir, Table table, Deque<LoadQueueItem> queue, boolean validateHFile) throws IOException {
        this.prepareHFileQueue(hfilesDir, table, queue, validateHFile, false);
    }

    public void prepareHFileQueue(Path hfilesDir, Table table, Deque<LoadQueueItem> queue, boolean validateHFile, boolean silence) throws IOException {
        this.discoverLoadQueue(queue, hfilesDir, validateHFile);
        this.validateFamiliesInHFiles(table, queue, silence);
    }

    public void prepareHFileQueue(Map<byte[], List<Path>> map, Table table, Deque<LoadQueueItem> queue, boolean silence) throws IOException {
        this.populateLoadQueue(queue, map);
        this.validateFamiliesInHFiles(table, queue, silence);
    }

    public Map<LoadQueueItem, ByteBuffer> doBulkLoad(Path hfofDir, Admin admin, Table table, RegionLocator regionLocator) throws TableNotFoundException, IOException {
        return this.doBulkLoad(hfofDir, admin, table, regionLocator, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<LoadQueueItem, ByteBuffer> doBulkLoad(Map<byte[], List<Path>> map, Admin admin, Table table, RegionLocator regionLocator, boolean silence, boolean copyFile) throws TableNotFoundException, IOException {
        SecureBulkLoadClient secureClient;
        ExecutorService pool;
        ArrayDeque<LoadQueueItem> queue;
        block4: {
            Map<LoadQueueItem, ByteBuffer> map2;
            if (!admin.isTableAvailable(regionLocator.getName())) {
                throw new TableNotFoundException("Table " + table.getName() + " is not currently available.");
            }
            queue = new ArrayDeque<LoadQueueItem>();
            pool = null;
            secureClient = null;
            try {
                this.prepareHFileQueue(map, table, queue, silence);
                if (!queue.isEmpty()) break block4;
                LOG.warn("Bulk load operation did not get any files to load");
                map2 = Collections.emptyMap();
            }
            catch (Throwable throwable) {
                this.cleanup(admin, queue, pool, secureClient);
                throw throwable;
            }
            this.cleanup(admin, queue, pool, secureClient);
            return map2;
        }
        pool = this.createExecutorService();
        secureClient = new SecureBulkLoadClient(table.getConfiguration(), table);
        Map<LoadQueueItem, ByteBuffer> map3 = this.performBulkLoad(admin, table, regionLocator, queue, pool, secureClient, copyFile);
        this.cleanup(admin, queue, pool, secureClient);
        return map3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<LoadQueueItem, ByteBuffer> doBulkLoad(Path hfofDir, Admin admin, Table table, RegionLocator regionLocator, boolean silence, boolean copyFile) throws TableNotFoundException, IOException {
        SecureBulkLoadClient secureClient;
        ExecutorService pool;
        ArrayDeque<LoadQueueItem> queue;
        block5: {
            Map<LoadQueueItem, ByteBuffer> map;
            if (!admin.isTableAvailable(regionLocator.getName())) {
                throw new TableNotFoundException("Table " + table.getName() + " is not currently available.");
            }
            boolean validateHFile = this.getConf().getBoolean("hbase.loadincremental.validate.hfile", true);
            if (!validateHFile) {
                LOG.warn("You are skipping HFiles validation, it might cause some data loss if files are not correct. If you fail to read data from your table after using this option, consider removing the files and bulkload again without this option. See HBASE-13985");
            }
            queue = new ArrayDeque<LoadQueueItem>();
            pool = null;
            secureClient = null;
            try {
                this.prepareHFileQueue(hfofDir, table, queue, validateHFile, silence);
                if (!queue.isEmpty()) break block5;
                LOG.warn("Bulk load operation did not find any files to load in directory {}. Does it contain files in subdirectories that correspond to column family names?", (Object)(hfofDir != null ? hfofDir.toUri().toString() : ""));
                map = Collections.emptyMap();
            }
            catch (Throwable throwable) {
                this.cleanup(admin, queue, pool, secureClient);
                throw throwable;
            }
            this.cleanup(admin, queue, pool, secureClient);
            return map;
        }
        pool = this.createExecutorService();
        secureClient = new SecureBulkLoadClient(table.getConfiguration(), table);
        Map<LoadQueueItem, ByteBuffer> map = this.performBulkLoad(admin, table, regionLocator, queue, pool, secureClient, copyFile);
        this.cleanup(admin, queue, pool, secureClient);
        return map;
    }

    public void loadHFileQueue(Table table, Connection conn, Deque<LoadQueueItem> queue, Pair<byte[][], byte[][]> startEndKeys) throws IOException {
        this.loadHFileQueue(table, conn, queue, startEndKeys, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadHFileQueue(Table table, Connection conn, Deque<LoadQueueItem> queue, Pair<byte[][], byte[][]> startEndKeys, boolean copyFile) throws IOException {
        ExecutorService pool = null;
        try {
            pool = this.createExecutorService();
            Multimap<ByteBuffer, LoadQueueItem> regionGroups = this.groupOrSplitPhase(table, pool, queue, startEndKeys).getFirst();
            this.bulkLoadPhase(table, conn, pool, queue, regionGroups, copyFile, null);
        }
        finally {
            if (pool != null) {
                pool.shutdown();
            }
        }
    }

    private Map<LoadQueueItem, ByteBuffer> performBulkLoad(Admin admin, Table table, RegionLocator regionLocator, Deque<LoadQueueItem> queue, ExecutorService pool, SecureBulkLoadClient secureClient, boolean copyFile) throws IOException {
        int count = 0;
        if (this.isSecureBulkLoadEndpointAvailable()) {
            LOG.warn("SecureBulkLoadEndpoint is deprecated. It will be removed in future releases.");
            LOG.warn("Secure bulk load has been integrated into HBase core.");
        }
        this.fsDelegationToken.acquireDelegationToken(queue.peek().getFilePath().getFileSystem(this.getConf()));
        this.bulkToken = secureClient.prepareBulkLoad(admin.getConnection());
        Pair<Multimap<ByteBuffer, LoadQueueItem>, Set<String>> pair = null;
        HashMap<LoadQueueItem, ByteBuffer> item2RegionMap = new HashMap<LoadQueueItem, ByteBuffer>();
        while (!queue.isEmpty()) {
            Pair<byte[][], byte[][]> startEndKeys = regionLocator.getStartEndKeys();
            if (count != 0) {
                LOG.info("Split occurred while grouping HFiles, retry attempt " + count + " with " + queue.size() + " files remaining to group or split");
            }
            int maxRetries = this.getConf().getInt("hbase.bulkload.retries.number", 10);
            if ((maxRetries = Math.max(maxRetries, startEndKeys.getFirst().length + 1)) != 0 && count >= maxRetries) {
                throw new IOException("Retry attempted " + count + " times without completing, bailing out");
            }
            ++count;
            pair = this.groupOrSplitPhase(table, pool, queue, startEndKeys);
            Multimap<ByteBuffer, LoadQueueItem> regionGroups = pair.getFirst();
            if (!this.checkHFilesCountPerRegionPerFamily(regionGroups)) {
                throw new IOException("Trying to load more than " + this.maxFilesPerRegionPerFamily + " hfiles to one family of one region");
            }
            this.bulkLoadPhase(table, admin.getConnection(), pool, queue, regionGroups, copyFile, item2RegionMap);
        }
        if (!queue.isEmpty()) {
            throw new RuntimeException("Bulk load aborted with some files not yet loaded.Please check log for more details.");
        }
        return item2RegionMap;
    }

    private Map<byte[], Collection<LoadQueueItem>> groupByFamilies(Collection<LoadQueueItem> itemsInRegion) {
        TreeMap<byte[], Collection<LoadQueueItem>> families2Queue = new TreeMap<byte[], Collection<LoadQueueItem>>(Bytes.BYTES_COMPARATOR);
        itemsInRegion.forEach(item -> families2Queue.computeIfAbsent(item.getFamily(), queue -> new ArrayList()).add(item));
        return families2Queue;
    }

    @InterfaceAudience.Private
    protected void bulkLoadPhase(Table table, Connection conn, ExecutorService pool, Deque<LoadQueueItem> queue, Multimap<ByteBuffer, LoadQueueItem> regionGroups, boolean copyFile, Map<LoadQueueItem, ByteBuffer> item2RegionMap) throws IOException {
        HashSet<Future<List>> loadingFutures = new HashSet<Future<List>>();
        for (Map.Entry<ByteBuffer, Collection<LoadQueueItem>> entry : regionGroups.asMap().entrySet()) {
            byte[] first = entry.getKey().array();
            Collection<LoadQueueItem> lqis = entry.getValue();
            if (item2RegionMap != null) {
                Iterator<LoadQueueItem> iterator2 = lqis.iterator();
                while (iterator2.hasNext()) {
                    LoadQueueItem lqi = iterator2.next();
                    item2RegionMap.put(lqi, entry.getKey());
                }
            }
            if (this.bulkLoadByFamily) {
                this.groupByFamilies(lqis).values().forEach(familyQueue -> loadingFutures.add(pool.submit(() -> this.tryAtomicRegionLoad(conn, table.getName(), first, (Collection<LoadQueueItem>)familyQueue, copyFile))));
                continue;
            }
            loadingFutures.add(pool.submit(() -> this.tryAtomicRegionLoad(conn, table.getName(), first, lqis, copyFile)));
        }
        for (Future future : loadingFutures) {
            try {
                List toRetry = (List)future.get();
                if (item2RegionMap != null) {
                    for (LoadQueueItem lqi : toRetry) {
                        item2RegionMap.remove(lqi);
                    }
                }
                queue.addAll(toRetry);
            }
            catch (ExecutionException e1) {
                Throwable t = e1.getCause();
                if (t instanceof IOException) {
                    throw new IOException("BulkLoad encountered an unrecoverable problem", t);
                }
                LOG.error("Unexpected execution exception during bulk load", (Throwable)e1);
                throw new IllegalStateException(t);
            }
            catch (InterruptedException e1) {
                LOG.error("Unexpected interrupted exception during bulk load", (Throwable)e1);
                throw (InterruptedIOException)new InterruptedIOException().initCause(e1);
            }
        }
    }

    @InterfaceAudience.Private
    protected ClientServiceCallable<byte[]> buildClientServiceCallable(final Connection conn, TableName tableName, byte[] first, final Collection<LoadQueueItem> lqis, final boolean copyFile) {
        final List famPaths = lqis.stream().map(lqi -> Pair.newPair(lqi.getFamily(), lqi.getFilePath().toString())).collect(Collectors.toList());
        return new ClientServiceCallable<byte[]>(conn, tableName, first, (RpcController)this.rpcControllerFactory.newController(), -1){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected byte[] rpcCall() throws Exception {
                SecureBulkLoadClient secureClient = null;
                boolean success = false;
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Going to connect to server " + this.getLocation() + " for row " + Bytes.toStringBinary(this.getRow()) + " with hfile group " + LoadIncrementalHFiles.this.toString(famPaths));
                    }
                    byte[] regionName = this.getLocation().getRegionInfo().getRegionName();
                    try (Table table = conn.getTable(this.getTableName());){
                        secureClient = new SecureBulkLoadClient(LoadIncrementalHFiles.this.getConf(), table);
                        success = secureClient.secureBulkLoadHFiles((ClientProtos.ClientService.BlockingInterface)this.getStub(), famPaths, regionName, LoadIncrementalHFiles.this.assignSeqIds, LoadIncrementalHFiles.this.fsDelegationToken.getUserToken(), LoadIncrementalHFiles.this.bulkToken, copyFile, LoadIncrementalHFiles.this.clusterIds, LoadIncrementalHFiles.this.replicate);
                    }
                    byte[] byArray = (byte[])(success ? regionName : null);
                    return byArray;
                }
                finally {
                    if (secureClient != null && !success) {
                        FileSystem targetFs = FileSystem.get((Configuration)LoadIncrementalHFiles.this.getConf());
                        FileSystem sourceFs = ((LoadQueueItem)lqis.iterator().next()).getFilePath().getFileSystem(LoadIncrementalHFiles.this.getConf());
                        if (FSUtils.isSameHdfs(LoadIncrementalHFiles.this.getConf(), sourceFs, targetFs)) {
                            for (Pair el : famPaths) {
                                Path hfileStagingPath = null;
                                Path hfileOrigPath = new Path((String)el.getSecond());
                                try {
                                    hfileStagingPath = new Path(new Path(LoadIncrementalHFiles.this.bulkToken, Bytes.toString((byte[])el.getFirst())), hfileOrigPath.getName());
                                    if (targetFs.rename(hfileStagingPath, hfileOrigPath)) {
                                        LOG.debug("Moved back file " + hfileOrigPath + " from " + hfileStagingPath);
                                        continue;
                                    }
                                    if (!targetFs.exists(hfileStagingPath)) continue;
                                    LOG.debug("Unable to move back file " + hfileOrigPath + " from " + hfileStagingPath);
                                }
                                catch (Exception ex) {
                                    LOG.debug("Unable to move back file " + hfileOrigPath + " from " + hfileStagingPath, (Throwable)ex);
                                }
                            }
                        }
                    }
                }
            }
        };
    }

    private boolean checkHFilesCountPerRegionPerFamily(Multimap<ByteBuffer, LoadQueueItem> regionGroups) {
        for (Map.Entry<ByteBuffer, Collection<LoadQueueItem>> e : regionGroups.asMap().entrySet()) {
            TreeMap<byte[], MutableInt> filesMap = new TreeMap<byte[], MutableInt>(Bytes.BYTES_COMPARATOR);
            for (LoadQueueItem lqi : e.getValue()) {
                MutableInt count = filesMap.computeIfAbsent(lqi.getFamily(), k -> new MutableInt());
                count.increment();
                if (count.intValue() <= this.maxFilesPerRegionPerFamily) continue;
                LOG.error("Trying to load more than " + this.maxFilesPerRegionPerFamily + " hfiles to family " + Bytes.toStringBinary(lqi.getFamily()) + " of region with start key " + Bytes.toStringBinary(e.getKey()));
                return false;
            }
        }
        return true;
    }

    private Pair<Multimap<ByteBuffer, LoadQueueItem>, Set<String>> groupOrSplitPhase(final Table table, ExecutorService pool, Deque<LoadQueueItem> queue, final Pair<byte[][], byte[][]> startEndKeys) throws IOException {
        HashMultimap rgs = HashMultimap.create();
        final Multimap regionGroups = Multimaps.synchronizedMultimap(rgs);
        HashSet missingHFiles = new HashSet();
        Pair<Multimap<ByteBuffer, LoadQueueItem>, Set<String>> pair = new Pair<Multimap<ByteBuffer, LoadQueueItem>, Set<String>>(regionGroups, missingHFiles);
        HashSet<Future<Pair<List<LoadQueueItem>, String>>> splittingFutures = new HashSet<Future<Pair<List<LoadQueueItem>, String>>>();
        while (!queue.isEmpty()) {
            final LoadQueueItem item = queue.remove();
            Callable<Pair<List<LoadQueueItem>, String>> callable = new Callable<Pair<List<LoadQueueItem>, String>>(){

                @Override
                public Pair<List<LoadQueueItem>, String> call() throws Exception {
                    Pair<List<LoadQueueItem>, String> splits = LoadIncrementalHFiles.this.groupOrSplit(regionGroups, item, table, startEndKeys);
                    return splits;
                }
            };
            splittingFutures.add(pool.submit(callable));
        }
        for (Future future : splittingFutures) {
            try {
                Pair splits = (Pair)future.get();
                if (splits == null) continue;
                if (splits.getFirst() != null) {
                    queue.addAll((Collection)splits.getFirst());
                    continue;
                }
                missingHFiles.add(splits.getSecond());
            }
            catch (ExecutionException e1) {
                Throwable t = e1.getCause();
                if (t instanceof IOException) {
                    LOG.error("IOException during splitting", (Throwable)e1);
                    throw (IOException)t;
                }
                LOG.error("Unexpected execution exception during splitting", (Throwable)e1);
                throw new IllegalStateException(t);
            }
            catch (InterruptedException e1) {
                LOG.error("Unexpected interrupted exception during splitting", (Throwable)e1);
                throw (InterruptedIOException)new InterruptedIOException().initCause(e1);
            }
        }
        return pair;
    }

    private List<LoadQueueItem> splitStoreFile(LoadQueueItem item, Table table, byte[] startKey, byte[] splitKey) throws IOException {
        Path hfilePath = item.getFilePath();
        byte[] family = item.getFamily();
        Path tmpDir = hfilePath.getParent();
        if (!tmpDir.getName().equals(TMP_DIR)) {
            tmpDir = new Path(tmpDir, TMP_DIR);
        }
        LOG.info("HFile at " + hfilePath + " no longer fits inside a single region. Splitting...");
        String uniqueName = this.getUniqueName();
        ColumnFamilyDescriptor familyDesc = table.getDescriptor().getColumnFamily(family);
        Path botOut = new Path(tmpDir, uniqueName + ".bottom");
        Path topOut = new Path(tmpDir, uniqueName + ".top");
        LoadIncrementalHFiles.splitStoreFile(this.getConf(), hfilePath, familyDesc, splitKey, botOut, topOut);
        FileSystem fs = tmpDir.getFileSystem(this.getConf());
        fs.setPermission(tmpDir, FsPermission.valueOf((String)"-rwxrwxrwx"));
        fs.setPermission(botOut, FsPermission.valueOf((String)"-rwxrwxrwx"));
        fs.setPermission(topOut, FsPermission.valueOf((String)"-rwxrwxrwx"));
        ArrayList<LoadQueueItem> lqis = new ArrayList<LoadQueueItem>(2);
        lqis.add(new LoadQueueItem(family, botOut));
        lqis.add(new LoadQueueItem(family, topOut));
        try {
            if (tmpDir.getName().equals(TMP_DIR)) {
                fs.delete(hfilePath, false);
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to delete temporary split file " + hfilePath);
        }
        LOG.info("Successfully split into new HFiles " + botOut + " and " + topOut);
        return lqis;
    }

    private int getRegionIndex(Pair<byte[][], byte[][]> startEndKeys, byte[] key) {
        int idx = Arrays.binarySearch((Object[])startEndKeys.getFirst(), key, Bytes.BYTES_COMPARATOR);
        if (idx < 0) {
            idx = -(idx + 1) - 1;
        }
        return idx;
    }

    private void checkRegionIndexValid(int idx, Pair<byte[][], byte[][]> startEndKeys, TableName tableName) throws IOException {
        if (idx < 0) {
            throw new IOException("The first region info for table " + tableName + " can't be found in hbase:meta.Please use hbck tool to fix it first.");
        }
        if (idx == startEndKeys.getFirst().length - 1 && !Bytes.equals(startEndKeys.getSecond()[idx], HConstants.EMPTY_BYTE_ARRAY)) {
            throw new IOException("The last region info for table " + tableName + " can't be found in hbase:meta.Please use hbck tool to fix it first.");
        }
        if (idx + 1 < startEndKeys.getFirst().length && Bytes.compareTo(startEndKeys.getSecond()[idx], startEndKeys.getFirst()[idx + 1]) != 0) {
            throw new IOException("The endkey of one region for table " + tableName + " is not equal to the startkey of the next region in hbase:meta.Please use hbck tool to fix it first.");
        }
    }

    @InterfaceAudience.Private
    protected Pair<List<LoadQueueItem>, String> groupOrSplit(Multimap<ByteBuffer, LoadQueueItem> regionGroups, LoadQueueItem item, Table table, Pair<byte[][], byte[][]> startEndKeys) throws IOException {
        boolean lastKeyInRange;
        Optional<byte[]> last;
        Optional<byte[]> first;
        Path hfilePath = item.getFilePath();
        try (HFile.Reader hfr = HFile.createReader(hfilePath.getFileSystem(this.getConf()), hfilePath, CacheConfig.DISABLED, true, this.getConf());){
            first = hfr.getFirstRowKey();
            last = hfr.getLastRowKey();
        }
        catch (FileNotFoundException fnfe) {
            LOG.debug("encountered", (Throwable)fnfe);
            return new Pair<Object, String>(null, hfilePath.getName());
        }
        LOG.info("Trying to load hfile=" + hfilePath + " first=" + first.map(Bytes::toStringBinary) + " last=" + last.map(Bytes::toStringBinary));
        if (!first.isPresent() || !last.isPresent()) {
            assert (!first.isPresent() && !last.isPresent());
            LOG.info("hfile " + hfilePath + " has no entries, skipping");
            return null;
        }
        if (Bytes.compareTo(first.get(), last.get()) > 0) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary(first.get()) + " > " + Bytes.toStringBinary(last.get()));
        }
        int firstKeyRegionIdx = this.getRegionIndex(startEndKeys, first.get());
        this.checkRegionIndexValid(firstKeyRegionIdx, startEndKeys, table.getName());
        boolean bl = lastKeyInRange = Bytes.compareTo(last.get(), startEndKeys.getSecond()[firstKeyRegionIdx]) < 0 || Bytes.equals(startEndKeys.getSecond()[firstKeyRegionIdx], HConstants.EMPTY_BYTE_ARRAY);
        if (!lastKeyInRange) {
            int lastKeyRegionIdx = this.getRegionIndex(startEndKeys, last.get());
            int splitIdx = firstKeyRegionIdx + lastKeyRegionIdx >>> 1;
            if (splitIdx != firstKeyRegionIdx) {
                this.checkRegionIndexValid(splitIdx, startEndKeys, table.getName());
            }
            List<LoadQueueItem> lqis = this.splitStoreFile(item, table, startEndKeys.getFirst()[firstKeyRegionIdx], startEndKeys.getSecond()[splitIdx]);
            return new Pair<List<LoadQueueItem>, Object>(lqis, null);
        }
        regionGroups.put(ByteBuffer.wrap(startEndKeys.getFirst()[firstKeyRegionIdx]), item);
        return null;
    }

    @Deprecated
    @InterfaceAudience.Private
    protected List<LoadQueueItem> tryAtomicRegionLoad(Connection conn, TableName tableName, byte[] first, Collection<LoadQueueItem> lqis, boolean copyFile) throws IOException {
        ClientServiceCallable<byte[]> serviceCallable = this.buildClientServiceCallable(conn, tableName, first, lqis, copyFile);
        return this.tryAtomicRegionLoad(serviceCallable, tableName, first, lqis);
    }

    @Deprecated
    @InterfaceAudience.Private
    protected List<LoadQueueItem> tryAtomicRegionLoad(ClientServiceCallable<byte[]> serviceCallable, TableName tableName, byte[] first, Collection<LoadQueueItem> lqis) throws IOException {
        ArrayList<LoadQueueItem> toRetry = new ArrayList<LoadQueueItem>();
        try {
            Configuration conf = this.getConf();
            byte[] region = RpcRetryingCallerFactory.instantiate(conf, null).newCaller().callWithRetries(serviceCallable, Integer.MAX_VALUE);
            if (region == null) {
                LOG.warn("Attempt to bulk load region containing " + Bytes.toStringBinary(first) + " into table " + tableName + " with files " + lqis + " failed.  This is recoverable and they will be retried.");
                toRetry.addAll(lqis);
            }
            return toRetry;
        }
        catch (IOException e) {
            LOG.error("Encountered unrecoverable error from region server, additional details: " + serviceCallable.getExceptionMessageAdditionalDetail(), (Throwable)e);
            LOG.warn("Received a " + e.getClass().getSimpleName() + " from region server: " + serviceCallable.getExceptionMessageAdditionalDetail(), (Throwable)e);
            if (this.getConf().getBoolean(RETRY_ON_IO_EXCEPTION, false) && this.numRetries.get() < this.getConf().getInt("hbase.client.retries.number", 15)) {
                LOG.warn("Will attempt to retry loading failed HFiles. Retry #" + this.numRetries.incrementAndGet());
                toRetry.addAll(lqis);
                return toRetry;
            }
            LOG.error("hbase.bulkload.retries.retryOnIOException is disabled. Unable to recover");
            throw e;
        }
    }

    private void createTable(TableName tableName, Path hfofDir, Admin admin) throws IOException {
        final FileSystem fs = hfofDir.getFileSystem(this.getConf());
        final ArrayList familyBuilders = new ArrayList();
        final TreeMap<byte[], Integer> map = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        LoadIncrementalHFiles.visitBulkHFiles(fs, hfofDir, new BulkHFileVisitor<ColumnFamilyDescriptorBuilder>(){

            @Override
            public ColumnFamilyDescriptorBuilder bulkFamily(byte[] familyName) {
                ColumnFamilyDescriptorBuilder builder = ColumnFamilyDescriptorBuilder.newBuilder(familyName);
                familyBuilders.add(builder);
                return builder;
            }

            @Override
            public void bulkHFile(ColumnFamilyDescriptorBuilder builder, FileStatus hfileStatus) throws IOException {
                Path hfile = hfileStatus.getPath();
                try (HFile.Reader reader = HFile.createReader(fs, hfile, CacheConfig.DISABLED, true, LoadIncrementalHFiles.this.getConf());){
                    if (builder.getCompressionType() != reader.getFileContext().getCompression()) {
                        builder.setCompressionType(reader.getFileContext().getCompression());
                        LOG.info("Setting compression " + reader.getFileContext().getCompression().name() + " for family " + builder.getNameAsString());
                    }
                    byte[] first = reader.getFirstRowKey().get();
                    byte[] last = reader.getLastRowKey().get();
                    LOG.info("Trying to figure out region boundaries hfile=" + hfile + " first=" + Bytes.toStringBinary(first) + " last=" + Bytes.toStringBinary(last));
                    Integer value = map.containsKey(first) ? (Integer)map.get(first) : Integer.valueOf(0);
                    map.put(first, value + 1);
                    value = map.containsKey(last) ? (Integer)map.get(last) : Integer.valueOf(0);
                    map.put(last, value - 1);
                }
            }
        });
        byte[][] keys2 = LoadIncrementalHFiles.inferBoundaries(map);
        TableDescriptorBuilder tdBuilder = TableDescriptorBuilder.newBuilder(tableName);
        familyBuilders.stream().map(ColumnFamilyDescriptorBuilder::build).forEachOrdered(tdBuilder::setColumnFamily);
        admin.createTable(tdBuilder.build(), keys2);
        LOG.info("Table " + tableName + " is available!!");
    }

    private void cleanup(Admin admin, Deque<LoadQueueItem> queue, ExecutorService pool, SecureBulkLoadClient secureClient) throws IOException {
        this.fsDelegationToken.releaseDelegationToken();
        if (this.bulkToken != null && secureClient != null) {
            secureClient.cleanupBulkLoad(admin.getConnection(), this.bulkToken);
        }
        if (pool != null) {
            pool.shutdown();
        }
        if (!queue.isEmpty()) {
            StringBuilder err = new StringBuilder();
            err.append("-------------------------------------------------\n");
            err.append("Bulk load aborted with some files not yet loaded:\n");
            err.append("-------------------------------------------------\n");
            for (LoadQueueItem q : queue) {
                err.append("  ").append(q.getFilePath()).append('\n');
            }
            LOG.error(err.toString());
        }
    }

    private String getUniqueName() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    private void validateFamiliesInHFiles(Table table, Deque<LoadQueueItem> queue, boolean silence) throws IOException {
        Set familyNames = Arrays.asList(table.getDescriptor().getColumnFamilies()).stream().map(f -> f.getNameAsString()).collect(Collectors.toSet());
        List unmatchedFamilies = queue.stream().map(item -> Bytes.toString(item.getFamily())).filter(fn -> !familyNames.contains(fn)).distinct().collect(Collectors.toList());
        if (unmatchedFamilies.size() > 0) {
            String msg = "Unmatched family names found: unmatched family names in HFiles to be bulkloaded: " + unmatchedFamilies + "; valid family names of table " + table.getName() + " are: " + familyNames;
            LOG.error(msg);
            if (!silence) {
                throw new IOException(msg);
            }
        }
    }

    private void populateLoadQueue(Deque<LoadQueueItem> ret, Map<byte[], List<Path>> map) {
        map.forEach((k, v) -> v.stream().map(p -> new LoadQueueItem((byte[])k, (Path)p)).forEachOrdered(ret::add));
    }

    private void discoverLoadQueue(final Deque<LoadQueueItem> ret, Path hfofDir, boolean validateHFile) throws IOException {
        LoadIncrementalHFiles.visitBulkHFiles(hfofDir.getFileSystem(this.getConf()), hfofDir, new BulkHFileVisitor<byte[]>(){

            @Override
            public byte[] bulkFamily(byte[] familyName) {
                return familyName;
            }

            @Override
            public void bulkHFile(byte[] family, FileStatus hfile) throws IOException {
                long length = hfile.getLen();
                if (length > LoadIncrementalHFiles.this.getConf().getLong("hbase.hregion.max.filesize", 0x280000000L)) {
                    LOG.warn("Trying to bulk load hfile " + hfile.getPath() + " with size: " + length + " bytes can be problematic as it may lead to oversplitting.");
                }
                ret.add(new LoadQueueItem(family, hfile.getPath()));
            }
        }, validateHFile);
    }

    private static <TFamily> void visitBulkHFiles(FileSystem fs, Path bulkDir, BulkHFileVisitor<TFamily> visitor) throws IOException {
        LoadIncrementalHFiles.visitBulkHFiles(fs, bulkDir, visitor, true);
    }

    private static <TFamily> void visitBulkHFiles(FileSystem fs, Path bulkDir, BulkHFileVisitor<TFamily> visitor, boolean validateHFile) throws IOException {
        FileStatus[] familyDirStatuses;
        for (FileStatus familyStat : familyDirStatuses = fs.listStatus(bulkDir)) {
            FileStatus[] hfileStatuses;
            if (!familyStat.isDirectory()) {
                LOG.warn("Skipping non-directory " + familyStat.getPath());
                continue;
            }
            Path familyDir = familyStat.getPath();
            byte[] familyName = Bytes.toBytes(familyDir.getName());
            try {
                ColumnFamilyDescriptorBuilder.isLegalColumnFamilyName(familyName);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Skipping invalid " + familyStat.getPath());
                continue;
            }
            TFamily family = visitor.bulkFamily(familyName);
            for (FileStatus hfileStatus : hfileStatuses = fs.listStatus(familyDir)) {
                block12: {
                    if (!fs.isFile(hfileStatus.getPath())) {
                        LOG.warn("Skipping non-file " + hfileStatus);
                        continue;
                    }
                    Path hfile = hfileStatus.getPath();
                    String fileName = hfile.getName();
                    if (fileName.startsWith("_")) continue;
                    if (StoreFileInfo.isReference(fileName)) {
                        LOG.warn("Skipping reference " + fileName);
                        continue;
                    }
                    if (HFileLink.isHFileLink(fileName)) {
                        LOG.warn("Skipping HFileLink " + fileName);
                        continue;
                    }
                    if (validateHFile) {
                        try {
                            if (!HFile.isHFileFormat(fs, hfile)) {
                                LOG.warn("the file " + hfile + " doesn't seems to be an hfile. skipping");
                            }
                            break block12;
                        }
                        catch (FileNotFoundException e) {
                            LOG.warn("the file " + hfile + " was removed");
                        }
                        continue;
                    }
                }
                visitor.bulkHFile(family, hfileStatus);
            }
        }
    }

    private ExecutorService createExecutorService() {
        ThreadPoolExecutor pool = new ThreadPoolExecutor(this.nrThreads, this.nrThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("LoadIncrementalHFiles-%1$d").build());
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }

    private final String toString(List<Pair<byte[], String>> list) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        list.forEach(p -> sb.append('{').append(Bytes.toStringBinary((byte[])p.getFirst())).append(',').append((String)p.getSecond()).append('}'));
        sb.append(']');
        return sb.toString();
    }

    private boolean isSecureBulkLoadEndpointAvailable() {
        String classes = this.getConf().get("hbase.coprocessor.region.classes", "");
        return classes.contains("org.apache.hudi.org.apache.hadoop.hbase.security.access.SecureBulkLoadEndpoint");
    }

    @InterfaceAudience.Private
    static void splitStoreFile(Configuration conf, Path inFile, ColumnFamilyDescriptor familyDesc, byte[] splitKey, Path bottomOut, Path topOut) throws IOException {
        Reference topReference = Reference.createTopReference(splitKey);
        Reference bottomReference = Reference.createBottomReference(splitKey);
        LoadIncrementalHFiles.copyHFileHalf(conf, inFile, topOut, topReference, familyDesc);
        LoadIncrementalHFiles.copyHFileHalf(conf, inFile, bottomOut, bottomReference, familyDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyHFileHalf(Configuration conf, Path inFile, Path outFile, Reference reference, ColumnFamilyDescriptor familyDescriptor) throws IOException {
        FileSystem fs = inFile.getFileSystem(conf);
        CacheConfig cacheConf = CacheConfig.DISABLED;
        StoreFileReader halfReader = null;
        StoreFileWriter halfWriter = null;
        try {
            ReaderContext context = new ReaderContextBuilder().withFileSystemAndPath(fs, inFile).build();
            HFileInfo hfile = new HFileInfo(context, conf);
            halfReader = new HalfStoreFileReader(context, hfile, cacheConf, reference, new AtomicInteger(0), conf);
            hfile.initMetaAndIndex(halfReader.getHFileReader());
            Map<byte[], byte[]> fileInfo = halfReader.loadFileInfo();
            int blocksize = familyDescriptor.getBlocksize();
            Compression.Algorithm compression = familyDescriptor.getCompressionType();
            BloomType bloomFilterType = familyDescriptor.getBloomFilterType();
            HFileContext hFileContext = new HFileContextBuilder().withCompression(compression).withChecksumType(StoreUtils.getChecksumType(conf)).withBytesPerCheckSum(StoreUtils.getBytesPerChecksum(conf)).withBlockSize(blocksize).withDataBlockEncoding(familyDescriptor.getDataBlockEncoding()).withIncludesTags(true).build();
            halfWriter = new StoreFileWriter.Builder(conf, cacheConf, fs).withFilePath(outFile).withBloomType(bloomFilterType).withFileContext(hFileContext).build();
            HFileScanner scanner = ((HalfStoreFileReader)halfReader).getScanner(false, false, false);
            scanner.seekTo();
            do {
                halfWriter.append(scanner.getCell());
            } while (scanner.next());
            for (Map.Entry<byte[], byte[]> entry : fileInfo.entrySet()) {
                if (!LoadIncrementalHFiles.shouldCopyHFileMetaKey(entry.getKey())) continue;
                halfWriter.appendFileInfo(entry.getKey(), entry.getValue());
            }
        }
        finally {
            if (halfReader != null) {
                try {
                    halfReader.close(cacheConf.shouldEvictOnClose());
                }
                catch (IOException e) {
                    LOG.warn("failed to close hfile reader for " + inFile, (Throwable)e);
                }
            }
            if (halfWriter != null) {
                halfWriter.close();
            }
        }
    }

    private static boolean shouldCopyHFileMetaKey(byte[] key) {
        if (Bytes.equals(key, HFileDataBlockEncoder.DATA_BLOCK_ENCODING)) {
            return false;
        }
        return !HFileInfo.isReservedFileInfoKey(key);
    }

    private boolean isCreateTable() {
        return "yes".equalsIgnoreCase(this.getConf().get(CREATE_TABLE_CONF_KEY, "yes"));
    }

    private boolean isSilence() {
        return "yes".equalsIgnoreCase(this.getConf().get(IGNORE_UNMATCHED_CF_CONF_KEY, ""));
    }

    private boolean isAlwaysCopyFiles() {
        return this.getConf().getBoolean(ALWAYS_COPY_FILES, false);
    }

    /*
     * Exception decompiling
     */
    protected final Map<LoadQueueItem, ByteBuffer> run(Path hfofDir, TableName tableName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Map<LoadQueueItem, ByteBuffer> run(String hfofDir, TableName tableName) throws IOException {
        return this.run(new Path(hfofDir), tableName);
    }

    /*
     * Exception decompiling
     */
    public Map<LoadQueueItem, ByteBuffer> run(Map<byte[], List<Path>> family2Files, TableName tableName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int run(String[] args) throws Exception {
        if (args.length != 2 && args.length != 3) {
            this.usage();
            return -1;
        }
        this.initialize();
        String dirPath = args[0];
        TableName tableName = TableName.valueOf(args[1]);
        if (args.length == 2) {
            return !this.run(dirPath, tableName).isEmpty() ? 0 : -1;
        }
        HashMap<byte[], List<Path>> family2Files = Maps.newHashMap();
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        for (FileStatus regionDir : fs.listStatus(new Path(dirPath))) {
            FSVisitor.visitRegionStoreFiles(fs, regionDir.getPath(), (region, family, hfileName) -> {
                Path path = new Path(regionDir.getPath(), new Path(family, hfileName));
                byte[] familyName = Bytes.toBytes(family);
                if (family2Files.containsKey(familyName)) {
                    ((List)family2Files.get(familyName)).add(path);
                } else {
                    family2Files.put(familyName, Lists.newArrayList(path));
                }
            });
        }
        return !this.run(family2Files, tableName).isEmpty() ? 0 : -1;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int ret = ToolRunner.run((Configuration)conf, (Tool)new LoadIncrementalHFiles(conf), (String[])args);
        System.exit(ret);
    }

    public void setBulkToken(String stagingDir) {
        this.bulkToken = stagingDir;
    }

    public void setClusterIds(List<String> clusterIds) {
        this.clusterIds = clusterIds;
    }

    public void disableReplication() {
        this.replicate = false;
    }

    public static byte[][] inferBoundaries(SortedMap<byte[], Integer> bdryMap) {
        ArrayList<byte[]> keysArray = new ArrayList<byte[]>();
        int runningValue = 0;
        byte[] currStartKey = null;
        boolean firstBoundary = true;
        for (Map.Entry<byte[], Integer> item : bdryMap.entrySet()) {
            if (runningValue == 0) {
                currStartKey = item.getKey();
            }
            if ((runningValue += item.getValue().intValue()) != 0) continue;
            if (!firstBoundary) {
                keysArray.add(currStartKey);
            }
            firstBoundary = false;
        }
        return (byte[][])keysArray.toArray((T[])new byte[0][]);
    }

    private static interface BulkHFileVisitor<TFamily> {
        public TFamily bulkFamily(byte[] var1) throws IOException;

        public void bulkHFile(TFamily var1, FileStatus var2) throws IOException;
    }

    @InterfaceAudience.Public
    @Deprecated
    public static class LoadQueueItem
    extends BulkLoadHFiles.LoadQueueItem {
        public LoadQueueItem(byte[] family, Path hfilePath) {
            super(family, hfilePath);
        }
    }
}

