/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.compact;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.ProcessOperator;
import org.apache.hudi.async.HoodieAsyncTableService;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.client.HoodieFlinkWriteClient;
import org.apache.hudi.com.beust.jcommander.JCommander;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.sink.compact.CompactFunction;
import org.apache.hudi.sink.compact.CompactionCommitEvent;
import org.apache.hudi.sink.compact.CompactionCommitSink;
import org.apache.hudi.sink.compact.CompactionPlanSourceFunction;
import org.apache.hudi.sink.compact.FlinkCompactionConfig;
import org.apache.hudi.sink.compact.strategy.CompactionPlanStrategies;
import org.apache.hudi.table.HoodieFlinkTable;
import org.apache.hudi.util.CompactionUtil;
import org.apache.hudi.util.StreamerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieFlinkCompactor {
    protected static final Logger LOG = LoggerFactory.getLogger(HoodieFlinkCompactor.class);
    private final AsyncCompactionService compactionScheduleService;

    public HoodieFlinkCompactor(AsyncCompactionService service2) {
        this.compactionScheduleService = service2;
    }

    public static void main(String[] args) throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        FlinkCompactionConfig cfg = HoodieFlinkCompactor.getFlinkCompactionConfig(args);
        Configuration conf = FlinkCompactionConfig.toFlinkConfig(cfg);
        AsyncCompactionService service2 = new AsyncCompactionService(cfg, conf, env);
        new HoodieFlinkCompactor(service2).start(cfg.serviceMode);
    }

    public void start(boolean serviceMode) throws Exception {
        if (serviceMode) {
            this.compactionScheduleService.start(null);
            try {
                this.compactionScheduleService.waitForShutdown();
            }
            catch (Exception e) {
                throw new HoodieException(e.getMessage(), e);
            }
            finally {
                LOG.info("Shut down hoodie flink compactor");
            }
        }
        LOG.info("Hoodie Flink Compactor running only single round");
        try {
            this.compactionScheduleService.compact();
        }
        catch (Exception e) {
            LOG.error("Got error running delta sync once. Shutting down", (Throwable)e);
            throw e;
        }
        finally {
            LOG.info("Shut down hoodie flink compactor");
        }
    }

    public static FlinkCompactionConfig getFlinkCompactionConfig(String[] args) {
        FlinkCompactionConfig cfg = new FlinkCompactionConfig();
        JCommander cmd = new JCommander((Object)cfg, null, args);
        if (cfg.help.booleanValue() || args.length == 0) {
            cmd.usage();
            System.exit(1);
        }
        return cfg;
    }

    private static boolean validCompactionPlan(HoodieCompactionPlan plan) {
        return plan != null && plan.getOperations() != null && plan.getOperations().size() > 0;
    }

    public static class AsyncCompactionService
    extends HoodieAsyncTableService {
        private static final long serialVersionUID = 1L;
        private final FlinkCompactionConfig cfg;
        private final Configuration conf;
        private final HoodieTableMetaClient metaClient;
        private final HoodieFlinkWriteClient<?> writeClient;
        private final HoodieFlinkTable<?> table;
        private final StreamExecutionEnvironment env;
        private final ExecutorService executor;

        public AsyncCompactionService(FlinkCompactionConfig cfg, Configuration conf, StreamExecutionEnvironment env) throws Exception {
            this.cfg = cfg;
            this.conf = conf;
            this.env = env;
            this.executor = Executors.newFixedThreadPool(1);
            this.metaClient = StreamerUtil.createMetaClient(conf);
            conf.setString(FlinkOptions.TABLE_NAME, this.metaClient.getTableConfig().getTableName());
            CompactionUtil.setAvroSchema(conf, this.metaClient);
            CompactionUtil.setPreCombineField(conf, this.metaClient);
            CompactionUtil.inferChangelogMode(conf, this.metaClient);
            this.writeClient = StreamerUtil.createWriteClient(conf);
            this.writeConfig = this.writeClient.getConfig();
            this.table = this.writeClient.getHoodieTable();
        }

        @Override
        protected Pair<CompletableFuture, ExecutorService> startService() {
            return Pair.of(CompletableFuture.supplyAsync(() -> {
                boolean error = false;
                try {
                    while (!this.isShutdownRequested()) {
                        try {
                            this.compact();
                            Thread.sleep(this.cfg.minCompactionIntervalSeconds * 1000);
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Shutting down compaction service due to exception", (Throwable)e);
                            error = true;
                            throw new HoodieException(e.getMessage(), e);
                            return true;
                        }
                    }
                }
                finally {
                    this.shutdownAsyncService(error);
                }
            }, this.executor), this.executor);
        }

        private void compact() throws Exception {
            Option<String> compactionInstantTimeOption;
            this.table.getMetaClient().reloadActiveTimeline();
            if (this.cfg.schedule.booleanValue() && (compactionInstantTimeOption = CompactionUtil.getCompactionInstantTime(this.metaClient)).isPresent()) {
                boolean scheduled = this.writeClient.scheduleCompactionAtInstant(compactionInstantTimeOption.get(), Option.empty());
                if (!scheduled) {
                    LOG.info((Object)"No compaction plan for this job ");
                    return;
                }
                this.table.getMetaClient().reloadActiveTimeline();
            }
            HoodieTimeline pendingCompactionTimeline = this.table.getActiveTimeline().filterPendingCompactionTimeline();
            List<HoodieInstant> requested = CompactionPlanStrategies.getStrategy(this.cfg).select(pendingCompactionTimeline);
            if (requested.isEmpty()) {
                LOG.info((Object)"No compaction plan scheduled, turns on the compaction plan schedule with --schedule option");
                return;
            }
            List<String> compactionInstantTimes = requested.stream().map(HoodieInstant::getTimestamp).collect(Collectors.toList());
            compactionInstantTimes.forEach(timestamp -> {
                HoodieInstant inflightInstant = HoodieTimeline.getCompactionInflightInstant(timestamp);
                if (pendingCompactionTimeline.containsInstant(inflightInstant)) {
                    LOG.info((Object)("Rollback inflight compaction instant: [" + timestamp + "]"));
                    this.table.rollbackInflightCompaction(inflightInstant);
                    this.table.getMetaClient().reloadActiveTimeline();
                }
            });
            List<Pair<String, HoodieCompactionPlan>> compactionPlans = compactionInstantTimes.stream().map(timestamp -> {
                try {
                    return Pair.of(timestamp, CompactionUtils.getCompactionPlan(this.table.getMetaClient(), timestamp));
                }
                catch (IOException e) {
                    throw new HoodieException("Get compaction plan at instant " + timestamp + " error", e);
                }
            }).filter(pair -> HoodieFlinkCompactor.validCompactionPlan((HoodieCompactionPlan)pair.getRight())).collect(Collectors.toList());
            if (compactionPlans.isEmpty()) {
                LOG.info((Object)("No compaction plan for instant " + String.join((CharSequence)",", compactionInstantTimes)));
                return;
            }
            List instants = compactionInstantTimes.stream().map(HoodieTimeline::getCompactionRequestedInstant).collect(Collectors.toList());
            for (HoodieInstant instant : instants) {
                if (pendingCompactionTimeline.containsInstant(instant)) continue;
                LOG.warn((Object)"The compaction plan was fetched through the auxiliary path(.tmp) but not the meta path(.hoodie).\nClean the compaction plan in auxiliary path and cancels the compaction");
                CompactionUtil.cleanInstant(this.table.getMetaClient(), instant);
                return;
            }
            int compactionParallelism = this.conf.getInteger(FlinkOptions.COMPACTION_TASKS) == -1 ? Math.toIntExact(compactionPlans.stream().mapToLong(pair -> ((HoodieCompactionPlan)pair.getRight()).getOperations().size()).sum()) : this.conf.getInteger(FlinkOptions.COMPACTION_TASKS);
            LOG.info((Object)("Start to compaction for instant " + compactionInstantTimes));
            for (HoodieInstant instant : instants) {
                this.table.getActiveTimeline().transitionCompactionRequestedToInflight(instant);
            }
            this.table.getMetaClient().reloadActiveTimeline();
            this.env.addSource((SourceFunction)new CompactionPlanSourceFunction(compactionPlans)).name("compaction_source").uid("uid_compaction_source").rebalance().transform("compact_task", TypeInformation.of(CompactionCommitEvent.class), (OneInputStreamOperator)new ProcessOperator((ProcessFunction)new CompactFunction(this.conf))).setParallelism(compactionParallelism).addSink((SinkFunction)new CompactionCommitSink(this.conf)).name("compaction_commit").uid("uid_compaction_commit").setParallelism(1);
            this.env.execute("flink_hudi_compaction_" + String.join((CharSequence)",", compactionInstantTimes));
        }

        public void shutdownAsyncService(boolean error) {
            LOG.info((Object)("Gracefully shutting down compactor. Error ?" + error));
            this.executor.shutdown();
            this.writeClient.close();
        }

        @VisibleForTesting
        public void shutDown() {
            this.shutdownAsyncService(false);
        }
    }
}

