/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.cluster;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieClusteringException;
import org.apache.hudi.table.action.cluster.ClusteringPlanPartitionFilterMode;

public class ClusteringPlanPartitionFilter {
    public static List<String> filter(List<String> partitions, HoodieWriteConfig config) {
        ClusteringPlanPartitionFilterMode mode = config.getClusteringPlanPartitionFilterMode();
        switch (mode) {
            case NONE: {
                return partitions;
            }
            case RECENT_DAYS: {
                return ClusteringPlanPartitionFilter.recentDaysFilter(partitions, config);
            }
            case SELECTED_PARTITIONS: {
                return ClusteringPlanPartitionFilter.selectedPartitionsFilter(partitions, config);
            }
        }
        throw new HoodieClusteringException("Unknown partition filter, filter mode: " + (Object)((Object)mode));
    }

    private static List<String> recentDaysFilter(List<String> partitions, HoodieWriteConfig config) {
        int targetPartitionsForClustering = config.getTargetPartitionsForClustering();
        int skipPartitionsFromLatestForClustering = config.getSkipPartitionsFromLatestForClustering();
        return partitions.stream().sorted(Comparator.reverseOrder()).skip(Math.max(skipPartitionsFromLatestForClustering, 0)).limit(targetPartitionsForClustering > 0 ? (long)targetPartitionsForClustering : (long)partitions.size()).collect(Collectors.toList());
    }

    private static List<String> selectedPartitionsFilter(List<String> partitions, HoodieWriteConfig config) {
        String endPartition;
        Stream<Object> filteredPartitions = partitions.stream();
        String beginPartition = config.getBeginPartitionForClustering();
        if (beginPartition != null) {
            filteredPartitions = filteredPartitions.filter(path -> path.compareTo(beginPartition) >= 0);
        }
        if ((endPartition = config.getEndPartitionForClustering()) != null) {
            filteredPartitions = filteredPartitions.filter(path -> path.compareTo(endPartition) <= 0);
        }
        return filteredPartitions.collect(Collectors.toList());
    }
}

