/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.catalog;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.sql.parser.hive.ddl.SqlAlterHiveDatabase;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.AbstractCatalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionAlreadyExistsException;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionSpecInvalidException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotPartitionedException;
import org.apache.flink.table.catalog.exceptions.TablePartitionedException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.configuration.OptionsResolver;
import org.apache.hudi.exception.HoodieCatalogException;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.table.catalog.CatalogOptions;
import org.apache.hudi.table.catalog.HiveSchemaUtils;
import org.apache.hudi.table.catalog.HoodieCatalogUtil;
import org.apache.hudi.table.catalog.TableOptionProperties;
import org.apache.hudi.table.format.FilePathUtils;
import org.apache.hudi.util.AvroSchemaConverter;
import org.apache.hudi.util.StreamerUtil;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieHiveCatalog
extends AbstractCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieHiveCatalog.class);
    private final HiveConf hiveConf;
    private IMetaStoreClient client;
    private final String catalogPath;

    public HoodieHiveCatalog(String catalogName, String catalogPath, String defaultDatabase, String hiveConfDir) {
        this(catalogName, catalogPath, defaultDatabase, HoodieCatalogUtil.createHiveConf(hiveConfDir), false);
    }

    public HoodieHiveCatalog(String catalogName, String catalogPath, String defaultDatabase, HiveConf hiveConf, boolean allowEmbedded) {
        super(catalogName, defaultDatabase == null ? "default" : defaultDatabase);
        this.catalogPath = catalogPath == null ? hiveConf.getVar(HiveConf.ConfVars.METASTOREWAREHOUSE) : catalogPath;
        this.hiveConf = hiveConf;
        if (!allowEmbedded) {
            Preconditions.checkArgument((!HoodieCatalogUtil.isEmbeddedMetastore(this.hiveConf) ? 1 : 0) != 0, (Object)("Embedded metastore is not allowed. Make sure you have set a valid value for " + HiveConf.ConfVars.METASTOREURIS));
        }
        LOG.info("Created Hoodie Catalog '{}' in hms mode", (Object)catalogName);
    }

    public void open() throws CatalogException {
        if (this.client == null) {
            try {
                this.client = Hive.get((HiveConf)this.hiveConf).getMSC();
            }
            catch (Exception e) {
                throw new HoodieCatalogException("Failed to create hive metastore client", e);
            }
            LOG.info("Connected to Hive metastore");
        }
        if (!this.databaseExists(this.getDefaultDatabase())) {
            LOG.info("{} does not exist, will be created.", (Object)this.getDefaultDatabase());
            CatalogDatabaseImpl database = new CatalogDatabaseImpl(Collections.emptyMap(), "default database");
            try {
                this.createDatabase(this.getDefaultDatabase(), (CatalogDatabase)database, true);
            }
            catch (DatabaseAlreadyExistException e) {
                throw new HoodieCatalogException(this.getName(), e);
            }
        }
    }

    public void close() throws CatalogException {
        if (this.client != null) {
            this.client.close();
            this.client = null;
            LOG.info("Disconnect to hive metastore");
        }
    }

    public HiveConf getHiveConf() {
        return this.hiveConf;
    }

    public List<String> listDatabases() throws CatalogException {
        try {
            return this.client.getAllDatabases();
        }
        catch (TException e) {
            throw new HoodieCatalogException(String.format("Failed to list all databases in %s", this.getName()), e);
        }
    }

    private Database getHiveDatabase(String databaseName) throws DatabaseNotExistException {
        try {
            return this.client.getDatabase(databaseName);
        }
        catch (NoSuchObjectException e) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        catch (TException e) {
            throw new HoodieCatalogException(String.format("Failed to get database %s from %s", databaseName, this.getName()), e);
        }
    }

    public CatalogDatabase getDatabase(String databaseName) throws DatabaseNotExistException, CatalogException {
        Database hiveDatabase = this.getHiveDatabase(databaseName);
        HashMap<String, String> properties = new HashMap<String, String>(hiveDatabase.getParameters());
        properties.put("hive.database.location-uri", hiveDatabase.getLocationUri());
        return new CatalogDatabaseImpl(properties, hiveDatabase.getDescription());
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        try {
            return this.client.getDatabase(databaseName) != null;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        catch (TException e) {
            throw new HoodieCatalogException(String.format("Failed to determine whether database %s exists or not", databaseName), e);
        }
    }

    public void createDatabase(String databaseName, CatalogDatabase database, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        Preconditions.checkArgument((!org.apache.flink.util.StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0, (Object)"Database name can not null or empty");
        Preconditions.checkNotNull((Object)database, (String)"database cannot be null");
        Map properties = database.getProperties();
        String dbLocationUri = (String)properties.remove("hive.database.location-uri");
        if (dbLocationUri == null && this.catalogPath != null) {
            dbLocationUri = new Path(this.catalogPath, databaseName).toString();
        }
        Database hiveDatabase = new Database(databaseName, database.getComment(), dbLocationUri, properties);
        try {
            this.client.createDatabase(hiveDatabase);
        }
        catch (AlreadyExistsException e) {
            if (!ignoreIfExists) {
                throw new DatabaseAlreadyExistException(this.getName(), hiveDatabase.getName());
            }
        }
        catch (TException e) {
            throw new HoodieCatalogException(String.format("Failed to create database %s", hiveDatabase.getName()), e);
        }
    }

    public void dropDatabase(String name, boolean ignoreIfNotExists, boolean cascade) throws DatabaseNotExistException, DatabaseNotEmptyException, CatalogException {
        try {
            this.client.dropDatabase(name, true, ignoreIfNotExists, cascade);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreIfNotExists) {
                throw new DatabaseNotExistException(this.getName(), name);
            }
        }
        catch (InvalidOperationException e) {
            throw new DatabaseNotEmptyException(this.getName(), name);
        }
        catch (TException e) {
            throw new HoodieCatalogException(String.format("Failed to drop database %s", name), e);
        }
    }

    public void alterDatabase(String databaseName, CatalogDatabase newDatabase, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
        Database hiveDB;
        Preconditions.checkArgument((!org.apache.flink.util.StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0, (Object)"Database name cannot be null or empty");
        Preconditions.checkNotNull((Object)newDatabase, (String)"New database cannot be null");
        try {
            hiveDB = this.getHiveDatabase(databaseName);
        }
        catch (DatabaseNotExistException e) {
            if (!ignoreIfNotExists) {
                throw new DatabaseNotExistException(this.getName(), databaseName);
            }
            return;
        }
        try {
            this.client.alterDatabase(databaseName, HoodieHiveCatalog.alterDatabase(hiveDB, newDatabase));
        }
        catch (TException e) {
            throw new HoodieCatalogException(String.format("Failed to alter database %s", databaseName), e);
        }
    }

    private static Database alterDatabase(Database hiveDB, CatalogDatabase newDatabase) {
        Map newParams = newDatabase.getProperties();
        String opStr = (String)newParams.remove("hive.alter.database.op");
        if (opStr == null) {
            opStr = SqlAlterHiveDatabase.AlterHiveDatabaseOp.CHANGE_PROPS.name();
        }
        String newLocation = (String)newParams.remove("hive.database.location-uri");
        SqlAlterHiveDatabase.AlterHiveDatabaseOp op = SqlAlterHiveDatabase.AlterHiveDatabaseOp.valueOf((String)opStr);
        block0 : switch (op) {
            case CHANGE_PROPS: {
                hiveDB.setParameters(newParams);
                break;
            }
            case CHANGE_LOCATION: {
                hiveDB.setLocationUri(newLocation);
                break;
            }
            case CHANGE_OWNER: {
                String ownerName = (String)newParams.remove("hive.database.owner.name");
                String ownerType = (String)newParams.remove("hive.database.owner.type");
                hiveDB.setOwnerName(ownerName);
                switch (ownerType) {
                    case "role": {
                        hiveDB.setOwnerType(PrincipalType.ROLE);
                        break block0;
                    }
                    case "user": {
                        hiveDB.setOwnerType(PrincipalType.USER);
                        break block0;
                    }
                }
                throw new CatalogException("Unsupported database owner type: " + ownerType);
            }
            default: {
                throw new CatalogException("Unsupported alter database op:" + opStr);
            }
        }
        if (hiveDB.getParameters() != null) {
            hiveDB.getParameters().remove("is_generic");
        }
        return hiveDB;
    }

    private org.apache.hadoop.hive.metastore.api.Table isHoodieTable(org.apache.hadoop.hive.metastore.api.Table hiveTable) {
        if (!hiveTable.getParameters().getOrDefault("spark.sql.sources.provider", "").equalsIgnoreCase("hudi") && !this.isFlinkHoodieTable(hiveTable)) {
            throw new HoodieCatalogException(String.format("the %s is not hoodie table", hiveTable.getTableName()));
        }
        return hiveTable;
    }

    private boolean isFlinkHoodieTable(org.apache.hadoop.hive.metastore.api.Table hiveTable) {
        return hiveTable.getParameters().getOrDefault(FactoryUtil.CONNECTOR.key(), "").equalsIgnoreCase("hudi");
    }

    @VisibleForTesting
    public org.apache.hadoop.hive.metastore.api.Table getHiveTable(ObjectPath tablePath) throws TableNotExistException {
        try {
            org.apache.hadoop.hive.metastore.api.Table hiveTable = this.client.getTable(tablePath.getDatabaseName(), tablePath.getObjectName());
            return this.isHoodieTable(hiveTable);
        }
        catch (NoSuchObjectException e) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        catch (TException e) {
            throw new HoodieCatalogException(String.format("Failed to get table %s from Hive metastore", tablePath.getObjectName()));
        }
    }

    private org.apache.hadoop.hive.metastore.api.Table translateSparkTable2Flink(ObjectPath tablePath, org.apache.hadoop.hive.metastore.api.Table hiveTable) {
        if (!this.isFlinkHoodieTable(hiveTable)) {
            try {
                Map parameters = hiveTable.getParameters();
                parameters.putAll(TableOptionProperties.translateSparkTableProperties2Flink(hiveTable));
                String path = hiveTable.getSd().getLocation();
                parameters.put(FlinkOptions.PATH.key(), path);
                if (!parameters.containsKey(FlinkOptions.HIVE_STYLE_PARTITIONING.key())) {
                    Path hoodieTablePath = new Path(path);
                    boolean hiveStyle = Arrays.stream(FSUtils.getFs(hoodieTablePath, (org.apache.hadoop.conf.Configuration)this.hiveConf).listStatus(hoodieTablePath)).map(fileStatus -> fileStatus.getPath().getName()).filter(f -> !f.equals(".hoodie") && !f.equals("default")).anyMatch(FilePathUtils::isHiveStylePartitioning);
                    parameters.put(FlinkOptions.HIVE_STYLE_PARTITIONING.key(), String.valueOf(hiveStyle));
                }
                this.client.alter_table(tablePath.getDatabaseName(), tablePath.getObjectName(), hiveTable);
            }
            catch (Exception e) {
                throw new HoodieCatalogException("Failed to update table schema", e);
            }
        }
        return hiveTable;
    }

    public CatalogBaseTable getTable(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        org.apache.flink.table.api.Schema schema;
        Preconditions.checkNotNull((Object)tablePath, (String)"Table path cannot be null");
        org.apache.hadoop.hive.metastore.api.Table hiveTable = this.translateSparkTable2Flink(tablePath, this.getHiveTable(tablePath));
        String path = hiveTable.getSd().getLocation();
        Map parameters = hiveTable.getParameters();
        Schema latestTableSchema = StreamerUtil.getLatestTableSchema(path, (org.apache.hadoop.conf.Configuration)this.hiveConf);
        if (latestTableSchema != null) {
            Schema.Builder builder = org.apache.flink.table.api.Schema.newBuilder().fromRowDataType(AvroSchemaConverter.convertToDataType(latestTableSchema));
            String pkConstraintName = (String)parameters.get("pk.constraint.name");
            String pkColumns = (String)parameters.get(FlinkOptions.RECORD_KEY_FIELD.key());
            if (!StringUtils.isNullOrEmpty(pkConstraintName)) {
                builder.primaryKeyNamed(pkConstraintName, StringUtils.split(pkColumns, ","));
            } else if (pkColumns != null) {
                builder.primaryKey(StringUtils.split(pkColumns, ","));
            }
            schema = builder.build();
        } else {
            LOG.warn("{} does not have any hoodie schema, and use hive table schema to infer the table schema", (Object)tablePath);
            schema = HiveSchemaUtils.convertTableSchema(hiveTable);
        }
        Map<String, String> options = this.supplementOptions(tablePath, parameters);
        return CatalogTable.of((org.apache.flink.table.api.Schema)schema, (String)((String)parameters.get("comment")), HiveSchemaUtils.getFieldNames(hiveTable.getPartitionKeys()), options);
    }

    public void createTable(ObjectPath tablePath, CatalogBaseTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"Table path cannot be null");
        Preconditions.checkNotNull((Object)table, (String)"Table cannot be null");
        if (!this.databaseExists(tablePath.getDatabaseName())) {
            throw new DatabaseNotExistException(this.getName(), tablePath.getDatabaseName());
        }
        if (!table.getOptions().getOrDefault(FactoryUtil.CONNECTOR.key(), "").equalsIgnoreCase("hudi")) {
            throw new HoodieCatalogException(String.format("The %s is not hoodie table", tablePath.getObjectName()));
        }
        if (table instanceof CatalogView) {
            throw new HoodieCatalogException("CREATE VIEW is not supported.");
        }
        try {
            boolean isMorTable = OptionsResolver.isMorTable(table.getOptions());
            org.apache.hadoop.hive.metastore.api.Table hiveTable = this.instantiateHiveTable(tablePath, table, this.inferTablePath(tablePath, table), isMorTable);
            this.client.createTable(hiveTable);
            this.initTableIfNotExists(tablePath, (CatalogTable)table);
        }
        catch (AlreadyExistsException e) {
            if (!ignoreIfExists) {
                throw new TableAlreadyExistException(this.getName(), tablePath, (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new HoodieCatalogException(String.format("Failed to create table %s", tablePath.getFullName()), e);
        }
    }

    private void initTableIfNotExists(ObjectPath tablePath, CatalogTable catalogTable) {
        Configuration flinkConf = Configuration.fromMap((Map)catalogTable.getOptions());
        String avroSchema = AvroSchemaConverter.convertToSchema(catalogTable.getSchema().toPersistedRowDataType().getLogicalType()).toString();
        flinkConf.setString(FlinkOptions.SOURCE_AVRO_SCHEMA, avroSchema);
        if (catalogTable.getUnresolvedSchema().getPrimaryKey().isPresent() && !flinkConf.contains(FlinkOptions.RECORD_KEY_FIELD)) {
            String pkColumns = String.join((CharSequence)",", ((Schema.UnresolvedPrimaryKey)catalogTable.getUnresolvedSchema().getPrimaryKey().get()).getColumnNames());
            flinkConf.setString(FlinkOptions.RECORD_KEY_FIELD, pkColumns);
        }
        if (catalogTable.isPartitioned() && !flinkConf.contains(FlinkOptions.PARTITION_PATH_FIELD)) {
            String partitions = String.join((CharSequence)",", catalogTable.getPartitionKeys());
            flinkConf.setString(FlinkOptions.PARTITION_PATH_FIELD, partitions);
        }
        if (!flinkConf.getOptional(FlinkOptions.PATH).isPresent()) {
            flinkConf.setString(FlinkOptions.PATH, this.inferTablePath(tablePath, (CatalogBaseTable)catalogTable));
        }
        flinkConf.setString(FlinkOptions.TABLE_NAME, tablePath.getObjectName());
        try {
            StreamerUtil.initTableIfNotExists(flinkConf, (org.apache.hadoop.conf.Configuration)this.hiveConf);
        }
        catch (IOException e) {
            throw new HoodieCatalogException("Initialize table exception.", e);
        }
    }

    private String inferTablePath(ObjectPath tablePath, CatalogBaseTable table) {
        String location = table.getOptions().getOrDefault(FlinkOptions.PATH.key(), "");
        if (StringUtils.isNullOrEmpty(location)) {
            try {
                Path dbLocation = new Path(this.client.getDatabase(tablePath.getDatabaseName()).getLocationUri());
                location = new Path(dbLocation, tablePath.getObjectName()).toString();
            }
            catch (TException e) {
                throw new HoodieCatalogException(String.format("Failed to infer hoodie table path for table %s", tablePath), e);
            }
        }
        return location;
    }

    private org.apache.hadoop.hive.metastore.api.Table instantiateHiveTable(ObjectPath tablePath, CatalogBaseTable table, String location, boolean useRealTimeInputFormat) throws IOException {
        org.apache.hadoop.hive.metastore.api.Table hiveTable = Table.getEmptyTable((String)tablePath.getDatabaseName(), (String)tablePath.getObjectName());
        hiveTable.setOwner(UserGroupInformation.getCurrentUser().getUserName());
        hiveTable.setCreateTime((int)(System.currentTimeMillis() / 1000L));
        HashMap<String, String> properties = new HashMap<String, String>(table.getOptions());
        if (Boolean.parseBoolean((String)table.getOptions().get(CatalogOptions.TABLE_EXTERNAL.key()))) {
            hiveTable.setTableType(TableType.EXTERNAL_TABLE.toString());
            properties.put("EXTERNAL", "TRUE");
        }
        if (table.getComment() != null) {
            properties.put("comment", table.getComment());
        }
        if (table.getUnresolvedSchema().getPrimaryKey().isPresent() && !properties.containsKey(FlinkOptions.RECORD_KEY_FIELD.key())) {
            String pkColumns = String.join((CharSequence)",", ((Schema.UnresolvedPrimaryKey)table.getUnresolvedSchema().getPrimaryKey().get()).getColumnNames());
            properties.put("pk.constraint.name", ((Schema.UnresolvedPrimaryKey)table.getUnresolvedSchema().getPrimaryKey().get()).getConstraintName());
            properties.put(FlinkOptions.RECORD_KEY_FIELD.key(), pkColumns);
        }
        if (!properties.containsKey(FlinkOptions.PATH.key())) {
            properties.put(FlinkOptions.PATH.key(), location);
        }
        StorageDescriptor sd = new StorageDescriptor();
        List<FieldSchema> allColumns = HiveSchemaUtils.createHiveColumns(table.getSchema());
        CatalogTable catalogTable = (CatalogTable)table;
        List<String> partitionKeys = HoodieCatalogUtil.getPartitionKeys(catalogTable);
        if (partitionKeys.size() > 0) {
            Pair<List<FieldSchema>, List<FieldSchema>> splitSchemas = HiveSchemaUtils.splitSchemaByPartitionKeys(allColumns, partitionKeys);
            List<FieldSchema> regularColumns = splitSchemas.getLeft();
            List<FieldSchema> partitionColumns = splitSchemas.getRight();
            sd.setCols(regularColumns);
            hiveTable.setPartitionKeys(partitionColumns);
        } else {
            sd.setCols(allColumns);
            hiveTable.setPartitionKeys(Collections.emptyList());
        }
        HoodieFileFormat baseFileFormat = HoodieFileFormat.PARQUET;
        String inputFormatClassName = HoodieInputFormatUtils.getInputFormatClassName(baseFileFormat, useRealTimeInputFormat);
        String outputFormatClassName = HoodieInputFormatUtils.getOutputFormatClassName(baseFileFormat);
        String serDeClassName = HoodieInputFormatUtils.getSerDeClassName(baseFileFormat);
        sd.setInputFormat(inputFormatClassName);
        sd.setOutputFormat(outputFormatClassName);
        HashMap<String, String> serdeProperties = new HashMap<String, String>();
        serdeProperties.put("path", location);
        serdeProperties.put("hoodie.query.as.ro.table", String.valueOf(!useRealTimeInputFormat));
        serdeProperties.put("serialization.format", "1");
        serdeProperties.putAll(TableOptionProperties.translateFlinkTableProperties2Spark(catalogTable, (org.apache.hadoop.conf.Configuration)this.hiveConf, properties, partitionKeys));
        sd.setSerdeInfo(new SerDeInfo(null, serDeClassName, serdeProperties));
        sd.setLocation(location);
        hiveTable.setSd(sd);
        hiveTable.setParameters(properties);
        return hiveTable;
    }

    public List<String> listTables(String databaseName) throws DatabaseNotExistException, CatalogException {
        Preconditions.checkArgument((!org.apache.flink.util.StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0, (Object)"Database name cannot be null or empty");
        try {
            return this.client.getAllTables(databaseName);
        }
        catch (UnknownDBException e) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        catch (TException e) {
            throw new HoodieCatalogException(String.format("Failed to list tables in database %s", databaseName), e);
        }
    }

    public List<String> listViews(String databaseName) throws DatabaseNotExistException, CatalogException {
        throw new HoodieCatalogException("Hoodie catalog does not support to listViews");
    }

    public boolean tableExists(ObjectPath tablePath) throws CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"Table path cannot be null");
        try {
            return this.client.tableExists(tablePath.getDatabaseName(), tablePath.getObjectName());
        }
        catch (UnknownDBException e) {
            return false;
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to check whether table %s exists or not.", tablePath.getFullName()), (Throwable)e);
        }
    }

    public void dropTable(ObjectPath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"Table path cannot be null");
        try {
            this.client.dropTable(tablePath.getDatabaseName(), tablePath.getObjectName(), true, ignoreIfNotExists);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreIfNotExists) {
                throw new TableNotExistException(this.getName(), tablePath);
            }
        }
        catch (TException e) {
            throw new HoodieCatalogException(String.format("Failed to drop table %s", tablePath.getFullName()), e);
        }
    }

    public void renameTable(ObjectPath tablePath, String newTableName, boolean ignoreIfNotExists) throws TableNotExistException, TableAlreadyExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"Table path cannot be null");
        Preconditions.checkArgument((!org.apache.flink.util.StringUtils.isNullOrWhitespaceOnly((String)newTableName) ? 1 : 0) != 0, (Object)"New table name cannot be null or empty");
        try {
            if (this.tableExists(tablePath)) {
                ObjectPath newPath = new ObjectPath(tablePath.getDatabaseName(), newTableName);
                if (this.tableExists(newPath)) {
                    throw new TableAlreadyExistException(this.getName(), newPath);
                }
                org.apache.hadoop.hive.metastore.api.Table hiveTable = this.getHiveTable(tablePath);
                StorageDescriptor sd = hiveTable.getSd();
                String location = sd.getLocation();
                HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(location).setConf((org.apache.hadoop.conf.Configuration)this.hiveConf).build();
                HoodieTableMetaClient.withPropertyBuilder().fromProperties(metaClient.getTableConfig().getProps()).setTableName(newTableName).initTable((org.apache.hadoop.conf.Configuration)this.hiveConf, location);
                hiveTable.setTableName(newTableName);
                this.client.alter_table(tablePath.getDatabaseName(), tablePath.getObjectName(), hiveTable);
            } else if (!ignoreIfNotExists) {
                throw new TableNotExistException(this.getName(), tablePath);
            }
        }
        catch (Exception e) {
            throw new HoodieCatalogException(String.format("Failed to rename table %s", tablePath.getFullName()), e);
        }
    }

    private boolean sameOptions(Map<String, String> existingOptions, Map<String, String> newOptions, ConfigOption option) {
        return existingOptions.getOrDefault(option.key(), String.valueOf(option.defaultValue())).equalsIgnoreCase(newOptions.getOrDefault(option.key(), String.valueOf(option.defaultValue())));
    }

    public void alterTable(ObjectPath tablePath, CatalogBaseTable newCatalogTable, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"Table path cannot be null");
        Preconditions.checkNotNull((Object)newCatalogTable, (String)"New catalog table cannot be null");
        if (!newCatalogTable.getOptions().getOrDefault(FactoryUtil.CONNECTOR.key(), "").equalsIgnoreCase("hudi")) {
            throw new HoodieCatalogException(String.format("The %s is not hoodie table", tablePath.getObjectName()));
        }
        if (newCatalogTable instanceof CatalogView) {
            throw new HoodieCatalogException("Hoodie catalog does not support to ALTER VIEW");
        }
        try {
            org.apache.hadoop.hive.metastore.api.Table hiveTable = this.getHiveTable(tablePath);
            if (!this.sameOptions(hiveTable.getParameters(), newCatalogTable.getOptions(), FlinkOptions.TABLE_TYPE) || !this.sameOptions(hiveTable.getParameters(), newCatalogTable.getOptions(), FlinkOptions.INDEX_TYPE)) {
                throw new HoodieCatalogException("Hoodie catalog does not support to alter table type and index type");
            }
        }
        catch (TableNotExistException e) {
            if (!ignoreIfNotExists) {
                throw e;
            }
            return;
        }
        try {
            boolean isMorTable = OptionsResolver.isMorTable(newCatalogTable.getOptions());
            org.apache.hadoop.hive.metastore.api.Table hiveTable = this.instantiateHiveTable(tablePath, newCatalogTable, this.inferTablePath(tablePath, newCatalogTable), isMorTable);
            this.client.alter_table(tablePath.getDatabaseName(), tablePath.getObjectName(), hiveTable);
        }
        catch (Exception e) {
            LOG.error("Failed to alter table {}", (Object)tablePath.getObjectName(), (Object)e);
            throw new HoodieCatalogException(String.format("Failed to alter table %s", tablePath.getObjectName()), e);
        }
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        throw new HoodieCatalogException("Not supported.");
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, CatalogException {
        throw new HoodieCatalogException("Not supported.");
    }

    public List<CatalogPartitionSpec> listPartitionsByFilter(ObjectPath tablePath, List<Expression> expressions) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        throw new HoodieCatalogException("Not supported.");
    }

    public CatalogPartition getPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        throw new HoodieCatalogException("Not supported.");
    }

    public boolean partitionExists(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        throw new HoodieCatalogException("Not supported.");
    }

    public void createPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition partition, boolean ignoreIfExists) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, PartitionAlreadyExistsException, CatalogException {
        throw new HoodieCatalogException("Not supported.");
    }

    public void dropPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        throw new HoodieCatalogException("Not supported.");
    }

    public void alterPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition newPartition, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        throw new HoodieCatalogException("Not supported.");
    }

    public List<String> listFunctions(String databaseName) throws DatabaseNotExistException, CatalogException {
        return Collections.emptyList();
    }

    public CatalogFunction getFunction(ObjectPath functionPath) throws FunctionNotExistException, CatalogException {
        throw new FunctionNotExistException(this.getName(), functionPath);
    }

    public boolean functionExists(ObjectPath functionPath) throws CatalogException {
        return false;
    }

    public void createFunction(ObjectPath functionPath, CatalogFunction function, boolean ignoreIfExists) throws FunctionAlreadyExistException, DatabaseNotExistException, CatalogException {
        throw new HoodieCatalogException("Not supported.");
    }

    public void alterFunction(ObjectPath functionPath, CatalogFunction newFunction, boolean ignoreIfNotExists) throws FunctionNotExistException, CatalogException {
        throw new HoodieCatalogException("Not supported.");
    }

    public void dropFunction(ObjectPath functionPath, boolean ignoreIfNotExists) throws FunctionNotExistException, CatalogException {
        throw new HoodieCatalogException("Not supported.");
    }

    public CatalogTableStatistics getTableStatistics(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        return CatalogTableStatistics.UNKNOWN;
    }

    public CatalogColumnStatistics getTableColumnStatistics(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        return CatalogColumnStatistics.UNKNOWN;
    }

    public CatalogTableStatistics getPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        return CatalogTableStatistics.UNKNOWN;
    }

    public CatalogColumnStatistics getPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        return CatalogColumnStatistics.UNKNOWN;
    }

    public void alterTableStatistics(ObjectPath tablePath, CatalogTableStatistics tableStatistics, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        throw new HoodieCatalogException("Not supported.");
    }

    public void alterTableColumnStatistics(ObjectPath tablePath, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException, TablePartitionedException {
        throw new HoodieCatalogException("Not supported.");
    }

    public void alterPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogTableStatistics partitionStatistics, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        throw new HoodieCatalogException("Not supported.");
    }

    public void alterPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        throw new HoodieCatalogException("Not supported.");
    }

    private Map<String, String> supplementOptions(ObjectPath tablePath, Map<String, String> options) {
        if (HoodieCatalogUtil.isEmbeddedMetastore(this.hiveConf)) {
            return options;
        }
        HashMap<String, String> newOptions = new HashMap<String, String>(options);
        newOptions.put(FlinkOptions.HIVE_SYNC_ENABLED.key(), "true");
        newOptions.put(FlinkOptions.HIVE_SYNC_METASTORE_URIS.key(), this.hiveConf.getVar(HiveConf.ConfVars.METASTOREURIS));
        newOptions.put(FlinkOptions.HIVE_SYNC_MODE.key(), "hms");
        newOptions.putIfAbsent(FlinkOptions.HIVE_SYNC_SUPPORT_TIMESTAMP.key(), "true");
        newOptions.computeIfAbsent(FlinkOptions.HIVE_SYNC_DB.key(), k -> tablePath.getDatabaseName());
        newOptions.computeIfAbsent(FlinkOptions.HIVE_SYNC_TABLE.key(), k -> tablePath.getObjectName());
        return newOptions;
    }
}

