/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.client.transaction.TransactionManager;
import org.apache.hudi.client.transaction.lock.LockManager;
import org.apache.hudi.client.transaction.lock.ZookeeperBasedLockProvider;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieNotSupportedException;

public class DirectMarkerTransactionManager
extends TransactionManager {
    private final String filePath;

    public DirectMarkerTransactionManager(HoodieWriteConfig config, FileSystem fs, String partitionPath, String fileId) {
        super(new LockManager(config, fs, DirectMarkerTransactionManager.createUpdatedLockProps(config, partitionPath, fileId)), config.isLockRequired());
        this.filePath = partitionPath + "/" + fileId;
    }

    public void beginTransaction(String newTxnOwnerInstantTime) {
        if (this.isLockRequired) {
            LOG.info((Object)("Transaction starting for " + newTxnOwnerInstantTime + " and " + this.filePath));
            this.lockManager.lock();
            this.reset(this.currentTxnOwnerInstant, Option.of(this.getInstant(newTxnOwnerInstantTime)), Option.empty());
            LOG.info((Object)("Transaction started for " + newTxnOwnerInstantTime + " and " + this.filePath));
        }
    }

    public void endTransaction(String currentTxnOwnerInstantTime) {
        if (this.isLockRequired) {
            LOG.info((Object)("Transaction ending with transaction owner " + currentTxnOwnerInstantTime + " for " + this.filePath));
            if (this.reset(Option.of(this.getInstant(currentTxnOwnerInstantTime)), Option.empty(), Option.empty())) {
                this.lockManager.unlock();
                LOG.info((Object)("Transaction ended with transaction owner " + currentTxnOwnerInstantTime + " for " + this.filePath));
            }
        }
    }

    private static TypedProperties createUpdatedLockProps(HoodieWriteConfig writeConfig, String partitionPath, String fileId) {
        if (!ZookeeperBasedLockProvider.class.getName().equals(writeConfig.getLockProviderClass())) {
            throw new HoodieNotSupportedException("Only Support ZK-based lock for DirectMarkerTransactionManager now.");
        }
        TypedProperties props = new TypedProperties(writeConfig.getProps());
        props.setProperty("hoodie.write.lock.zookeeper.lock_key", partitionPath + "/" + fileId);
        return props;
    }

    private HoodieInstant getInstant(String instantTime) {
        return new HoodieInstant(HoodieInstant.State.INFLIGHT, "", instantTime);
    }
}

