/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.TypeUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;

public class HoodieAvroRecordMerger
implements HoodieRecordMerger {
    @Override
    public String getMergingStrategy() {
        return "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5";
    }

    @Override
    public Option<Pair<HoodieRecord, Schema>> merge(HoodieRecord older, Schema oldSchema, HoodieRecord newer, Schema newSchema, TypedProperties props) throws IOException {
        ValidationUtils.checkArgument(older.getRecordType() == HoodieRecord.HoodieRecordType.AVRO);
        ValidationUtils.checkArgument(newer.getRecordType() == HoodieRecord.HoodieRecordType.AVRO);
        Config.LegacyOperationMode legacyOperatingMode = Config.LegacyOperationMode.valueOf(props.getString(Config.LEGACY_OPERATING_MODE.key(), Config.LEGACY_OPERATING_MODE.defaultValue()));
        switch (legacyOperatingMode) {
            case PRE_COMBINING: {
                HoodieRecord res = this.preCombine(older, newer, newSchema, props);
                if (res == older) {
                    return Option.of(Pair.of(res, oldSchema));
                }
                return Option.of(Pair.of(res, newSchema));
            }
            case COMBINING: {
                return this.combineAndGetUpdateValue(older, newer, newSchema, props).map(r -> Pair.of(r, ((IndexedRecord)((HoodieAvroIndexedRecord)r).getData()).getSchema()));
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported legacy operating mode (%s)", new Object[]{legacyOperatingMode}));
    }

    @Override
    public HoodieRecord.HoodieRecordType getRecordType() {
        return HoodieRecord.HoodieRecordType.AVRO;
    }

    private HoodieRecord preCombine(HoodieRecord older, HoodieRecord newer, Schema schema, Properties props) {
        HoodieRecordPayload payload = (HoodieRecordPayload)TypeUtils.unsafeCast(((HoodieAvroRecord)newer).getData().preCombine(((HoodieAvroRecord)older).getData(), schema, props));
        return new HoodieAvroRecord<HoodieRecordPayload>(newer.getKey(), payload, newer.getOperation());
    }

    private Option<HoodieRecord> combineAndGetUpdateValue(HoodieRecord older, HoodieRecord newer, Schema schema, Properties props) throws IOException {
        Option<IndexedRecord> previousAvroData = older.toIndexedRecord(schema, props).map(HoodieRecord::getData);
        if (!previousAvroData.isPresent()) {
            return Option.empty();
        }
        return ((HoodieAvroRecord)newer).getData().combineAndGetUpdateValue(previousAvroData.get(), schema, props).map(combinedAvroPayload -> new HoodieAvroIndexedRecord((IndexedRecord)combinedAvroPayload));
    }

    public static class Config {
        public static ConfigProperty<String> LEGACY_OPERATING_MODE = ConfigProperty.key("hoodie.datasource.write.record.merger.legacy.operation").defaultValue(LegacyOperationMode.COMBINING.name()).withDocumentation("Controls the mode of the merging operation performed by `HoodieAvroRecordMerger`. This is required to maintain backward-compatibility w/ the existing semantic of `HoodieRecordPayload` implementations providing `preCombine` and `combineAndGetUpdateValue` methods.");

        public static TypedProperties withLegacyOperatingModePreCombining(Properties props) {
            TypedProperties newProps = new TypedProperties();
            newProps.putAll((Map<?, ?>)props);
            newProps.setProperty(LEGACY_OPERATING_MODE.key(), LegacyOperationMode.PRE_COMBINING.name());
            return newProps;
        }

        public static enum LegacyOperationMode {
            PRE_COMBINING,
            COMBINING;

        }
    }
}

