/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.util.Locale;
import org.apache.hudi.exception.HoodieException;

public enum WriteConcurrencyMode {
    SINGLE_WRITER("single_writer"),
    OPTIMISTIC_CONCURRENCY_CONTROL("optimistic_concurrency_control");

    private final String value;

    private WriteConcurrencyMode(String value) {
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public static WriteConcurrencyMode fromValue(String value) {
        switch (value.toLowerCase(Locale.ROOT)) {
            case "single_writer": {
                return SINGLE_WRITER;
            }
            case "optimistic_concurrency_control": {
                return OPTIMISTIC_CONCURRENCY_CONTROL;
            }
        }
        throw new HoodieException("Invalid value of Type.");
    }

    public boolean supportsOptimisticConcurrencyControl() {
        return this == OPTIMISTIC_CONCURRENCY_CONTROL;
    }
}

