/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.model.HoodieAvroRecordMerger;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.table.log.InstantRange;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.org.apache.avro.Schema;

@ThreadSafe
public class HoodieMetadataLogRecordReader
implements Closeable {
    private final HoodieMergedLogRecordScanner logRecordScanner;

    private HoodieMetadataLogRecordReader(HoodieMergedLogRecordScanner logRecordScanner) {
        this.logRecordScanner = logRecordScanner;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HoodieRecord<HoodieMetadataPayload>> getRecords() {
        HoodieMetadataLogRecordReader hoodieMetadataLogRecordReader = this;
        synchronized (hoodieMetadataLogRecordReader) {
            this.logRecordScanner.scan();
            return this.logRecordScanner.getRecords().values().stream().map(record -> record).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HoodieRecord<HoodieMetadataPayload>> getRecordsByKeyPrefixes(List<String> keyPrefixes) {
        if (keyPrefixes.isEmpty()) {
            return Collections.emptyList();
        }
        HoodieMetadataLogRecordReader hoodieMetadataLogRecordReader = this;
        synchronized (hoodieMetadataLogRecordReader) {
            this.logRecordScanner.scanByKeyPrefixes(keyPrefixes);
            Map<String, HoodieRecord> allRecords = this.logRecordScanner.getRecords();
            Predicate<String> p = HoodieMetadataLogRecordReader.createPrefixMatchingPredicate(keyPrefixes);
            return allRecords.entrySet().stream().filter(r -> r != null && p.test((String)r.getKey())).map(r -> (HoodieRecord)r.getValue()).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HoodieRecord<HoodieMetadataPayload>> getRecordsByKeys(List<String> keys2) {
        if (keys2.isEmpty()) {
            return Collections.emptyList();
        }
        HoodieMetadataLogRecordReader hoodieMetadataLogRecordReader = this;
        synchronized (hoodieMetadataLogRecordReader) {
            this.logRecordScanner.scanByFullKeys(keys2);
            Map<String, HoodieRecord> allRecords = this.logRecordScanner.getRecords();
            return keys2.stream().map(key -> (HoodieRecord)allRecords.get(key)).filter(Objects::nonNull).collect(Collectors.toList());
        }
    }

    @Override
    public void close() throws IOException {
        this.logRecordScanner.close();
    }

    private static Predicate<String> createPrefixMatchingPredicate(List<String> keyPrefixes) {
        if (keyPrefixes.size() == 1) {
            String keyPrefix = keyPrefixes.get(0);
            return key -> key.startsWith(keyPrefix);
        }
        return key -> keyPrefixes.stream().anyMatch(key::startsWith);
    }

    private static class ExplicitMatchRange
    extends InstantRange {
        Set<String> instants;

        public ExplicitMatchRange(Set<String> instants) {
            super(Collections.min(instants), Collections.max(instants));
            this.instants = instants;
        }

        @Override
        public boolean isInRange(String instant) {
            return this.instants.contains(instant);
        }
    }

    public static class Builder {
        private final HoodieMergedLogRecordScanner.Builder scannerBuilder = new HoodieMergedLogRecordScanner.Builder().withKeyFiledOverride("key").withRecordMerger(new HoodieAvroRecordMerger()).withReadBlocksLazily(true).withReverseReader(false).withOperationField(false);

        public Builder withFileSystem(FileSystem fs) {
            this.scannerBuilder.withFileSystem(fs);
            return this;
        }

        public Builder withBasePath(String basePath) {
            this.scannerBuilder.withBasePath(basePath);
            return this;
        }

        public Builder withLogFilePaths(List<String> logFilePaths) {
            this.scannerBuilder.withLogFilePaths((List)logFilePaths);
            return this;
        }

        public Builder withReaderSchema(Schema schema) {
            this.scannerBuilder.withReaderSchema(schema);
            return this;
        }

        public Builder withLatestInstantTime(String latestInstantTime) {
            this.scannerBuilder.withLatestInstantTime(latestInstantTime);
            return this;
        }

        public Builder withBufferSize(int bufferSize) {
            this.scannerBuilder.withBufferSize(bufferSize);
            return this;
        }

        public Builder withPartition(String partitionName) {
            this.scannerBuilder.withPartition(partitionName);
            return this;
        }

        public Builder withMaxMemorySizeInBytes(Long maxMemorySizeInBytes) {
            this.scannerBuilder.withMaxMemorySizeInBytes(maxMemorySizeInBytes);
            return this;
        }

        public Builder withSpillableMapBasePath(String spillableMapBasePath) {
            this.scannerBuilder.withSpillableMapBasePath(spillableMapBasePath);
            return this;
        }

        public Builder withDiskMapType(ExternalSpillableMap.DiskMapType diskMapType) {
            this.scannerBuilder.withDiskMapType(diskMapType);
            return this;
        }

        public Builder withBitCaskDiskMapCompressionEnabled(boolean isBitCaskDiskMapCompressionEnabled) {
            this.scannerBuilder.withBitCaskDiskMapCompressionEnabled(isBitCaskDiskMapCompressionEnabled);
            return this;
        }

        public Builder withLogBlockTimestamps(Set<String> validLogBlockTimestamps) {
            this.scannerBuilder.withInstantRange(Option.of(new ExplicitMatchRange(validLogBlockTimestamps)));
            return this;
        }

        public Builder enableFullScan(boolean enableFullScan) {
            this.scannerBuilder.withForceFullScan(enableFullScan);
            return this;
        }

        public Builder withEnableOptimizedLogBlocksScan(boolean enableOptimizedLogBlocksScan) {
            this.scannerBuilder.withOptimizedLogBlocksScan(enableOptimizedLogBlocksScan);
            return this;
        }

        public HoodieMetadataLogRecordReader build() {
            return new HoodieMetadataLogRecordReader(this.scannerBuilder.build());
        }
    }
}

