/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.org.apache.hadoop.hbase.Abortable;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.wal.WALCoprocessorHost;
import org.apache.hudi.org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hudi.org.apache.hadoop.hbase.wal.WAL;
import org.apache.hudi.org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hudi.org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hudi.org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hudi.org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class DisabledWALProvider
implements WALProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DisabledWALProvider.class);
    WAL disabled;

    DisabledWALProvider() {
    }

    @Override
    public void init(WALFactory factory, Configuration conf, String providerId, Abortable abortable) throws IOException {
        if (null != this.disabled) {
            throw new IllegalStateException("WALProvider.init should only be called once.");
        }
        if (null == providerId) {
            providerId = "defaultDisabled";
        }
        this.disabled = new DisabledWAL(new Path(CommonFSUtils.getWALRootDir(conf), providerId), conf, null);
    }

    @Override
    public List<WAL> getWALs() {
        ArrayList<WAL> wals = new ArrayList<WAL>(1);
        wals.add(this.disabled);
        return wals;
    }

    @Override
    public WAL getWAL(RegionInfo region) throws IOException {
        return this.disabled;
    }

    @Override
    public void close() throws IOException {
        this.disabled.close();
    }

    @Override
    public void shutdown() throws IOException {
        this.disabled.shutdown();
    }

    @Override
    public long getNumLogFiles() {
        return 0L;
    }

    @Override
    public long getLogFileSize() {
        return 0L;
    }

    @Override
    public void addWALActionsListener(WALActionsListener listener) {
        this.disabled.registerWALActionsListener(listener);
    }

    private static class DisabledWAL
    implements WAL {
        protected final List<WALActionsListener> listeners = new CopyOnWriteArrayList<WALActionsListener>();
        protected final Path path;
        protected final WALCoprocessorHost coprocessorHost;
        protected final AtomicBoolean closed = new AtomicBoolean(false);

        public DisabledWAL(Path path, Configuration conf, List<WALActionsListener> listeners) {
            this.coprocessorHost = new WALCoprocessorHost(this, conf);
            this.path = path;
            if (null != listeners) {
                for (WALActionsListener listener : listeners) {
                    this.registerWALActionsListener(listener);
                }
            }
        }

        @Override
        public void registerWALActionsListener(WALActionsListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public boolean unregisterWALActionsListener(WALActionsListener listener) {
            return this.listeners.remove(listener);
        }

        @Override
        public Map<byte[], List<byte[]>> rollWriter() {
            if (!this.listeners.isEmpty()) {
                for (WALActionsListener listener : this.listeners) {
                    listener.logRollRequested(WALActionsListener.RollRequestReason.ERROR);
                }
                for (WALActionsListener listener : this.listeners) {
                    try {
                        listener.preLogRoll(this.path, this.path);
                    }
                    catch (IOException exception) {
                        LOG.debug("Ignoring exception from listener.", (Throwable)exception);
                    }
                }
                for (WALActionsListener listener : this.listeners) {
                    try {
                        listener.postLogRoll(this.path, this.path);
                    }
                    catch (IOException exception) {
                        LOG.debug("Ignoring exception from listener.", (Throwable)exception);
                    }
                }
            }
            return null;
        }

        @Override
        public Map<byte[], List<byte[]>> rollWriter(boolean force) {
            return this.rollWriter();
        }

        @Override
        public void shutdown() {
            if (this.closed.compareAndSet(false, true) && !this.listeners.isEmpty()) {
                for (WALActionsListener listener : this.listeners) {
                    listener.logCloseRequested();
                }
            }
        }

        @Override
        public void close() {
            this.shutdown();
        }

        @Override
        public long appendData(RegionInfo info, WALKeyImpl key, WALEdit edits) throws IOException {
            return this.append(info, key, edits, true);
        }

        @Override
        public long appendMarker(RegionInfo info, WALKeyImpl key, WALEdit edits) throws IOException {
            return this.append(info, key, edits, false);
        }

        private long append(RegionInfo info, WALKeyImpl key, WALEdit edits, boolean inMemstore) throws IOException {
            MultiVersionConcurrencyControl.WriteEntry writeEntry = key.getMvcc().begin();
            if (!edits.isReplay()) {
                for (Cell cell : edits.getCells()) {
                    PrivateCellUtil.setSequenceId(cell, writeEntry.getWriteNumber());
                }
            }
            key.setWriteEntry(writeEntry);
            if (!this.listeners.isEmpty()) {
                long start2 = System.nanoTime();
                long len = 0L;
                for (Cell cell : edits.getCells()) {
                    len += (long)PrivateCellUtil.estimatedSerializedSizeOf(cell);
                }
                long elapsed = (System.nanoTime() - start2) / 1000000L;
                for (WALActionsListener listener : this.listeners) {
                    listener.postAppend(len, elapsed, key, edits);
                }
            }
            return -1L;
        }

        @Override
        public void updateStore(byte[] encodedRegionName, byte[] familyName, Long sequenceid, boolean onlyIfGreater) {
        }

        @Override
        public void sync() {
            if (!this.listeners.isEmpty()) {
                for (WALActionsListener listener : this.listeners) {
                    listener.postSync(0L, 0);
                }
            }
        }

        @Override
        public void sync(long txid) {
            this.sync();
        }

        @Override
        public Long startCacheFlush(byte[] encodedRegionName, Map<byte[], Long> flushedFamilyNamesToSeq) {
            return this.startCacheFlush(encodedRegionName, flushedFamilyNamesToSeq.keySet());
        }

        @Override
        public Long startCacheFlush(byte[] encodedRegionName, Set<byte[]> flushedFamilyNames) {
            if (this.closed.get()) {
                return null;
            }
            return -1L;
        }

        @Override
        public void completeCacheFlush(byte[] encodedRegionName, long maxFlushedSeqId) {
        }

        @Override
        public void abortCacheFlush(byte[] encodedRegionName) {
        }

        @Override
        public WALCoprocessorHost getCoprocessorHost() {
            return this.coprocessorHost;
        }

        @Override
        public long getEarliestMemStoreSeqNum(byte[] encodedRegionName) {
            return -1L;
        }

        @Override
        public long getEarliestMemStoreSeqNum(byte[] encodedRegionName, byte[] familyName) {
            return -1L;
        }

        @Override
        public String toString() {
            return "WAL disabled.";
        }

        @Override
        public OptionalLong getLogFileSizeIfBeingWritten(Path path) {
            return OptionalLong.empty();
        }
    }
}

