/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.bulk;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.PartitionPathEncodeUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.configuration.OptionsResolver;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.keygen.TimestampBasedAvroKeyGenerator;
import org.apache.hudi.util.RowDataProjection;
import org.apache.hudi.util.StreamerUtil;

public class RowDataKeyGen
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String EMPTY_PARTITION = "";
    private static final String NULL_RECORDKEY_PLACEHOLDER = "__null__";
    private static final String EMPTY_RECORDKEY_PLACEHOLDER = "__empty__";
    private static final String DEFAULT_PARTITION_PATH_SEPARATOR = "/";
    private final boolean hasRecordKey;
    private final String[] recordKeyFields;
    private final String[] partitionPathFields;
    private final RowDataProjection recordKeyProjection;
    private final RowDataProjection partitionPathProjection;
    private final boolean hiveStylePartitioning;
    private final boolean encodePartitionPath;
    private final boolean consistentLogicalTimestampEnabled;
    private final Option<TimestampBasedAvroKeyGenerator> keyGenOpt;
    private boolean simpleRecordKey = false;
    private RowData.FieldGetter recordKeyFieldGetter;
    private boolean simplePartitionPath = false;
    private RowData.FieldGetter partitionPathFieldGetter;
    private boolean nonPartitioned;

    private RowDataKeyGen(String recordKeys, String partitionFields, RowType rowType, boolean hiveStylePartitioning, boolean encodePartitionPath, boolean consistentLogicalTimestampEnabled, Option<TimestampBasedAvroKeyGenerator> keyGenOpt) {
        this.recordKeyFields = recordKeys.split(",");
        this.partitionPathFields = partitionFields.split(",");
        List fieldNames = rowType.getFieldNames();
        List fieldTypes = rowType.getChildren();
        this.hiveStylePartitioning = hiveStylePartitioning;
        this.encodePartitionPath = encodePartitionPath;
        this.consistentLogicalTimestampEnabled = consistentLogicalTimestampEnabled;
        this.hasRecordKey = this.hasRecordKey(fieldNames);
        if (!this.hasRecordKey) {
            this.recordKeyProjection = null;
        } else if (this.recordKeyFields.length == 1) {
            this.simpleRecordKey = true;
            int recordKeyIdx = fieldNames.indexOf(this.recordKeyFields[0]);
            this.recordKeyFieldGetter = RowData.createFieldGetter((LogicalType)((LogicalType)fieldTypes.get(recordKeyIdx)), (int)recordKeyIdx);
            this.recordKeyProjection = null;
        } else {
            this.recordKeyProjection = RowDataKeyGen.getProjection(this.recordKeyFields, fieldNames, fieldTypes);
        }
        if (this.partitionPathFields.length == 1) {
            if (this.partitionPathFields[0].equals(EMPTY_PARTITION)) {
                this.nonPartitioned = true;
            } else {
                this.simplePartitionPath = true;
                int partitionPathIdx = fieldNames.indexOf(this.partitionPathFields[0]);
                this.partitionPathFieldGetter = RowData.createFieldGetter((LogicalType)((LogicalType)fieldTypes.get(partitionPathIdx)), (int)partitionPathIdx);
            }
            this.partitionPathProjection = null;
        } else {
            this.partitionPathProjection = RowDataKeyGen.getProjection(this.partitionPathFields, fieldNames, fieldTypes);
        }
        this.keyGenOpt = keyGenOpt;
    }

    private boolean hasRecordKey(List<String> fieldNames) {
        return this.recordKeyFields.length != 1 || fieldNames.contains(this.recordKeyFields[0]);
    }

    public static RowDataKeyGen instance(Configuration conf, RowType rowType) {
        Option<TimestampBasedAvroKeyGenerator> keyGeneratorOpt = Option.empty();
        if (TimestampBasedAvroKeyGenerator.class.getName().equals(conf.getString(FlinkOptions.KEYGEN_CLASS_NAME))) {
            try {
                keyGeneratorOpt = Option.of(new TimestampBasedAvroKeyGenerator(StreamerUtil.flinkConf2TypedProperties(conf)));
            }
            catch (IOException e) {
                throw new HoodieKeyException("Initialize TimestampBasedAvroKeyGenerator error", e);
            }
        }
        boolean consistentLogicalTimestampEnabled = OptionsResolver.isConsistentLogicalTimestampEnabled(conf);
        return new RowDataKeyGen(conf.getString(FlinkOptions.RECORD_KEY_FIELD), conf.getString(FlinkOptions.PARTITION_PATH_FIELD), rowType, conf.getBoolean(FlinkOptions.HIVE_STYLE_PARTITIONING), conf.getBoolean(FlinkOptions.URL_ENCODE_PARTITIONING), consistentLogicalTimestampEnabled, keyGeneratorOpt);
    }

    public HoodieKey getHoodieKey(RowData rowData) {
        return new HoodieKey(this.getRecordKey(rowData), this.getPartitionPath(rowData));
    }

    public String getRecordKey(RowData rowData) {
        if (!this.hasRecordKey) {
            return EMPTY_RECORDKEY_PLACEHOLDER;
        }
        if (this.simpleRecordKey) {
            return RowDataKeyGen.getRecordKey(this.recordKeyFieldGetter.getFieldOrNull(rowData), this.recordKeyFields[0], this.consistentLogicalTimestampEnabled);
        }
        Object[] keyValues = this.recordKeyProjection.projectAsValues(rowData);
        return RowDataKeyGen.getRecordKey(keyValues, this.recordKeyFields, this.consistentLogicalTimestampEnabled);
    }

    public String getPartitionPath(RowData rowData) {
        if (this.simplePartitionPath) {
            return RowDataKeyGen.getPartitionPath(this.partitionPathFieldGetter.getFieldOrNull(rowData), this.partitionPathFields[0], this.hiveStylePartitioning, this.encodePartitionPath, this.keyGenOpt);
        }
        if (this.nonPartitioned) {
            return EMPTY_PARTITION;
        }
        Object[] partValues = this.partitionPathProjection.projectAsValues(rowData);
        return RowDataKeyGen.getRecordPartitionPath(partValues, this.partitionPathFields, this.hiveStylePartitioning, this.encodePartitionPath);
    }

    private static String getRecordKey(Object[] keyValues, String[] keyFields, boolean consistentLogicalTimestampEnabled) {
        boolean keyIsNullEmpty = true;
        StringBuilder recordKey = new StringBuilder();
        for (int i = 0; i < keyValues.length; ++i) {
            String recordKeyField = keyFields[i];
            Object value = keyValues[i];
            String recordKeyValue = StringUtils.objToString(value = RowDataKeyGen.getTimestampValue(consistentLogicalTimestampEnabled, value));
            if (recordKeyValue == null) {
                recordKey.append(recordKeyField).append(":").append(NULL_RECORDKEY_PLACEHOLDER).append(",");
                continue;
            }
            if (recordKeyValue.isEmpty()) {
                recordKey.append(recordKeyField).append(":").append(EMPTY_RECORDKEY_PLACEHOLDER).append(",");
                continue;
            }
            recordKey.append(recordKeyField).append(":").append(recordKeyValue).append(",");
            keyIsNullEmpty = false;
        }
        recordKey.deleteCharAt(recordKey.length() - 1);
        if (keyIsNullEmpty) {
            throw new HoodieKeyException("recordKey values: \"" + recordKey + "\" for fields: " + Arrays.toString(keyFields) + " cannot be entirely null or empty.");
        }
        return recordKey.toString();
    }

    private static Object getTimestampValue(boolean consistentLogicalTimestampEnabled, Object value) {
        if (!consistentLogicalTimestampEnabled && value instanceof TimestampData) {
            TimestampData timestampData = (TimestampData)value;
            value = timestampData.toTimestamp().toInstant().toEpochMilli();
        }
        return value;
    }

    private static String getRecordPartitionPath(Object[] partValues, String[] partFields, boolean hiveStylePartitioning, boolean encodePartitionPath) {
        StringBuilder partitionPath = new StringBuilder();
        for (int i = 0; i < partFields.length; ++i) {
            String partField = partFields[i];
            String partValue = StringUtils.objToString(partValues[i]);
            if (partValue == null || partValue.isEmpty()) {
                partitionPath.append(hiveStylePartitioning ? partField + "=" + "__HIVE_DEFAULT_PARTITION__" : "__HIVE_DEFAULT_PARTITION__");
            } else {
                if (encodePartitionPath) {
                    partValue = PartitionPathEncodeUtils.escapePathName(partValue);
                }
                partitionPath.append(hiveStylePartitioning ? partField + "=" + partValue : partValue);
            }
            partitionPath.append(DEFAULT_PARTITION_PATH_SEPARATOR);
        }
        partitionPath.deleteCharAt(partitionPath.length() - 1);
        return partitionPath.toString();
    }

    public static String getRecordKey(Object recordKeyValue, String recordKeyField, boolean consistentLogicalTimestampEnabled) {
        String recordKey = StringUtils.objToString(recordKeyValue = RowDataKeyGen.getTimestampValue(consistentLogicalTimestampEnabled, recordKeyValue));
        if (recordKey == null || recordKey.isEmpty()) {
            throw new HoodieKeyException("recordKey value: \"" + recordKey + "\" for field: \"" + recordKeyField + "\" cannot be null or empty.");
        }
        return recordKey;
    }

    public static String getPartitionPath(Object partValue, String partField, boolean hiveStylePartitioning, boolean encodePartitionPath, Option<TimestampBasedAvroKeyGenerator> keyGenOpt) {
        if (keyGenOpt.isPresent()) {
            TimestampBasedAvroKeyGenerator keyGenerator = keyGenOpt.get();
            return keyGenerator.getPartitionPath(RowDataKeyGen.toEpochMilli(partValue, keyGenerator));
        }
        String partitionPath = StringUtils.objToString(partValue);
        if (partitionPath == null || partitionPath.isEmpty()) {
            partitionPath = "__HIVE_DEFAULT_PARTITION__";
        }
        if (encodePartitionPath) {
            partitionPath = PartitionPathEncodeUtils.escapePathName(partitionPath);
        }
        if (hiveStylePartitioning) {
            partitionPath = partField + "=" + partitionPath;
        }
        return partitionPath;
    }

    private static Object toEpochMilli(Object val, TimestampBasedAvroKeyGenerator keyGenerator) {
        if (val instanceof TimestampData) {
            return ((TimestampData)val).toInstant().toEpochMilli();
        }
        if (val == null) {
            return keyGenerator.getDefaultPartitionVal();
        }
        return val;
    }

    private static RowDataProjection getProjection(String[] fields, List<String> schemaFields, List<LogicalType> schemaTypes) {
        int[] positions = RowDataKeyGen.getFieldPositions(fields, schemaFields);
        LogicalType[] types = (LogicalType[])Arrays.stream(positions).mapToObj(schemaTypes::get).toArray(LogicalType[]::new);
        return RowDataProjection.instance(types, positions);
    }

    private static int[] getFieldPositions(String[] fields, List<String> allFields) {
        return Arrays.stream(fields).mapToInt(allFields::indexOf).toArray();
    }
}

