/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.logical.LogicalType;

public class ExpressionUtils {
    public static String[] referencedColumns(List<ResolvedExpression> exprs) {
        return (String[])exprs.stream().map(ExpressionUtils::getReferencedColumns).filter(columns -> ((String[])columns).length > 0).flatMap(Arrays::stream).distinct().toArray(String[]::new);
    }

    public static boolean isSimpleCallExpression(Expression expr) {
        if (!(expr instanceof CallExpression)) {
            return false;
        }
        CallExpression callExpression = (CallExpression)expr;
        FunctionDefinition funcDef = callExpression.getFunctionDefinition();
        if (funcDef == BuiltInFunctionDefinitions.NOT || funcDef == BuiltInFunctionDefinitions.AND || funcDef == BuiltInFunctionDefinitions.OR) {
            return callExpression.getChildren().stream().allMatch(ExpressionUtils::isSimpleCallExpression);
        }
        if (funcDef != BuiltInFunctionDefinitions.IN && funcDef != BuiltInFunctionDefinitions.EQUALS && funcDef != BuiltInFunctionDefinitions.NOT_EQUALS && funcDef != BuiltInFunctionDefinitions.IS_NULL && funcDef != BuiltInFunctionDefinitions.IS_NOT_NULL && funcDef != BuiltInFunctionDefinitions.LESS_THAN && funcDef != BuiltInFunctionDefinitions.GREATER_THAN && funcDef != BuiltInFunctionDefinitions.LESS_THAN_OR_EQUAL && funcDef != BuiltInFunctionDefinitions.GREATER_THAN_OR_EQUAL) {
            return false;
        }
        if (funcDef == BuiltInFunctionDefinitions.IN) {
            return true;
        }
        if (funcDef == BuiltInFunctionDefinitions.IS_NULL || funcDef == BuiltInFunctionDefinitions.IS_NOT_NULL) {
            return callExpression.getChildren().stream().allMatch(e -> e instanceof FieldReferenceExpression);
        }
        return ExpressionUtils.isFieldReferenceAndLiteral(callExpression.getChildren());
    }

    private static boolean isFieldReferenceAndLiteral(List<Expression> exprs) {
        if (exprs.size() != 2) {
            return false;
        }
        Expression expr0 = exprs.get(0);
        Expression expr1 = exprs.get(1);
        return expr0 instanceof FieldReferenceExpression && expr1 instanceof ValueLiteralExpression || expr0 instanceof ValueLiteralExpression && expr1 instanceof FieldReferenceExpression;
    }

    private static String[] getReferencedColumns(ResolvedExpression expression) {
        CallExpression callExpr = (CallExpression)expression;
        FunctionDefinition funcDef = callExpr.getFunctionDefinition();
        if (funcDef == BuiltInFunctionDefinitions.NOT || funcDef == BuiltInFunctionDefinitions.AND || funcDef == BuiltInFunctionDefinitions.OR) {
            return (String[])callExpr.getChildren().stream().map(e -> ExpressionUtils.getReferencedColumns((ResolvedExpression)e)).flatMap(Arrays::stream).toArray(String[]::new);
        }
        return (String[])expression.getChildren().stream().filter(expr -> expr instanceof FieldReferenceExpression).map(expr -> ((FieldReferenceExpression)expr).getName()).toArray(String[]::new);
    }

    @Nullable
    public static Object getValueFromLiteral(ValueLiteralExpression expr) {
        LogicalType logicalType = expr.getOutputDataType().getLogicalType();
        switch (logicalType.getTypeRoot()) {
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return expr.getValueAs(LocalDateTime.class).map(ldt -> ldt.toInstant(ZoneOffset.UTC).toEpochMilli()).orElse(null);
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return expr.getValueAs(LocalTime.class).map(lt -> lt.get(ChronoField.MILLI_OF_DAY)).orElse(null);
            }
            case DATE: {
                return expr.getValueAs(LocalDate.class).map(LocalDate::toEpochDay).orElse(null);
            }
            case BOOLEAN: {
                return expr.getValueAs(Boolean.class).orElse(null);
            }
            case TINYINT: {
                return expr.getValueAs(Byte.class).orElse(null);
            }
            case SMALLINT: {
                return expr.getValueAs(Short.class).orElse(null);
            }
            case INTEGER: {
                return expr.getValueAs(Integer.class).orElse(null);
            }
            case BIGINT: {
                return expr.getValueAs(Long.class).orElse(null);
            }
            case FLOAT: {
                return expr.getValueAs(Float.class).orElse(null);
            }
            case DOUBLE: {
                return expr.getValueAs(Double.class).orElse(null);
            }
            case BINARY: 
            case VARBINARY: {
                return expr.getValueAs(byte[].class).orElse(null);
            }
            case CHAR: 
            case VARCHAR: {
                return expr.getValueAs(String.class).orElse(null);
            }
            case DECIMAL: {
                return expr.getValueAs(BigDecimal.class).orElse(null);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + logicalType);
    }
}

