/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.ReadOption;
import org.apache.hadoop.io.ByteBufferPool;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;

public class TimedFSDataInputStream
extends FSDataInputStream {
    private final Path path;

    public TimedFSDataInputStream(Path path, FSDataInputStream in) {
        super((InputStream)in);
        this.path = path;
    }

    public int read(ByteBuffer buf) throws IOException {
        return HoodieWrapperFileSystem.executeFuncWithTimeAndByteMetrics(HoodieWrapperFileSystem.MetricName.read.name(), this.path, 0L, () -> super.read(buf));
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        return HoodieWrapperFileSystem.executeFuncWithTimeAndByteMetrics(HoodieWrapperFileSystem.MetricName.read.name(), this.path, length, () -> super.read(position, buffer, offset, length));
    }

    public ByteBuffer read(ByteBufferPool bufferPool, int maxLength, EnumSet<ReadOption> opts) throws IOException, UnsupportedOperationException {
        return HoodieWrapperFileSystem.executeFuncWithTimeAndByteMetrics(HoodieWrapperFileSystem.MetricName.read.name(), this.path, maxLength, () -> super.read(bufferPool, maxLength, opts));
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        HoodieWrapperFileSystem.executeFuncWithTimeAndByteMetrics(HoodieWrapperFileSystem.MetricName.read.name(), this.path, buffer.length, () -> {
            super.readFully(position, buffer);
            return null;
        });
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        HoodieWrapperFileSystem.executeFuncWithTimeAndByteMetrics(HoodieWrapperFileSystem.MetricName.read.name(), this.path, length, () -> {
            super.readFully(position, buffer, offset, length);
            return null;
        });
    }
}

