/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log.block;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.inline.InLineFSUtils;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.TypeUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.storage.HoodieAvroHFileReader;
import org.apache.hudi.io.storage.HoodieHBaseKVComparator;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValue;
import org.apache.hudi.org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieHFileDataBlock
extends HoodieDataBlock {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieHFileDataBlock.class);
    private static final int DEFAULT_BLOCK_SIZE = 0x100000;
    private final Option<Compression.Algorithm> compressionAlgorithm;
    private final Path pathForReader;

    public HoodieHFileDataBlock(Supplier<FSDataInputStream> inputStreamSupplier, Option<byte[]> content, boolean readBlockLazily, HoodieLogBlock.HoodieLogBlockContentLocation logBlockContentLocation, Option<Schema> readerSchema, Map<HoodieLogBlock.HeaderMetadataType, String> header, Map<HoodieLogBlock.HeaderMetadataType, String> footer, boolean enablePointLookups, Path pathForReader) {
        super(content, inputStreamSupplier, readBlockLazily, Option.of(logBlockContentLocation), readerSchema, header, footer, "key", enablePointLookups);
        this.compressionAlgorithm = Option.empty();
        this.pathForReader = pathForReader;
    }

    public HoodieHFileDataBlock(List<HoodieRecord> records, Map<HoodieLogBlock.HeaderMetadataType, String> header, Compression.Algorithm compressionAlgorithm, Path pathForReader) {
        super(records, header, new HashMap<HoodieLogBlock.HeaderMetadataType, String>(), "key");
        this.compressionAlgorithm = Option.of(compressionAlgorithm);
        this.pathForReader = pathForReader;
    }

    @Override
    public HoodieLogBlock.HoodieLogBlockType getBlockType() {
        return HoodieLogBlock.HoodieLogBlockType.HFILE_DATA_BLOCK;
    }

    @Override
    protected byte[] serializeRecords(List<HoodieRecord> records) throws IOException {
        HFileContext context = new HFileContextBuilder().withBlockSize(0x100000).withCompression(this.compressionAlgorithm.get()).withCellComparator(new HoodieHBaseKVComparator()).build();
        Configuration conf = new Configuration();
        CacheConfig cacheConfig = new CacheConfig(conf);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FSDataOutputStream ostream = new FSDataOutputStream((OutputStream)baos, null);
        boolean useIntegerKey = !this.getRecordKey(records.get(0)).isPresent();
        int keyWidth = useIntegerKey ? (int)Math.ceil(Math.log(records.size())) + 1 : -1;
        TreeMap<String, byte[]> sortedRecordsMap = new TreeMap<String, byte[]>();
        Schema writerSchema = new Schema.Parser().parse(super.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.SCHEMA));
        Iterator<HoodieRecord> itr = records.iterator();
        int id = 0;
        while (itr.hasNext()) {
            HoodieRecord record = itr.next();
            String recordKey2 = useIntegerKey ? String.format("%" + keyWidth + "s", id++) : this.getRecordKey(record).get();
            byte[] recordBytes2 = this.serializeRecord(record, writerSchema);
            if (sortedRecordsMap.containsKey(recordKey2)) {
                LOG.error("Found duplicate record with recordKey: " + recordKey2);
                this.printRecord("Previous record", (byte[])sortedRecordsMap.get(recordKey2), writerSchema);
                this.printRecord("Current record", recordBytes2, writerSchema);
                throw new HoodieException(String.format("Writing multiple records with same key %s not supported for %s", recordKey2, this.getClass().getName()));
            }
            sortedRecordsMap.put(recordKey2, recordBytes2);
        }
        HFile.Writer writer = HFile.getWriterFactory(conf, cacheConfig).withOutputStream(ostream).withFileContext(context).create();
        sortedRecordsMap.forEach((recordKey, recordBytes) -> {
            try {
                KeyValue kv = new KeyValue(recordKey.getBytes(), null, null, (byte[])recordBytes);
                writer.append(kv);
            }
            catch (IOException e) {
                throw new HoodieIOException("IOException serializing records", e);
            }
        });
        writer.appendFileInfo("schema".getBytes(), this.getSchema().toString().getBytes());
        writer.close();
        ostream.flush();
        ostream.close();
        return baos.toByteArray();
    }

    @Override
    protected <T> ClosableIterator<HoodieRecord<T>> deserializeRecords(byte[] content, HoodieRecord.HoodieRecordType type) throws IOException {
        ValidationUtils.checkState(this.readerSchema != null, "Reader's schema has to be non-null");
        Configuration hadoopConf = FSUtils.buildInlineConf(this.getBlockContentLocation().get().getHadoopConf());
        FileSystem fs = FSUtils.getFs(this.pathForReader.toString(), hadoopConf);
        try (HoodieAvroHFileReader reader = new HoodieAvroHFileReader(hadoopConf, this.pathForReader, new CacheConfig(hadoopConf), fs, content, Option.of(this.getSchemaFromHeader()));){
            ClosableIterator closableIterator = (ClosableIterator)TypeUtils.unsafeCast(reader.getRecordIterator(this.readerSchema));
            return closableIterator;
        }
    }

    @Override
    protected <T> ClosableIterator<HoodieRecord<T>> lookupRecords(List<String> sortedKeys, boolean fullKey) throws IOException {
        HoodieLogBlock.HoodieLogBlockContentLocation blockContentLoc = this.getBlockContentLocation().get();
        Configuration inlineConf = FSUtils.buildInlineConf(blockContentLoc.getHadoopConf());
        Path inlinePath = InLineFSUtils.getInlineFilePath(blockContentLoc.getLogFile().getPath(), blockContentLoc.getLogFile().getPath().toUri().getScheme(), blockContentLoc.getContentPositionInLogFile(), blockContentLoc.getBlockSize());
        try (HoodieAvroHFileReader reader = new HoodieAvroHFileReader(inlineConf, inlinePath, new CacheConfig(inlineConf), inlinePath.getFileSystem(inlineConf), Option.of(this.getSchemaFromHeader()));){
            ClosableIterator<HoodieRecord<IndexedRecord>> recordIterator = fullKey ? reader.getRecordsByKeysIterator(sortedKeys, this.readerSchema) : reader.getRecordsByKeyPrefixIterator(sortedKeys, this.readerSchema);
            CloseableMappingIterator<HoodieRecord, HoodieRecord> closeableMappingIterator = new CloseableMappingIterator<HoodieRecord, HoodieRecord>(recordIterator, data -> data);
            return closeableMappingIterator;
        }
    }

    private byte[] serializeRecord(HoodieRecord<?> record, Schema schema) throws IOException {
        Option<Schema.Field> keyField = this.getKeyField(schema);
        if (keyField.isPresent()) {
            record.truncateRecordKey(schema, new Properties(), keyField.get().name());
        }
        return HoodieAvroUtils.recordToBytes(record, schema).get();
    }

    private void printRecord(String msg, byte[] bs, Schema schema) throws IOException {
        GenericRecord record = HoodieAvroUtils.bytesToAvro(bs, schema);
        byte[] json = HoodieAvroUtils.avroToJson(record, true);
        LOG.error(String.format("%s: %s", msg, new String(json)));
    }
}

