/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log.block;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.log.LogReaderUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.TypeUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.roaringbitmap.longlong.Roaring64NavigableMap;

public abstract class HoodieLogBlock {
    public static int version = 3;
    private final Map<HeaderMetadataType, String> logBlockHeader;
    private final Map<HeaderMetadataType, String> logBlockFooter;
    private final Option<HoodieLogBlockContentLocation> blockContentLocation;
    private Option<byte[]> content;
    private final Supplier<FSDataInputStream> inputStreamSupplier;
    protected boolean readBlockLazily;

    public HoodieLogBlock(@Nonnull Map<HeaderMetadataType, String> logBlockHeader, @Nonnull Map<HeaderMetadataType, String> logBlockFooter, @Nonnull Option<HoodieLogBlockContentLocation> blockContentLocation, @Nonnull Option<byte[]> content, @Nullable Supplier<FSDataInputStream> inputStreamSupplier, boolean readBlockLazily) {
        this.logBlockHeader = logBlockHeader;
        this.logBlockFooter = logBlockFooter;
        this.blockContentLocation = blockContentLocation;
        this.content = content;
        this.inputStreamSupplier = inputStreamSupplier;
        this.readBlockLazily = readBlockLazily;
    }

    public byte[] getContentBytes() throws IOException {
        throw new HoodieException("No implementation was provided");
    }

    public byte[] getMagic() {
        throw new HoodieException("No implementation was provided");
    }

    public abstract HoodieLogBlockType getBlockType();

    public long getLogBlockLength() {
        throw new HoodieException("No implementation was provided");
    }

    public Option<HoodieLogBlockContentLocation> getBlockContentLocation() {
        return this.blockContentLocation;
    }

    public Map<HeaderMetadataType, String> getLogBlockHeader() {
        return this.logBlockHeader;
    }

    public Map<HeaderMetadataType, String> getLogBlockFooter() {
        return this.logBlockFooter;
    }

    public Option<byte[]> getContent() {
        return this.content;
    }

    public boolean isCompactedLogBlock() {
        return this.logBlockHeader.containsKey((Object)HeaderMetadataType.COMPACTED_BLOCK_TIMES);
    }

    public Roaring64NavigableMap getRecordPositions() throws IOException {
        if (!this.logBlockHeader.containsKey((Object)HeaderMetadataType.RECORD_POSITIONS)) {
            return new Roaring64NavigableMap();
        }
        return LogReaderUtils.decodeRecordPositionsHeader(this.logBlockHeader.get((Object)HeaderMetadataType.RECORD_POSITIONS));
    }

    public static byte[] getLogMetadataBytes(Map<HeaderMetadataType, String> metadata) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(baos);
        output.writeInt(metadata.size());
        for (Map.Entry<HeaderMetadataType, String> entry : metadata.entrySet()) {
            output.writeInt(entry.getKey().ordinal());
            byte[] bytes = entry.getValue().getBytes();
            output.writeInt(bytes.length);
            output.write(bytes);
        }
        return baos.toByteArray();
    }

    public static Map<HeaderMetadataType, String> getLogMetadata(DataInputStream dis) throws IOException {
        HashMap<HeaderMetadataType, String> metadata = new HashMap<HeaderMetadataType, String>();
        try {
            for (int metadataCount = dis.readInt(); metadataCount > 0; --metadataCount) {
                int metadataEntryIndex = dis.readInt();
                int metadataEntrySize = dis.readInt();
                byte[] metadataEntry = new byte[metadataEntrySize];
                dis.readFully(metadataEntry, 0, metadataEntrySize);
                metadata.put(HeaderMetadataType.values()[metadataEntryIndex], new String(metadataEntry));
            }
            return metadata;
        }
        catch (EOFException eof) {
            throw new IOException("Could not read metadata fields ", eof);
        }
    }

    public static Option<byte[]> tryReadContent(FSDataInputStream inputStream, Integer contentLength, boolean readLazily) throws IOException {
        if (readLazily) {
            inputStream.seek(inputStream.getPos() + (long)contentLength.intValue());
            return Option.empty();
        }
        byte[] content = new byte[contentLength.intValue()];
        inputStream.readFully(content, 0, contentLength.intValue());
        return Option.of(content);
    }

    protected void inflate() throws HoodieIOException {
        ValidationUtils.checkState(!this.content.isPresent(), "Block has already been inflated");
        ValidationUtils.checkState(this.inputStreamSupplier != null, "Block should have input-stream provided");
        try (FSDataInputStream inputStream = this.inputStreamSupplier.get();){
            this.content = Option.of(new byte[(int)this.getBlockContentLocation().get().getBlockSize()]);
            inputStream.seek(this.getBlockContentLocation().get().getContentPositionInLogFile());
            inputStream.readFully(this.content.get(), 0, this.content.get().length);
            inputStream.seek(this.getBlockContentLocation().get().getBlockEndPos());
        }
        catch (IOException e) {
            this.inflate();
        }
    }

    protected void deflate() {
        this.content = Option.empty();
    }

    public static final class HoodieLogBlockContentLocation {
        private final Configuration hadoopConf;
        private final HoodieLogFile logFile;
        private final long contentPositionInLogFile;
        private final long blockSize;
        private final long blockEndPos;

        public HoodieLogBlockContentLocation(Configuration hadoopConf, HoodieLogFile logFile, long contentPositionInLogFile, long blockSize, long blockEndPos) {
            this.hadoopConf = hadoopConf;
            this.logFile = logFile;
            this.contentPositionInLogFile = contentPositionInLogFile;
            this.blockSize = blockSize;
            this.blockEndPos = blockEndPos;
        }

        public Configuration getHadoopConf() {
            return this.hadoopConf;
        }

        public HoodieLogFile getLogFile() {
            return this.logFile;
        }

        public long getContentPositionInLogFile() {
            return this.contentPositionInLogFile;
        }

        public long getBlockSize() {
            return this.blockSize;
        }

        public long getBlockEndPos() {
            return this.blockEndPos;
        }
    }

    public static enum FooterMetadataType {

    }

    public static enum HeaderMetadataType {
        INSTANT_TIME,
        TARGET_INSTANT_TIME,
        SCHEMA,
        COMMAND_BLOCK_TYPE,
        COMPACTED_BLOCK_TIMES,
        RECORD_POSITIONS,
        BLOCK_IDENTIFIER;

    }

    public static enum HoodieLogBlockType {
        COMMAND_BLOCK(":command"),
        DELETE_BLOCK(":delete"),
        CORRUPT_BLOCK(":corrupted"),
        AVRO_DATA_BLOCK("avro"),
        HFILE_DATA_BLOCK("hfile"),
        PARQUET_DATA_BLOCK("parquet"),
        CDC_DATA_BLOCK("cdc");

        private static final Map<String, HoodieLogBlockType> ID_TO_ENUM_MAP;
        private final String id;

        private HoodieLogBlockType(String id) {
            this.id = id;
        }

        public static HoodieLogBlockType fromId(String id) {
            return ID_TO_ENUM_MAP.get(id);
        }

        static {
            ID_TO_ENUM_MAP = TypeUtils.getValueToEnumMap(HoodieLogBlockType.class, e -> e.id);
        }
    }
}

