/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.io.AbstractInternalSchemaStorageManager;
import org.apache.hudi.internal.schema.utils.InternalSchemaUtils;
import org.apache.hudi.internal.schema.utils.SerDeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedInternalSchemaStorageManager
extends AbstractInternalSchemaStorageManager {
    private static final Logger LOG = LoggerFactory.getLogger(FileBasedInternalSchemaStorageManager.class);
    public static final String SCHEMA_NAME = ".schema";
    private final Path baseSchemaPath;
    private final Configuration conf;
    private HoodieTableMetaClient metaClient;

    public FileBasedInternalSchemaStorageManager(Configuration conf, Path baseTablePath) {
        Path metaPath = new Path(baseTablePath, ".hoodie");
        this.baseSchemaPath = new Path(metaPath, SCHEMA_NAME);
        this.conf = conf;
    }

    public FileBasedInternalSchemaStorageManager(HoodieTableMetaClient metaClient) {
        Path metaPath = new Path(metaClient.getBasePath(), ".hoodie");
        this.baseSchemaPath = new Path(metaPath, SCHEMA_NAME);
        this.conf = metaClient.getHadoopConf();
        this.metaClient = metaClient;
    }

    private HoodieTableMetaClient getMetaClient() {
        if (this.metaClient == null) {
            this.metaClient = HoodieTableMetaClient.builder().setBasePath(this.baseSchemaPath.getParent().getParent().toString()).setConf(this.conf).build();
        }
        return this.metaClient;
    }

    @Override
    public void persistHistorySchemaStr(String instantTime, String historySchemaStr) {
        this.cleanResidualFiles();
        HoodieActiveTimeline timeline = this.getMetaClient().getActiveTimeline();
        HoodieInstant hoodieInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "schemacommit", instantTime);
        timeline.createNewInstant(hoodieInstant);
        byte[] writeContent = historySchemaStr.getBytes(StandardCharsets.UTF_8);
        timeline.transitionRequestedToInflight(hoodieInstant, Option.empty());
        timeline.saveAsComplete(new HoodieInstant(HoodieInstant.State.INFLIGHT, hoodieInstant.getAction(), hoodieInstant.getTimestamp()), Option.of(writeContent));
        LOG.info(String.format("persist history schema success on commit time: %s", instantTime));
    }

    private void cleanResidualFiles() {
        List<String> validateCommits = this.getValidInstants();
        try {
            FileSystem fs = this.baseSchemaPath.getFileSystem(this.conf);
            if (fs.exists(this.baseSchemaPath)) {
                List candidateSchemaFiles = Arrays.stream(fs.listStatus(this.baseSchemaPath)).filter(f -> f.isFile()).map(file -> file.getPath().getName()).collect(Collectors.toList());
                List<String> residualSchemaFiles = candidateSchemaFiles.stream().filter(f -> !validateCommits.contains(f.split("\\.")[0])).collect(Collectors.toList());
                residualSchemaFiles.forEach(f -> {
                    try {
                        fs.delete(new Path(this.getMetaClient().getSchemaFolderName(), f));
                    }
                    catch (IOException o) {
                        throw new HoodieException(o);
                    }
                });
            }
        }
        catch (IOException e) {
            throw new HoodieException(e);
        }
    }

    public void cleanOldFiles(List<String> validateCommits) {
        try {
            FileSystem fs = this.baseSchemaPath.getFileSystem(this.conf);
            if (fs.exists(this.baseSchemaPath)) {
                List candidateSchemaFiles = Arrays.stream(fs.listStatus(this.baseSchemaPath)).filter(f -> f.isFile()).map(file -> file.getPath().getName()).collect(Collectors.toList());
                List validateSchemaFiles = candidateSchemaFiles.stream().filter(f -> validateCommits.contains(f.split("\\.")[0])).collect(Collectors.toList());
                for (int i = 0; i < validateSchemaFiles.size(); ++i) {
                    fs.delete(new Path((String)validateSchemaFiles.get(i)));
                }
            }
        }
        catch (IOException e) {
            throw new HoodieException(e);
        }
    }

    private List<String> getValidInstants() {
        return this.getMetaClient().getCommitsTimeline().filterCompletedInstants().getInstantsAsStream().map(f -> f.getTimestamp()).collect(Collectors.toList());
    }

    @Override
    public String getHistorySchemaStr() {
        return this.getHistorySchemaStrByGivenValidCommits(Collections.EMPTY_LIST);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getHistorySchemaStrByGivenValidCommits(List<String> validCommits) {
        List<String> commitList = validCommits == null || validCommits.isEmpty() ? this.getValidInstants() : validCommits;
        try {
            List validaSchemaFiles;
            FileSystem fs = FSUtils.getFs(this.baseSchemaPath.toString(), this.conf);
            if (fs.exists(this.baseSchemaPath) && !(validaSchemaFiles = Arrays.stream(fs.listStatus(this.baseSchemaPath)).filter(f -> f.isFile() && f.getPath().getName().endsWith("schemacommit")).map(file -> file.getPath().getName()).filter(f -> commitList.contains(f.split("\\.")[0])).sorted().collect(Collectors.toList())).isEmpty()) {
                Path latestFilePath = new Path(this.baseSchemaPath, (String)validaSchemaFiles.get(validaSchemaFiles.size() - 1));
                try (FSDataInputStream is = fs.open(latestFilePath);){
                    byte[] content = FileIOUtils.readAsByteArray((InputStream)is);
                    LOG.info(String.format("read history schema success from file : %s", latestFilePath));
                    String string = new String(content, StandardCharsets.UTF_8);
                    return string;
                }
                catch (IOException e) {
                    throw new HoodieIOException("Could not read history schema from " + latestFilePath, e);
                }
            }
        }
        catch (IOException io) {
            throw new HoodieException(io);
        }
        LOG.info("failed to read history schema");
        return "";
    }

    @Override
    public Option<InternalSchema> getSchemaByKey(String versionId) {
        String historySchemaStr = this.getHistorySchemaStr();
        if (historySchemaStr.isEmpty()) {
            return Option.empty();
        }
        TreeMap<Long, InternalSchema> treeMap = SerDeHelper.parseSchemas(historySchemaStr);
        InternalSchema result = InternalSchemaUtils.searchSchema((long)Long.valueOf(versionId), treeMap);
        if (result == null) {
            return Option.empty();
        }
        return Option.of(result);
    }
}

