/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import java.lang.management.ManagementFactory;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.management.MBeanServer;
import org.apache.hudi.com.codahale.metrics.MetricRegistry;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metrics.JmxReporterServer;
import org.apache.hudi.metrics.MetricsReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxMetricsReporter
extends MetricsReporter {
    private static final Logger LOG = LoggerFactory.getLogger(JmxMetricsReporter.class);
    private final MetricRegistry registry;
    private JmxReporterServer jmxReporterServer;

    public JmxMetricsReporter(HoodieWriteConfig config, MetricRegistry registry) {
        try {
            this.registry = registry;
            String host2 = config.getJmxHost();
            String portsConfig = config.getJmxPort();
            if (host2 == null || portsConfig == null) {
                throw new HoodieException(String.format("Jmx cannot be initialized with host[%s] and port[%s].", host2, portsConfig));
            }
            int[] ports = this.getPortRangeFromString(portsConfig);
            boolean successfullyStartedServer = false;
            int n = 0;
            int[] nArray = ports;
            int n2 = nArray.length;
            if (n < n2) {
                int port = nArray[n];
                this.jmxReporterServer = this.createJmxReport(host2, port);
                LOG.info("Started JMX server on port " + port + ".");
                successfullyStartedServer = true;
            }
            if (!successfullyStartedServer) {
                throw new HoodieException("Could not start JMX server on any configured port. Ports: " + portsConfig);
            }
            LOG.info("Configured JMXReporter with {port:" + portsConfig + "}");
        }
        catch (Exception e) {
            String msg = "Jmx initialize failed: ";
            LOG.error(msg, (Throwable)e);
            throw new HoodieException(msg, e);
        }
    }

    @Override
    public void start() {
        if (this.jmxReporterServer != null) {
            this.jmxReporterServer.start();
        } else {
            LOG.error("Cannot start as the jmxReporter is null.");
        }
    }

    @Override
    public void report() {
    }

    @Override
    public void stop() {
        Objects.requireNonNull(this.jmxReporterServer, "jmxReporterServer is not running.");
        try {
            this.jmxReporterServer.stop();
        }
        catch (Exception e) {
            throw new HoodieException("Stop jmxReporterServer fail", e);
        }
    }

    private JmxReporterServer createJmxReport(String host2, int port) {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        return JmxReporterServer.forRegistry(this.registry).host(host2).port(port).registerWith(mBeanServer).build();
    }

    private int[] getPortRangeFromString(String portsConfig) {
        int end;
        int start2;
        String range = portsConfig.trim();
        int dashIdx = range.indexOf(45);
        if (dashIdx == -1) {
            start2 = Integer.parseInt(range);
            end = Integer.parseInt(range);
        } else {
            start2 = Integer.parseInt(range.substring(0, dashIdx));
            end = Integer.parseInt(range.substring(dashIdx + 1));
        }
        return IntStream.rangeClosed(start2, end).filter(port -> 0 <= port && port <= 65535).toArray();
    }
}

