/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.backup.example;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.Abortable;
import org.apache.hudi.org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hudi.org.apache.hadoop.hbase.backup.example.ZKTableArchiveClient;
import org.apache.hudi.org.apache.hadoop.hbase.client.Connection;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class HFileArchiveManager {
    private final String archiveZnode;
    private static final Logger LOG = LoggerFactory.getLogger(HFileArchiveManager.class);
    private final ZKWatcher zooKeeper;
    private volatile boolean stopped = false;

    public HFileArchiveManager(Connection connection, Configuration conf) throws ZooKeeperConnectionException, IOException {
        this.zooKeeper = new ZKWatcher(conf, "hfileArchiveManager-on-" + connection.toString(), (Abortable)connection);
        this.archiveZnode = ZKTableArchiveClient.getArchiveZNode(this.zooKeeper.getConfiguration(), this.zooKeeper);
    }

    public HFileArchiveManager enableHFileBackup(byte[] table) throws KeeperException {
        this.enable(this.zooKeeper, table);
        return this;
    }

    public HFileArchiveManager disableHFileBackup(byte[] table) throws KeeperException {
        this.disable(this.zooKeeper, table);
        return this;
    }

    public HFileArchiveManager disableHFileBackup() throws IOException {
        LOG.debug("Disabling backups on all tables.");
        try {
            ZKUtil.deleteNodeRecursively((ZKWatcher)this.zooKeeper, (String)this.archiveZnode);
            return this;
        }
        catch (KeeperException e) {
            throw new IOException("Unexpected ZK exception!", e);
        }
    }

    private void enable(ZKWatcher zooKeeper, byte[] table) throws KeeperException {
        LOG.debug("Ensuring archiving znode exists");
        ZKUtil.createAndFailSilent((ZKWatcher)zooKeeper, (String)this.archiveZnode);
        String tableNode = this.getTableNode(table);
        LOG.debug("Creating: " + tableNode + ", data: []");
        ZKUtil.createSetData((ZKWatcher)zooKeeper, (String)tableNode, (byte[])new byte[0]);
    }

    private void disable(ZKWatcher zooKeeper, byte[] table) throws KeeperException {
        zooKeeper.syncOrTimeout(this.archiveZnode);
        if (ZKUtil.checkExists((ZKWatcher)zooKeeper, (String)this.archiveZnode) < 0) {
            return;
        }
        String tableNode = this.getTableNode(table);
        zooKeeper.syncOrTimeout(tableNode);
        LOG.debug("Attempting to delete table node:" + tableNode);
        ZKUtil.deleteNodeRecursively((ZKWatcher)zooKeeper, (String)tableNode);
    }

    public void stop() {
        if (!this.stopped) {
            this.stopped = true;
            LOG.debug("Stopping HFileArchiveManager...");
            this.zooKeeper.close();
        }
    }

    public boolean isArchivingEnabled(byte[] table) throws KeeperException {
        String tableNode = this.getTableNode(table);
        return ZKUtil.checkExists((ZKWatcher)this.zooKeeper, (String)tableNode) >= 0;
    }

    private String getTableNode(byte[] table) {
        return ZNodePaths.joinZNode(this.archiveZnode, Bytes.toString(table));
    }
}

