/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.WriteHandleFactory;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;

public interface BulkInsertPartitioner<I>
extends Serializable {
    public I repartitionRecords(I var1, int var2);

    public boolean arePartitionRecordsSorted();

    default public String getFileIdPfx(int partitionId) {
        return FSUtils.createNewFileIdPfx();
    }

    default public Option<WriteHandleFactory> getWriteHandleFactory(int partitionId) {
        return Option.empty();
    }

    public static String[] tryPrependPartitionPathColumns(String[] columnNames, HoodieWriteConfig config) {
        String partitionPath = config.populateMetaFields() ? HoodieRecord.HoodieMetadataField.PARTITION_PATH_METADATA_FIELD.getFieldName() : config.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key());
        if (StringUtils.isNullOrEmpty(partitionPath)) {
            return columnNames;
        }
        LinkedHashSet<String> sortCols = new LinkedHashSet<String>(StringUtils.split(partitionPath, ","));
        sortCols.addAll(Arrays.asList(columnNames));
        return sortCols.toArray(new String[0]);
    }
}

