/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.marker;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WriteMarkers
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(WriteMarkers.class);
    protected final String basePath;
    protected final transient Path markerDirPath;
    protected final String instantTime;

    public WriteMarkers(String basePath, String markerFolderPath, String instantTime) {
        this.basePath = basePath;
        this.markerDirPath = new Path(markerFolderPath);
        this.instantTime = instantTime;
    }

    public Option<Path> create(String partitionPath, String dataFileName, IOType type) {
        return this.create(partitionPath, dataFileName, type, false);
    }

    public Option<Path> create(String partitionPath, String dataFileName, IOType type, HoodieWriteConfig writeConfig, String fileId, HoodieActiveTimeline activeTimeline) {
        if (writeConfig.getWriteConcurrencyMode().supportsOptimisticConcurrencyControl() && writeConfig.isEarlyConflictDetectionEnable()) {
            HoodieTimeline pendingCompactionTimeline = activeTimeline.filterPendingCompactionTimeline();
            HoodieTimeline pendingReplaceTimeline = activeTimeline.filterPendingReplaceTimeline();
            if (pendingCompactionTimeline.containsInstant(this.instantTime) || pendingReplaceTimeline.containsInstant(this.instantTime)) {
                return this.create(partitionPath, dataFileName, type, false);
            }
            return this.createWithEarlyConflictDetection(partitionPath, dataFileName, type, false, writeConfig, fileId, activeTimeline);
        }
        return this.create(partitionPath, dataFileName, type, false);
    }

    public Option<Path> createIfNotExists(String partitionPath, String dataFileName, IOType type) {
        return this.create(partitionPath, dataFileName, type, true);
    }

    public Option<Path> createIfNotExists(String partitionPath, String fileName, IOType type, HoodieWriteConfig writeConfig, String fileId, HoodieActiveTimeline activeTimeline) {
        if (writeConfig.isEarlyConflictDetectionEnable() && writeConfig.getWriteConcurrencyMode().supportsOptimisticConcurrencyControl()) {
            HoodieTimeline pendingCompactionTimeline = activeTimeline.filterPendingCompactionTimeline();
            HoodieTimeline pendingReplaceTimeline = activeTimeline.filterPendingReplaceTimeline();
            if (pendingCompactionTimeline.containsInstant(this.instantTime) || pendingReplaceTimeline.containsInstant(this.instantTime)) {
                return this.create(partitionPath, fileName, type, true);
            }
            return this.createWithEarlyConflictDetection(partitionPath, fileName, type, false, writeConfig, fileId, activeTimeline);
        }
        return this.create(partitionPath, fileName, type, true);
    }

    public void quietDeleteMarkerDir(HoodieEngineContext context, int parallelism) {
        try {
            context.setJobStatus(this.getClass().getSimpleName(), "Deleting marker directory: " + this.basePath);
            this.deleteMarkerDir(context, parallelism);
        }
        catch (Exception e) {
            LOG.warn("Error deleting marker directory for instant " + this.instantTime, (Throwable)e);
        }
    }

    public static String stripMarkerSuffix(String path) {
        return path.substring(0, path.indexOf(".marker"));
    }

    protected String getMarkerFileName(String dataFileName, IOType type) {
        return String.format("%s%s.%s", dataFileName, ".marker", type.name());
    }

    protected Path getMarkerPath(String partitionPath, String dataFileName, IOType type) {
        Path path = FSUtils.getPartitionPath(this.markerDirPath, partitionPath);
        String markerFileName = this.getMarkerFileName(dataFileName, type);
        return new Path(path, markerFileName);
    }

    public abstract boolean deleteMarkerDir(HoodieEngineContext var1, int var2);

    public abstract boolean doesMarkerDirExist() throws IOException;

    public abstract Set<String> createdAndMergedDataPaths(HoodieEngineContext var1, int var2) throws IOException;

    public abstract Set<String> allMarkerFilePaths() throws IOException;

    abstract Option<Path> create(String var1, String var2, IOType var3, boolean var4);

    public abstract Option<Path> createWithEarlyConflictDetection(String var1, String var2, IOType var3, boolean var4, HoodieWriteConfig var5, String var6, HoodieActiveTimeline var7);
}

