/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.utils;

import java.io.IOException;
import org.apache.hudi.avro.model.HoodieArchivedMetaEntry;
import org.apache.hudi.avro.model.HoodieCommitMetadata;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.client.ReplaceArchivalHelper;
import org.apache.hudi.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.hudi.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hudi.common.model.ActionType;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.Option;

public class MetadataConversionUtils {
    public static HoodieArchivedMetaEntry createMetaWrapper(HoodieInstant hoodieInstant, HoodieTableMetaClient metaClient) throws IOException {
        Option<byte[]> instantDetails = metaClient.getActiveTimeline().getInstantDetails(hoodieInstant);
        if (hoodieInstant.isCompleted() && instantDetails.get().length == 0) {
            return MetadataConversionUtils.createMetaWrapperForEmptyInstant(hoodieInstant);
        }
        HoodieArchivedMetaEntry archivedMetaWrapper = new HoodieArchivedMetaEntry();
        archivedMetaWrapper.setCommitTime(hoodieInstant.getTimestamp());
        archivedMetaWrapper.setActionState(hoodieInstant.getState().name());
        archivedMetaWrapper.setStateTransitionTime(hoodieInstant.getStateTransitionTime());
        switch (hoodieInstant.getAction()) {
            case "clean": {
                if (hoodieInstant.isCompleted()) {
                    archivedMetaWrapper.setHoodieCleanMetadata(CleanerUtils.getCleanerMetadata(metaClient, instantDetails.get()));
                } else {
                    archivedMetaWrapper.setHoodieCleanerPlan(CleanerUtils.getCleanerPlan(metaClient, instantDetails.get()));
                }
                archivedMetaWrapper.setActionType(ActionType.clean.name());
                break;
            }
            case "commit": {
                org.apache.hudi.common.model.HoodieCommitMetadata commitMetadata = org.apache.hudi.common.model.HoodieCommitMetadata.fromBytes(instantDetails.get(), org.apache.hudi.common.model.HoodieCommitMetadata.class);
                archivedMetaWrapper.setHoodieCommitMetadata(MetadataConversionUtils.convertCommitMetadata(commitMetadata));
                archivedMetaWrapper.setActionType(ActionType.commit.name());
                break;
            }
            case "deltacommit": {
                org.apache.hudi.common.model.HoodieCommitMetadata deltaCommitMetadata = org.apache.hudi.common.model.HoodieCommitMetadata.fromBytes(instantDetails.get(), org.apache.hudi.common.model.HoodieCommitMetadata.class);
                archivedMetaWrapper.setHoodieCommitMetadata(MetadataConversionUtils.convertCommitMetadata(deltaCommitMetadata));
                archivedMetaWrapper.setActionType(ActionType.deltacommit.name());
                break;
            }
            case "replacecommit": {
                if (hoodieInstant.isCompleted()) {
                    HoodieReplaceCommitMetadata replaceCommitMetadata = HoodieReplaceCommitMetadata.fromBytes(instantDetails.get(), HoodieReplaceCommitMetadata.class);
                    archivedMetaWrapper.setHoodieReplaceCommitMetadata(ReplaceArchivalHelper.convertReplaceCommitMetadata(replaceCommitMetadata));
                } else if (hoodieInstant.isInflight()) {
                    Option<org.apache.hudi.common.model.HoodieCommitMetadata> inflightCommitMetadata = MetadataConversionUtils.getInflightCommitMetadata(instantDetails);
                    if (inflightCommitMetadata.isPresent()) {
                        archivedMetaWrapper.setHoodieInflightReplaceMetadata(MetadataConversionUtils.convertCommitMetadata(inflightCommitMetadata.get()));
                    }
                } else {
                    Option<HoodieRequestedReplaceMetadata> requestedReplaceMetadata = MetadataConversionUtils.getRequestedReplaceMetadata(instantDetails);
                    if (requestedReplaceMetadata.isPresent()) {
                        archivedMetaWrapper.setHoodieRequestedReplaceMetadata(requestedReplaceMetadata.get());
                    }
                }
                archivedMetaWrapper.setActionType(ActionType.replacecommit.name());
                break;
            }
            case "rollback": {
                if (hoodieInstant.isCompleted()) {
                    archivedMetaWrapper.setHoodieRollbackMetadata(TimelineMetadataUtils.deserializeAvroMetadata(instantDetails.get(), HoodieRollbackMetadata.class));
                }
                archivedMetaWrapper.setActionType(ActionType.rollback.name());
                break;
            }
            case "savepoint": {
                archivedMetaWrapper.setHoodieSavePointMetadata(TimelineMetadataUtils.deserializeAvroMetadata(instantDetails.get(), HoodieSavepointMetadata.class));
                archivedMetaWrapper.setActionType(ActionType.savepoint.name());
                break;
            }
            case "compaction": {
                if (hoodieInstant.isRequested()) {
                    HoodieCompactionPlan plan = CompactionUtils.getCompactionPlan(metaClient, instantDetails);
                    archivedMetaWrapper.setHoodieCompactionPlan(plan);
                }
                archivedMetaWrapper.setActionType(ActionType.compaction.name());
                break;
            }
            case "logcompaction": {
                if (hoodieInstant.isRequested()) {
                    HoodieCompactionPlan plan = CompactionUtils.getCompactionPlan(metaClient, instantDetails);
                    archivedMetaWrapper.setHoodieCompactionPlan(plan);
                }
                archivedMetaWrapper.setActionType(ActionType.logcompaction.name());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Action not fully supported yet");
            }
        }
        return archivedMetaWrapper;
    }

    public static HoodieArchivedMetaEntry createMetaWrapperForEmptyInstant(HoodieInstant hoodieInstant) {
        HoodieArchivedMetaEntry archivedMetaWrapper = new HoodieArchivedMetaEntry();
        archivedMetaWrapper.setCommitTime(hoodieInstant.getTimestamp());
        archivedMetaWrapper.setActionState(hoodieInstant.getState().name());
        archivedMetaWrapper.setStateTransitionTime(hoodieInstant.getStateTransitionTime());
        switch (hoodieInstant.getAction()) {
            case "clean": {
                archivedMetaWrapper.setActionType(ActionType.clean.name());
                break;
            }
            case "commit": {
                archivedMetaWrapper.setActionType(ActionType.commit.name());
                break;
            }
            case "deltacommit": {
                archivedMetaWrapper.setActionType(ActionType.deltacommit.name());
                break;
            }
            case "replacecommit": {
                archivedMetaWrapper.setActionType(ActionType.replacecommit.name());
                break;
            }
            case "rollback": {
                archivedMetaWrapper.setActionType(ActionType.rollback.name());
                break;
            }
            case "savepoint": {
                archivedMetaWrapper.setActionType(ActionType.savepoint.name());
                break;
            }
            case "compaction": {
                archivedMetaWrapper.setActionType(ActionType.compaction.name());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Action not fully supported yet");
            }
        }
        return archivedMetaWrapper;
    }

    private static Option<org.apache.hudi.common.model.HoodieCommitMetadata> getInflightCommitMetadata(Option<byte[]> inflightContent) throws IOException {
        if (!inflightContent.isPresent() || inflightContent.get().length == 0) {
            return Option.empty();
        }
        return Option.of(org.apache.hudi.common.model.HoodieCommitMetadata.fromBytes(inflightContent.get(), org.apache.hudi.common.model.HoodieCommitMetadata.class));
    }

    private static Option<HoodieRequestedReplaceMetadata> getRequestedReplaceMetadata(Option<byte[]> requestedContent) throws IOException {
        if (!requestedContent.isPresent() || requestedContent.get().length == 0) {
            return Option.empty();
        }
        return Option.of(TimelineMetadataUtils.deserializeRequestedReplaceMetadata(requestedContent.get()));
    }

    public static Option<org.apache.hudi.common.model.HoodieCommitMetadata> getHoodieCommitMetadata(HoodieTableMetaClient metaClient, HoodieInstant hoodieInstant) throws IOException {
        HoodieTimeline timeline = metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
        return Option.of(TimelineUtils.getCommitMetadata(hoodieInstant, timeline));
    }

    public static HoodieCommitMetadata convertCommitMetadata(org.apache.hudi.common.model.HoodieCommitMetadata hoodieCommitMetadata) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        HoodieCommitMetadata avroMetaData = mapper.convertValue((Object)hoodieCommitMetadata, HoodieCommitMetadata.class);
        if (hoodieCommitMetadata.getCompacted().booleanValue()) {
            avroMetaData.setOperationType(WriteOperationType.COMPACT.name());
        }
        avroMetaData.getExtraMetadata().put("ROLLING_STAT", "");
        return avroMetaData;
    }
}

