/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.hash;

import org.apache.hudi.common.util.Base64CodecUtil;
import org.apache.hudi.common.util.hash.HashID;
import org.apache.hudi.common.util.hash.HoodieIndexID;

public class ColumnIndexID
extends HoodieIndexID {
    private static final HoodieIndexID.Type TYPE = HoodieIndexID.Type.COLUMN;
    public static final HashID.Size ID_COLUMN_HASH_SIZE = HashID.Size.BITS_64;
    private final String column;
    private final byte[] hash;

    public ColumnIndexID(String column) {
        this.column = column;
        this.hash = HashID.hash(column, ID_COLUMN_HASH_SIZE);
    }

    @Override
    public String getName() {
        return this.column;
    }

    @Override
    public int bits() {
        return ID_COLUMN_HASH_SIZE.byteSize();
    }

    @Override
    public byte[] asBytes() {
        return this.hash;
    }

    @Override
    public String asBase64EncodedString() {
        return Base64CodecUtil.encode(this.hash);
    }

    @Override
    public String toString() {
        return new String(this.hash);
    }

    @Override
    protected HoodieIndexID.Type getType() {
        return TYPE;
    }
}

