/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.http.impl.conn;

import java.net.InetAddress;
import org.apache.hudi.org.apache.http.HttpException;
import org.apache.hudi.org.apache.http.HttpHost;
import org.apache.hudi.org.apache.http.HttpRequest;
import org.apache.hudi.org.apache.http.ProtocolException;
import org.apache.hudi.org.apache.http.annotation.Immutable;
import org.apache.hudi.org.apache.http.client.config.RequestConfig;
import org.apache.hudi.org.apache.http.client.protocol.HttpClientContext;
import org.apache.hudi.org.apache.http.conn.SchemePortResolver;
import org.apache.hudi.org.apache.http.conn.UnsupportedSchemeException;
import org.apache.hudi.org.apache.http.conn.routing.HttpRoute;
import org.apache.hudi.org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.hudi.org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.hudi.org.apache.http.protocol.HttpContext;
import org.apache.hudi.org.apache.http.util.Args;

@Immutable
public class DefaultRoutePlanner
implements HttpRoutePlanner {
    private final SchemePortResolver schemePortResolver;

    public DefaultRoutePlanner(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    @Override
    public HttpRoute determineRoute(HttpHost host2, HttpRequest request, HttpContext context) throws HttpException {
        HttpHost target;
        Args.notNull(request, "Request");
        if (host2 == null) {
            throw new ProtocolException("Target host is not specified");
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig config = clientContext.getRequestConfig();
        InetAddress local = config.getLocalAddress();
        HttpHost proxy = config.getProxy();
        if (proxy == null) {
            proxy = this.determineProxy(host2, request, context);
        }
        if (host2.getPort() <= 0) {
            try {
                target = new HttpHost(host2.getHostName(), this.schemePortResolver.resolve(host2), host2.getSchemeName());
            }
            catch (UnsupportedSchemeException ex) {
                throw new HttpException(ex.getMessage());
            }
        } else {
            target = host2;
        }
        boolean secure = target.getSchemeName().equalsIgnoreCase("https");
        if (proxy == null) {
            return new HttpRoute(target, local, secure);
        }
        return new HttpRoute(target, local, proxy, secure);
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        return null;
    }
}

