/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.ApiMaturityLevel;
import org.apache.hudi.PublicAPIClass;
import org.apache.hudi.PublicAPIMethod;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;

@PublicAPIClass(maturity=ApiMaturityLevel.STABLE)
public interface HoodieRecordPayload<T extends HoodieRecordPayload>
extends Serializable {
    @Deprecated
    @PublicAPIMethod(maturity=ApiMaturityLevel.DEPRECATED)
    public T preCombine(T var1);

    @PublicAPIMethod(maturity=ApiMaturityLevel.STABLE)
    default public T preCombine(T oldValue, Properties properties) {
        return this.preCombine(oldValue);
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    default public T preCombine(T oldValue, Schema schema, Properties properties) {
        return this.preCombine(oldValue, properties);
    }

    @Deprecated
    @PublicAPIMethod(maturity=ApiMaturityLevel.DEPRECATED)
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord var1, Schema var2) throws IOException;

    default public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord currentValue, Schema schema, Properties properties) throws IOException {
        return this.combineAndGetUpdateValue(currentValue, schema);
    }

    @Deprecated
    @PublicAPIMethod(maturity=ApiMaturityLevel.DEPRECATED)
    public Option<IndexedRecord> getInsertValue(Schema var1) throws IOException;

    @PublicAPIMethod(maturity=ApiMaturityLevel.STABLE)
    default public Option<IndexedRecord> getInsertValue(Schema schema, Properties properties) throws IOException {
        return this.getInsertValue(schema);
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.STABLE)
    default public Option<Map<String, String>> getMetadata() {
        return Option.empty();
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.STABLE)
    default public Comparable<?> getOrderingValue() {
        return 0;
    }

    public static String getAvroPayloadForMergeMode(RecordMergeMode mergeMode, String payloadClassName) {
        switch (mergeMode) {
            case EVENT_TIME_ORDERING: {
                return DefaultHoodieRecordPayload.class.getName();
            }
            case COMMIT_TIME_ORDERING: {
                return OverwriteWithLatestAvroPayload.class.getName();
            }
        }
        return payloadClassName;
    }

    public static String getPayloadClassName(HoodieConfig config) {
        String payloadClassName;
        if (config.contains(HoodieTableConfig.PAYLOAD_CLASS_NAME)) {
            payloadClassName = config.getString(HoodieTableConfig.PAYLOAD_CLASS_NAME);
        } else if (config.contains("hoodie.datasource.write.payload.class").booleanValue()) {
            payloadClassName = config.getString("hoodie.datasource.write.payload.class");
        } else {
            return HoodieTableConfig.DEFAULT_PAYLOAD_CLASS_NAME;
        }
        return payloadClassName.replace("com.uber.hoodie", "org.apache.hudi");
    }
}

