/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import org.apache.hudi.common.config.HoodieMetaserverConfig;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.versioning.v2.ActiveTimelineV2;
import org.apache.hudi.common.table.timeline.versioning.v2.InstantFileNameGeneratorV2;
import org.apache.hudi.common.table.timeline.versioning.v2.InstantGeneratorV2;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metaserver.client.HoodieMetaserverClient;
import org.apache.hudi.metaserver.client.HoodieMetaserverClientProxy;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;

public class HoodieMetaserverBasedTimeline
extends ActiveTimelineV2 {
    private final String databaseName;
    private final String tableName;
    private final HoodieMetaserverClient metaserverClient;
    private final InstantGeneratorV2 instantGenerator = new InstantGeneratorV2();
    private final InstantFileNameGeneratorV2 instantFileNameGenerator = new InstantFileNameGeneratorV2();

    public HoodieMetaserverBasedTimeline(HoodieTableMetaClient metaClient, HoodieMetaserverConfig config) {
        this.metaClient = metaClient;
        this.metaserverClient = HoodieMetaserverClientProxy.getProxy(config);
        this.databaseName = config.getString(HoodieTableConfig.DATABASE_NAME.key());
        this.tableName = config.getString(HoodieTableConfig.NAME.key());
        this.setInstants(this.metaserverClient.listInstants(this.databaseName, this.tableName, 24));
    }

    @Override
    protected void deleteInstantFile(HoodieInstant instant) {
        this.metaserverClient.deleteInstant(this.databaseName, this.tableName, instant);
    }

    @Override
    protected void transitionStateToComplete(boolean shouldLock, HoodieInstant fromInstant, HoodieInstant toInstant, Option<byte[]> data) {
        ValidationUtils.checkArgument(fromInstant.requestedTime().equals(toInstant.requestedTime()));
        this.metaserverClient.transitionInstantState(this.databaseName, this.tableName, fromInstant, toInstant, data);
    }

    @Override
    public void transitionPendingState(HoodieInstant fromInstant, HoodieInstant toInstant, Option<byte[]> data, boolean allowRedundantTransitions) {
        ValidationUtils.checkArgument(fromInstant.requestedTime().equals(toInstant.requestedTime()));
        this.metaserverClient.transitionInstantState(this.databaseName, this.tableName, fromInstant, toInstant, data);
    }

    @Override
    public void createFileInMetaPath(String filename, Option<byte[]> content, boolean allowOverwrite) {
        StoragePathInfo pathInfo = new StoragePathInfo(new StoragePath(filename), 0L, false, 0, 0L, 0L);
        HoodieInstant instant = this.instantGenerator.createNewInstant(pathInfo);
        ValidationUtils.checkArgument(instant.getState().equals((Object)HoodieInstant.State.REQUESTED));
        this.metaserverClient.createNewInstant(this.databaseName, this.tableName, instant, Option.empty());
    }

    @Override
    protected void revertCompleteToInflight(HoodieInstant completed, HoodieInstant inflight) {
        throw new HoodieException("Unsupported now");
    }

    @Override
    protected Option<byte[]> readDataFromPath(StoragePath detailPath) {
        StoragePathInfo pathInfo = new StoragePathInfo(detailPath, 0L, false, 0, 0L, 0L);
        HoodieInstant instant = this.instantGenerator.createNewInstant(pathInfo);
        return this.metaserverClient.getInstantMetadata(this.databaseName, this.tableName, instant);
    }

    @Override
    public HoodieMetaserverBasedTimeline reload() {
        return new HoodieMetaserverBasedTimeline(this.metaClient, this.metaClient.getMetaserverConfig());
    }

    @Override
    protected String getInstantFileName(HoodieInstant instant) {
        if (instant.isCompleted()) {
            return this.instantFileNameGenerator.getFileName("0", instant).replace("_0", "");
        }
        return this.instantFileNameGenerator.getFileName(instant);
    }
}

