/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.dto;

import org.apache.hudi.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.hudi.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.InstantGenerator;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InstantDTO {
    @JsonProperty(value="action")
    String action;
    @JsonProperty(value="ts")
    String timestamp;
    @JsonProperty(value="state")
    String state;

    public static InstantDTO fromInstant(HoodieInstant instant) {
        if (null == instant) {
            return null;
        }
        InstantDTO dto = new InstantDTO();
        dto.action = instant.getAction();
        dto.timestamp = instant.requestedTime();
        dto.state = instant.getState().toString();
        return dto;
    }

    public static HoodieInstant toInstant(InstantDTO dto, InstantGenerator factory) {
        if (null == dto) {
            return null;
        }
        return factory.createNewInstant(HoodieInstant.State.valueOf(dto.state), dto.action, dto.timestamp);
    }
}

