/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.hudi.common.util.collection.DiskMap;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.common.util.collection.FilterIterator;
import org.apache.hudi.common.util.collection.MappingIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.common.util.collection.RocksDBDAO;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RocksDbDiskMap<T extends Serializable, R extends Serializable>
extends DiskMap<T, R> {
    private static final String ROCKSDB_COL_FAMILY = "rocksdb-diskmap";
    private static final Logger LOG = LoggerFactory.getLogger(RocksDbDiskMap.class);
    private final Set<T> keySet = new HashSet<T>();
    private RocksDBDAO rocksDb;

    public RocksDbDiskMap(String rocksDbStoragePath) throws IOException {
        super(rocksDbStoragePath, ExternalSpillableMap.DiskMapType.ROCKS_DB.name());
    }

    @Override
    public int size() {
        return this.keySet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keySet.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keySet.contains((Serializable)key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new HoodieNotSupportedException("unable to compare values in map");
    }

    @Override
    public R get(Object key) {
        if (!this.containsKey(key)) {
            return null;
        }
        return (R)this.getRocksDb().get(ROCKSDB_COL_FAMILY, (Serializable)key);
    }

    @Override
    public R put(T key, R value) {
        this.getRocksDb().put(ROCKSDB_COL_FAMILY, key, value);
        this.keySet.add(key);
        return value;
    }

    @Override
    public R remove(Object key) {
        Object value = this.get(key);
        if (value != null) {
            this.keySet.remove((Serializable)key);
            this.getRocksDb().delete(ROCKSDB_COL_FAMILY, (Serializable)key);
        }
        return (R)value;
    }

    @Override
    public void putAll(Map<? extends T, ? extends R> keyValues) {
        this.getRocksDb().writeBatch(batch -> keyValues.forEach((? super K key, ? super V value) -> this.getRocksDb().putInBatch(batch, ROCKSDB_COL_FAMILY, key, value)));
        this.keySet.addAll(keyValues.keySet());
    }

    @Override
    public void clear() {
        this.close();
    }

    @Override
    public Set<T> keySet() {
        return this.keySet;
    }

    @Override
    public Collection<R> values() {
        throw new HoodieException("Unsupported Operation Exception");
    }

    @Override
    public Set<Map.Entry<T, R>> entrySet() {
        HashSet<Map.Entry<T, R>> entrySet = new HashSet<Map.Entry<T, R>>();
        for (Serializable key : this.keySet) {
            entrySet.add(new AbstractMap.SimpleEntry<Serializable, Object>(key, this.get(key)));
        }
        return entrySet;
    }

    @Override
    public Iterator<R> iterator() {
        return new MappingIterator<Pair, Serializable>(this.getRocksDb().iterator(ROCKSDB_COL_FAMILY), Pair::getValue);
    }

    @Override
    public Iterator<R> iterator(Predicate<T> filter) {
        return new MappingIterator<Pair, Serializable>(new FilterIterator<Pair>(this.getRocksDb().iterator(ROCKSDB_COL_FAMILY), pair -> filter.test(pair.getKey())), Pair::getValue);
    }

    @Override
    public Stream<R> valueStream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 0), false);
    }

    @Override
    public long sizeOfFileOnDiskInBytes() {
        return this.getRocksDb().getTotalBytesWritten();
    }

    @Override
    public void close() {
        this.keySet.clear();
        if (null != this.rocksDb) {
            this.rocksDb.close();
        }
        this.rocksDb = null;
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RocksDBDAO getRocksDb() {
        if (null == this.rocksDb) {
            RocksDbDiskMap rocksDbDiskMap = this;
            synchronized (rocksDbDiskMap) {
                if (null == this.rocksDb) {
                    this.rocksDb = new RocksDBDAO(ROCKSDB_COL_FAMILY, this.diskMapPath);
                    this.rocksDb.addColumnFamily(ROCKSDB_COL_FAMILY);
                }
            }
        }
        return this.rocksDb;
    }
}

