/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.realtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hadoop.BootstrapBaseFileSplit;
import org.apache.hudi.hadoop.realtime.HoodieVirtualKeyInfo;
import org.apache.hudi.hadoop.realtime.RealtimeSplit;

public class HoodieRealtimeBootstrapBaseFileSplit
extends BootstrapBaseFileSplit
implements RealtimeSplit {
    private boolean belongsToIncrementalQuery = false;
    private List<HoodieLogFile> deltaLogFiles = new ArrayList<HoodieLogFile>();
    private String maxCommitTime;
    private String basePath;
    private Option<HoodieVirtualKeyInfo> virtualKeyInfo = Option.empty();

    public HoodieRealtimeBootstrapBaseFileSplit() {
    }

    public HoodieRealtimeBootstrapBaseFileSplit(FileSplit baseSplit, String basePath, List<HoodieLogFile> deltaLogFiles, String maxInstantTime, FileSplit externalFileSplit, boolean belongsToIncrementalQuery, Option<HoodieVirtualKeyInfo> virtualKeyInfoOpt) throws IOException {
        super(baseSplit, externalFileSplit);
        this.maxCommitTime = maxInstantTime;
        this.deltaLogFiles = deltaLogFiles;
        this.basePath = basePath;
        this.belongsToIncrementalQuery = belongsToIncrementalQuery;
        this.virtualKeyInfo = virtualKeyInfoOpt;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.writeToOutput(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.readFromInput(in);
    }

    @Override
    public List<HoodieLogFile> getDeltaLogFiles() {
        return this.deltaLogFiles;
    }

    @Override
    public void setDeltaLogFiles(List<HoodieLogFile> deltaLogFiles) {
        this.deltaLogFiles = deltaLogFiles;
    }

    @Override
    public String getMaxCommitTime() {
        return this.maxCommitTime;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public Option<HoodieVirtualKeyInfo> getVirtualKeyInfo() {
        return this.virtualKeyInfo;
    }

    @Override
    public boolean getBelongsToIncrementalQuery() {
        return this.belongsToIncrementalQuery;
    }

    @Override
    public void setBelongsToIncrementalQuery(boolean belongsToIncrementalPath) {
        this.belongsToIncrementalQuery = belongsToIncrementalPath;
    }

    @Override
    public void setMaxCommitTime(String maxInstantTime) {
        this.maxCommitTime = maxInstantTime;
    }

    @Override
    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Override
    public void setVirtualKeyInfo(Option<HoodieVirtualKeyInfo> virtualKeyInfo) {
        this.virtualKeyInfo = virtualKeyInfo;
    }
}

