/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.simple;

import java.util.List;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordGlobalLocation;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.index.simple.HoodieSimpleIndex;
import org.apache.hudi.io.HoodieKeyLocationFetchHandle;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.table.HoodieTable;

public class HoodieGlobalSimpleIndex
extends HoodieSimpleIndex {
    public HoodieGlobalSimpleIndex(HoodieWriteConfig config, Option<BaseKeyGenerator> keyGeneratorOpt) {
        super(config, keyGeneratorOpt);
    }

    @Override
    public <R> HoodieData<HoodieRecord<R>> tagLocation(HoodieData<HoodieRecord<R>> records, HoodieEngineContext context, HoodieTable hoodieTable) {
        return this.tagLocationInternal(records, context, hoodieTable);
    }

    @Override
    protected <R> HoodieData<HoodieRecord<R>> tagLocationInternal(HoodieData<HoodieRecord<R>> inputRecords, HoodieEngineContext context, HoodieTable hoodieTable) {
        List<Pair<String, HoodieBaseFile>> latestBaseFiles = this.getAllBaseFilesInTable(context, hoodieTable);
        HoodiePairData<String, HoodieRecordGlobalLocation> allKeysAndLocations = this.fetchRecordGlobalLocations(context, hoodieTable, latestBaseFiles);
        boolean mayContainDuplicateLookup = hoodieTable.getMetaClient().getTableType() == HoodieTableType.MERGE_ON_READ;
        boolean shouldUpdatePartitionPath = this.config.getGlobalSimpleIndexUpdatePartitionPath() && hoodieTable.isPartitioned();
        return HoodieIndexUtils.tagGlobalLocationBackToRecords(inputRecords, allKeysAndLocations, mayContainDuplicateLookup, shouldUpdatePartitionPath, this.config, hoodieTable);
    }

    private HoodiePairData<String, HoodieRecordGlobalLocation> fetchRecordGlobalLocations(HoodieEngineContext context, HoodieTable hoodieTable, List<Pair<String, HoodieBaseFile>> baseFiles) {
        int parallelism = this.getParallelism(this.config.getGlobalSimpleIndexParallelism(), baseFiles.size());
        return context.parallelize(baseFiles, parallelism).flatMap(partitionPathBaseFile -> new HoodieKeyLocationFetchHandle(this.config, hoodieTable, (Pair<String, HoodieBaseFile>)partitionPathBaseFile, this.keyGeneratorOpt).globalLocations()).mapToPair(e -> (Pair)e);
    }

    private List<Pair<String, HoodieBaseFile>> getAllBaseFilesInTable(HoodieEngineContext context, HoodieTable hoodieTable) {
        HoodieTableMetaClient metaClient = hoodieTable.getMetaClient();
        List<String> allPartitionPaths = FSUtils.getAllPartitionPaths(context, metaClient.getStorage(), this.config.getMetadataConfig(), metaClient.getBasePath());
        return HoodieIndexUtils.getLatestBaseFilesForAllPartitions(allPartitionPaths, context, hoodieTable);
    }

    @Override
    public boolean isGlobal() {
        return true;
    }
}

