/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.SlidingWindowReservoir;
import org.apache.flink.dropwizard.metrics.DropwizardHistogramWrapper;
import org.apache.flink.dropwizard.metrics.DropwizardMeterWrapper;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MetricGroup;
import org.apache.hudi.metrics.HoodieFlinkMetrics;

public class FlinkStreamWriteMetrics
extends HoodieFlinkMetrics {
    private static final String DATA_FLUSH_KEY = "data_flush";
    private static final String FILE_FLUSH_KEY = "file_flush";
    private static final String HANDLE_CREATION_KEY = "handle_creation";
    private long dataFlushCosts;
    protected long writtenRecords;
    private long writeBufferedSize;
    private long fileFlushTotalCosts;
    private long numOfOpenHandle;
    private long numOfFilesWritten;
    protected final Meter recordWrittenPerSecond = new DropwizardMeterWrapper(new com.codahale.metrics.Meter());
    private final Meter handleSwitchPerSecond = new DropwizardMeterWrapper(new com.codahale.metrics.Meter());
    private final org.apache.flink.metrics.Histogram handleCreationCosts = new DropwizardHistogramWrapper(new Histogram(new SlidingWindowReservoir(100)));
    private final org.apache.flink.metrics.Histogram fileFlushCost = new DropwizardHistogramWrapper(new Histogram(new SlidingWindowReservoir(100)));

    public FlinkStreamWriteMetrics(MetricGroup metricGroup) {
        super(metricGroup);
    }

    @Override
    public void registerMetrics() {
        this.metricGroup.meter("recordWrittenPerSecond", this.recordWrittenPerSecond);
        this.metricGroup.gauge("currentCommitWrittenRecords", () -> this.writtenRecords);
        this.metricGroup.gauge("dataFlushCosts", () -> this.dataFlushCosts);
        this.metricGroup.gauge("writeBufferedSize", () -> this.writeBufferedSize);
        this.metricGroup.gauge("fileFlushTotalCosts", () -> this.fileFlushTotalCosts);
        this.metricGroup.gauge("numOfFilesWritten", () -> this.numOfFilesWritten);
        this.metricGroup.gauge("numOfOpenHandle", () -> this.numOfOpenHandle);
        this.metricGroup.meter("handleSwitchPerSecond", this.handleSwitchPerSecond);
        this.metricGroup.histogram("handleCreationCosts", this.handleCreationCosts);
        this.metricGroup.histogram("fileFlushCost", this.fileFlushCost);
    }

    public void setWriteBufferedSize(long writeBufferedSize) {
        this.writeBufferedSize = writeBufferedSize;
    }

    public void startDataFlush() {
        this.startTimer(DATA_FLUSH_KEY);
    }

    public void endDataFlush() {
        this.dataFlushCosts = this.stopTimer(DATA_FLUSH_KEY);
    }

    public void markRecordIn() {
        ++this.writtenRecords;
        this.recordWrittenPerSecond.markEvent();
    }

    public void increaseNumOfFilesWritten() {
        ++this.numOfFilesWritten;
    }

    public void increaseNumOfOpenHandle() {
        ++this.numOfOpenHandle;
        this.increaseNumOfFilesWritten();
    }

    public void markHandleSwitch() {
        this.handleSwitchPerSecond.markEvent();
    }

    public void startHandleCreation() {
        this.startTimer(HANDLE_CREATION_KEY);
    }

    public void endHandleCreation() {
        this.handleCreationCosts.update(this.stopTimer(HANDLE_CREATION_KEY));
    }

    public void startFileFlush() {
        this.startTimer(FILE_FLUSH_KEY);
    }

    public void endFileFlush() {
        long costs = this.stopTimer(FILE_FLUSH_KEY);
        this.fileFlushCost.update(costs);
        this.fileFlushTotalCosts += costs;
    }

    public void resetAfterCommit() {
        this.writtenRecords = 0L;
        this.numOfFilesWritten = 0L;
        this.numOfOpenHandle = 0L;
        this.writeBufferedSize = 0L;
        this.fileFlushTotalCosts = 0L;
    }
}

