/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import org.apache.flink.table.types.logical.LogicalType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImplicitTypeConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ImplicitTypeConverter.class);

    public static Serializable convertImplicitly(LogicalType literalType, Serializable literal) {
        try {
            switch (literalType.getTypeRoot()) {
                case BOOLEAN: {
                    if (literal instanceof Boolean) {
                        return literal;
                    }
                    return Boolean.valueOf(String.valueOf(literal));
                }
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: {
                    if (literal instanceof Integer) {
                        return literal;
                    }
                    return Integer.valueOf(String.valueOf(literal));
                }
                case BIGINT: {
                    if (literal instanceof Long) {
                        return literal;
                    }
                    if (literal instanceof Integer) {
                        return new Long(((Integer)literal).intValue());
                    }
                    return Long.valueOf(String.valueOf(literal));
                }
                case FLOAT: {
                    if (literal instanceof Float) {
                        return literal;
                    }
                    return Float.valueOf(String.valueOf(literal));
                }
                case DOUBLE: {
                    if (literal instanceof Double) {
                        return literal;
                    }
                    return Double.valueOf(String.valueOf(literal));
                }
                case BINARY: 
                case VARBINARY: {
                    if (literal instanceof byte[]) {
                        return literal;
                    }
                    return String.valueOf(literal).getBytes();
                }
                case DATE: {
                    if (literal instanceof LocalDate) {
                        return Integer.valueOf((int)((LocalDate)literal).toEpochDay());
                    }
                    if (literal instanceof Integer) {
                        return literal;
                    }
                    if (literal instanceof Long) {
                        return Integer.valueOf(((Long)literal).intValue());
                    }
                    return Integer.valueOf((int)LocalDate.parse(String.valueOf(literal)).toEpochDay());
                }
                case CHAR: 
                case VARCHAR: {
                    if (literal instanceof String) {
                        return literal;
                    }
                    return String.valueOf(literal);
                }
                case TIME_WITHOUT_TIME_ZONE: {
                    if (literal instanceof LocalTime) {
                        return Integer.valueOf(((LocalTime)literal).get(ChronoField.MILLI_OF_DAY));
                    }
                    if (literal instanceof Integer) {
                        return literal;
                    }
                    if (literal instanceof Long) {
                        return Integer.valueOf(((Long)literal).intValue());
                    }
                    return Integer.valueOf(LocalTime.parse(String.valueOf(literal)).get(ChronoField.MILLI_OF_DAY));
                }
                case TIMESTAMP_WITHOUT_TIME_ZONE: {
                    if (literal instanceof LocalDateTime) {
                        return Long.valueOf(((LocalDateTime)literal).toInstant(ZoneOffset.UTC).toEpochMilli());
                    }
                    if (literal instanceof Long) {
                        return literal;
                    }
                    if (literal instanceof Integer) {
                        return new Long(((Integer)literal).intValue());
                    }
                    return Long.valueOf(LocalDateTime.parse(String.valueOf(literal)).toInstant(ZoneOffset.UTC).toEpochMilli());
                }
            }
            return literal;
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to convert literal [{}] to type [{}]. Use its original type", (Object)literal, (Object)literalType);
            return literal;
        }
    }
}

