/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet.protobuf;

import org.apache.flink.formats.parquet.ParquetBuilder;
import org.apache.flink.formats.parquet.ParquetWriterFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.com.google.protobuf.Message;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.proto.ProtoWriteSupport;

public class ParquetProtoWriters {
    public static <T extends Message> ParquetWriterFactory<T> forType(Class<T> type) {
        ParquetBuilder builder = out -> new ParquetProtoWriterBuilder(out, type).build();
        return new ParquetWriterFactory(builder);
    }

    private ParquetProtoWriters() {
    }

    public static class ParquetProtoWriterBuilder<T extends Message>
    extends ParquetWriter.Builder<T, ParquetProtoWriterBuilder<T>> {
        private final Class<T> clazz;

        public ParquetProtoWriterBuilder(OutputFile outputFile, Class<T> clazz) {
            super(outputFile);
            this.clazz = clazz;
        }

        @Override
        protected ParquetProtoWriterBuilder<T> self() {
            return this;
        }

        @Override
        protected WriteSupport<T> getWriteSupport(Configuration conf) {
            return new ProtoWriteSupport(this.clazz);
        }
    }
}

