/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.model;

import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.types.RowKind;
import org.apache.hudi.common.model.HoodieOperation;

public abstract class AbstractHoodieRowData
implements RowData {
    private final String[] metaColumns;
    protected final RowData row;
    protected final int metaColumnsNum;

    public AbstractHoodieRowData(String commitTime, String commitSeqNumber, String recordKey, String partitionPath, String fileName, RowData row, boolean withOperation) {
        this.metaColumnsNum = withOperation ? 6 : 5;
        this.metaColumns = new String[this.metaColumnsNum];
        this.metaColumns[0] = commitTime;
        this.metaColumns[1] = commitSeqNumber;
        this.metaColumns[2] = recordKey;
        this.metaColumns[3] = partitionPath;
        this.metaColumns[4] = fileName;
        if (withOperation) {
            this.metaColumns[5] = HoodieOperation.fromValue(row.getRowKind().toByteValue()).getName();
        }
        this.row = row;
    }

    public RowKind getRowKind() {
        return this.row.getRowKind();
    }

    public void setRowKind(RowKind kind) {
        this.row.setRowKind(kind);
    }

    public boolean isNullAt(int ordinal) {
        if (ordinal < this.metaColumnsNum) {
            return null == this.getMetaColumnVal(ordinal);
        }
        return this.row.isNullAt(this.rebaseOrdinal(ordinal));
    }

    public boolean getBoolean(int ordinal) {
        return this.row.getBoolean(this.rebaseOrdinal(ordinal));
    }

    public byte getByte(int ordinal) {
        return this.row.getByte(this.rebaseOrdinal(ordinal));
    }

    public short getShort(int ordinal) {
        return this.row.getShort(this.rebaseOrdinal(ordinal));
    }

    public int getInt(int ordinal) {
        return this.row.getInt(this.rebaseOrdinal(ordinal));
    }

    public long getLong(int ordinal) {
        return this.row.getLong(this.rebaseOrdinal(ordinal));
    }

    public float getFloat(int ordinal) {
        return this.row.getFloat(this.rebaseOrdinal(ordinal));
    }

    public double getDouble(int ordinal) {
        return this.row.getDouble(this.rebaseOrdinal(ordinal));
    }

    public DecimalData getDecimal(int ordinal, int precision, int scale) {
        return this.row.getDecimal(this.rebaseOrdinal(ordinal), precision, scale);
    }

    public TimestampData getTimestamp(int ordinal, int precision) {
        return this.row.getTimestamp(this.rebaseOrdinal(ordinal), precision);
    }

    public <T> RawValueData<T> getRawValue(int ordinal) {
        return this.row.getRawValue(this.rebaseOrdinal(ordinal));
    }

    public StringData getString(int ordinal) {
        if (ordinal < this.metaColumnsNum) {
            return StringData.fromString((String)this.getMetaColumnVal(ordinal));
        }
        return this.row.getString(this.rebaseOrdinal(ordinal));
    }

    public byte[] getBinary(int ordinal) {
        return this.row.getBinary(this.rebaseOrdinal(ordinal));
    }

    public RowData getRow(int ordinal, int numFields) {
        return this.row.getRow(this.rebaseOrdinal(ordinal), numFields);
    }

    public ArrayData getArray(int ordinal) {
        return this.row.getArray(this.rebaseOrdinal(ordinal));
    }

    public MapData getMap(int ordinal) {
        return this.row.getMap(this.rebaseOrdinal(ordinal));
    }

    private String getMetaColumnVal(int ordinal) {
        return this.metaColumns[ordinal];
    }

    protected abstract int rebaseOrdinal(int var1);
}

