/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import org.apache.hudi.ApiMaturityLevel;
import org.apache.hudi.PublicAPIClass;
import org.apache.hudi.PublicAPIMethod;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieSchemaEvolutionConflictException;
import org.apache.hudi.exception.HoodieWriteConflictException;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.table.HoodieTable;

@PublicAPIClass(maturity=ApiMaturityLevel.EVOLVING)
public interface SchemaConflictResolutionStrategy {
    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public Option<Schema> resolveConcurrentSchemaEvolution(HoodieTable var1, HoodieWriteConfig var2, Option<HoodieInstant> var3, Option<HoodieInstant> var4);

    public static void throwConcurrentSchemaEvolutionException(Option<Schema> tableSchemaAtTxnStart, Option<Schema> tableSchemaAtTxnValidation, Schema writerSchemaOfTxn, Option<HoodieInstant> lastCompletedTxnOwnerInstant, Option<HoodieInstant> currTxnOwnerInstant) throws HoodieWriteConflictException {
        String errMsg = String.format("Detected incompatible concurrent schema evolution. Schema when transaction starts: %s, schema when transaction enters validation phase: %s tableSchemaAtTxnValidation, schema the transaction tries to commit with: %s. lastCompletedTxnOwnerInstant is %s  and currTxnOwnerInstant is %s.", tableSchemaAtTxnStart.isPresent() ? tableSchemaAtTxnStart : "Not exists as no commited txn at that time", tableSchemaAtTxnValidation.isPresent() ? tableSchemaAtTxnValidation : "Not exists", writerSchemaOfTxn, lastCompletedTxnOwnerInstant.isPresent() ? lastCompletedTxnOwnerInstant : "Not exists", currTxnOwnerInstant.isPresent() ? currTxnOwnerInstant : "Not exists");
        throw new HoodieSchemaEvolutionConflictException(errMsg);
    }
}

