/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import java.util.stream.Stream;
import org.apache.hudi.avro.AvroSchemaComparatorForSchemaEvolution;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.transaction.ConcurrentSchemaEvolutionTableSchemaGetter;
import org.apache.hudi.client.transaction.SchemaConflictResolutionStrategy;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSchemaConflictResolutionStrategy
implements SchemaConflictResolutionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleSchemaConflictResolutionStrategy.class);

    @Override
    public Option<Schema> resolveConcurrentSchemaEvolution(HoodieTable table, HoodieWriteConfig config, Option<HoodieInstant> lastCompletedTxnOwnerInstant, Option<HoodieInstant> currTxnOwnerInstant) {
        Option<Schema> tableSchemaAtTxnStart;
        if (!currTxnOwnerInstant.isPresent() || currTxnOwnerInstant.get().getAction().equals("compaction") || ClusteringUtils.isClusteringInstant(table.getMetaClient().getActiveTimeline(), currTxnOwnerInstant.get(), table.getMetaClient().getInstantGenerator())) {
            return Option.empty();
        }
        if (StringUtils.isNullOrEmpty(config.getWriteSchema())) {
            LOG.warn(StringUtils.join("Writer config does not come with a valid writer schema. Writer config: ", config.toString(), ". Owner instant: ", currTxnOwnerInstant.get().toString()));
            return Option.empty();
        }
        Schema writerSchemaOfTxn = new Schema.Parser().parse(config.getWriteSchema());
        ConcurrentSchemaEvolutionTableSchemaGetter schemaResolver = new ConcurrentSchemaEvolutionTableSchemaGetter(table.getMetaClient());
        if (HoodieAvroUtils.isSchemaNull(writerSchemaOfTxn)) {
            return SimpleSchemaConflictResolutionStrategy.getTableSchemaAtInstant(schemaResolver, currTxnOwnerInstant.get());
        }
        HoodieInstant lastCompletedInstantAtTxnStart = lastCompletedTxnOwnerInstant.isPresent() ? (HoodieInstant)this.getInstantInTimelineImmediatelyPriorToTimestamp(lastCompletedTxnOwnerInstant.get().getCompletionTime(), schemaResolver.computeSchemaEvolutionTimelineInReverseOrder()).orElse(null) : null;
        HoodieInstant lastCompletedInstantAtTxnValidation = schemaResolver.computeSchemaEvolutionTimelineInReverseOrder().findFirst().orElse(null);
        if (lastCompletedInstantAtTxnValidation == null) {
            return Option.of(writerSchemaOfTxn);
        }
        if (lastCompletedInstantAtTxnValidation.equals(lastCompletedInstantAtTxnStart)) {
            return Option.of(writerSchemaOfTxn);
        }
        Option<Schema> tableSchemaAtTxnValidation = SimpleSchemaConflictResolutionStrategy.getTableSchemaAtInstant(schemaResolver, lastCompletedInstantAtTxnValidation);
        if (!tableSchemaAtTxnValidation.isPresent()) {
            return Option.of(writerSchemaOfTxn);
        }
        boolean writerSchemaIsCurrentTableSchema = AvroSchemaComparatorForSchemaEvolution.schemaEquals(writerSchemaOfTxn, tableSchemaAtTxnValidation.get());
        if (writerSchemaIsCurrentTableSchema) {
            return Option.of(writerSchemaOfTxn);
        }
        if (lastCompletedInstantAtTxnStart == null) {
            SchemaConflictResolutionStrategy.throwConcurrentSchemaEvolutionException(Option.empty(), tableSchemaAtTxnValidation, writerSchemaOfTxn, lastCompletedTxnOwnerInstant, currTxnOwnerInstant);
        }
        if (!(tableSchemaAtTxnStart = SimpleSchemaConflictResolutionStrategy.getTableSchemaAtInstant(schemaResolver, lastCompletedInstantAtTxnStart)).isPresent()) {
            SchemaConflictResolutionStrategy.throwConcurrentSchemaEvolutionException(Option.empty(), tableSchemaAtTxnValidation, writerSchemaOfTxn, lastCompletedTxnOwnerInstant, currTxnOwnerInstant);
        }
        if (AvroSchemaComparatorForSchemaEvolution.schemaEquals(tableSchemaAtTxnStart.get(), tableSchemaAtTxnValidation.get())) {
            return Option.of(writerSchemaOfTxn);
        }
        if (AvroSchemaComparatorForSchemaEvolution.schemaEquals(writerSchemaOfTxn, tableSchemaAtTxnStart.get())) {
            return tableSchemaAtTxnValidation;
        }
        SchemaConflictResolutionStrategy.throwConcurrentSchemaEvolutionException(tableSchemaAtTxnStart, tableSchemaAtTxnValidation, writerSchemaOfTxn, lastCompletedTxnOwnerInstant, currTxnOwnerInstant);
        return Option.empty();
    }

    private Option<HoodieInstant> getInstantInTimelineImmediatelyPriorToTimestamp(String timestamp, Stream<HoodieInstant> reverseOrderTimeline) {
        return Option.fromJavaOptional(reverseOrderTimeline.filter(s -> InstantComparison.compareTimestamps(s.getCompletionTime(), InstantComparison.LESSER_THAN_OR_EQUALS, timestamp)).findFirst());
    }

    private static Option<Schema> getTableSchemaAtInstant(ConcurrentSchemaEvolutionTableSchemaGetter schemaResolver, HoodieInstant instant) {
        try {
            return schemaResolver.getTableAvroSchemaIfPresent(false, Option.of(instant));
        }
        catch (Exception ex) {
            LOG.error("Cannot get table schema for instant {}", (Object)instant);
            throw new HoodieException("Unable to get table schema", ex);
        }
    }
}

